/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.config;

import cn.com.yusys.yusp.commons.job.core.executor.XxlJobExecutor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(name={"application.xxl.job.enabled"}, havingValue="true")
public class XxlJobClientAutoConfiguration {
    private Logger logger = LoggerFactory.getLogger(XxlJobClientAutoConfiguration.class);
    @Value(value="${application.xxl.job.admin.addresses}")
    private String adminAddresses;
    @Value(value="${application.xxl.job.executor.appname}")
    private String appName;
    @Value(value="${application.xxl.job.executor.ip}")
    private String ip;
    @Value(value="${application.xxl.job.executor.port}")
    private int port;
    @Value(value="${application.xxl.job.executor.logpath}")
    private String logPath;
    @Value(value="${application.xxl.job.executor.logretentiondays}")
    private int logRetentionDays;

    @Bean(initMethod="start", destroyMethod="destroy")
    public XxlJobExecutor xxlJobExecutor() throws IOException {
        this.logger.info(">>>>>>>>>>> xxl-job config init.");
        XxlJobExecutor xxlJobExecutor = new XxlJobExecutor();
        xxlJobExecutor.setAdminAddresses(this.adminAddresses);
        xxlJobExecutor.setAppName(this.appName);
        xxlJobExecutor.setIp(this.ip);
        xxlJobExecutor.setPort(this.port);
        xxlJobExecutor.setLogPath(this.logPath);
        xxlJobExecutor.setLogRetentionDays(this.logRetentionDays);
        return xxlJobExecutor;
    }
}

