/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.thread;

import cn.com.yusys.yusp.commons.job.core.biz.AdminBiz;
import cn.com.yusys.yusp.commons.job.core.biz.model.HandleCallbackParam;
import cn.com.yusys.yusp.commons.job.core.biz.model.ReturnT;
import cn.com.yusys.yusp.commons.job.core.executor.XxlJobExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerCallbackThread {
    private static Logger logger = LoggerFactory.getLogger(TriggerCallbackThread.class);
    private static TriggerCallbackThread instance = new TriggerCallbackThread();
    private LinkedBlockingQueue<HandleCallbackParam> callBackQueue = new LinkedBlockingQueue();
    private Thread triggerCallbackThread;
    private volatile boolean toStop = false;

    public static TriggerCallbackThread getInstance() {
        return instance;
    }

    public static void pushCallBack(HandleCallbackParam callback) {
        TriggerCallbackThread.getInstance().callBackQueue.add(callback);
        logger.debug(">>>>>>>>>>> job, push callback request, logId:{}", (Object)callback.getLogId());
    }

    public void start() {
        if (XxlJobExecutor.getAdminBizList() == null) {
            logger.warn(">>>>>>>>>>> job, executor callback config fail, adminAddresses is null.");
            return;
        }
        this.triggerCallbackThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!TriggerCallbackThread.this.toStop) {
                    try {
                        HandleCallbackParam callback = (HandleCallbackParam)TriggerCallbackThread.getInstance().callBackQueue.take();
                        if (callback == null) continue;
                        ArrayList<HandleCallbackParam> callbackParamList = new ArrayList<HandleCallbackParam>();
                        int drainToNum = TriggerCallbackThread.getInstance().callBackQueue.drainTo(callbackParamList);
                        callbackParamList.add(callback);
                        if (callbackParamList == null || callbackParamList.size() <= 0) continue;
                        TriggerCallbackThread.this.doCallback(callbackParamList);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    ArrayList callbackParamList = new ArrayList();
                    int drainToNum = TriggerCallbackThread.getInstance().callBackQueue.drainTo(callbackParamList);
                    if (callbackParamList != null && callbackParamList.size() > 0) {
                        TriggerCallbackThread.this.doCallback(callbackParamList);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                logger.info(">>>>>>>>>>> job, executor callback thread destory.");
            }
        });
        this.triggerCallbackThread.setDaemon(true);
        this.triggerCallbackThread.start();
    }

    public void toStop() {
        this.toStop = true;
        this.triggerCallbackThread.interrupt();
        try {
            this.triggerCallbackThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void doCallback(List<HandleCallbackParam> callbackParamList) {
        for (AdminBiz adminBiz : XxlJobExecutor.getAdminBizList()) {
            try {
                ReturnT<String> callbackResult = adminBiz.callback(callbackParamList);
                if (callbackResult != null && "200".equals(callbackResult.getCode())) {
                    callbackResult = ReturnT.SUCCESS;
                    logger.debug(">>>>>>>>>>> job callback success, callbackParamList:{}, callbackResult:{}", new Object[]{callbackParamList, callbackResult});
                    break;
                }
                logger.info(">>>>>>>>>>> job callback fail, callbackParamList:{}, callbackResult:{}", new Object[]{callbackParamList, callbackResult});
            }
            catch (Exception e) {
                logger.error(">>>>>>>>>>> job callback error, callbackParamList\uff1a{}", callbackParamList, (Object)e);
            }
        }
    }
}

