/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.fastdfs;

import cn.com.yusys.yusp.commons.file.FileManagementClient;
import cn.com.yusys.yusp.commons.file.fastdfs.ClientGlobal;
import cn.com.yusys.yusp.commons.file.fastdfs.NameValuePair;
import cn.com.yusys.yusp.commons.file.fastdfs.StorageClient1;
import cn.com.yusys.yusp.commons.file.fastdfs.StorageServer;
import cn.com.yusys.yusp.commons.file.fastdfs.TrackerClient;
import cn.com.yusys.yusp.commons.file.fastdfs.TrackerServer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastDFSClient
implements FileManagementClient {
    private final Logger log = LoggerFactory.getLogger(FastDFSClient.class);
    private StorageClient1 storageClient;
    private TrackerServer trackerServer;
    private StorageServer storageServer;
    private String serverIp = null;
    private String trackers = null;
    private InputStream inputStream;

    public void init(String trackers) {
        this.log.debug("Set trackerip:" + trackers);
        this.trackers = trackers;
    }

    public void initConnection() {
        try {
            this.log.debug("Initialize connection start:trackerip->" + this.trackers);
            ClientGlobal.initByTrackers(this.trackers);
            TrackerClient trackerClient = new TrackerClient(ClientGlobal.g_tracker_group);
            this.trackerServer = trackerClient.getConnection();
            if (this.trackerServer == null) {
                throw new Exception("Failed to get storage server, trackerServer stage");
            }
            this.storageServer = trackerClient.getStoreStorage(this.trackerServer);
            if (this.storageServer == null) {
                throw new Exception("Failed to get storage server, StorageServer stage");
            }
            InetSocketAddress socketAddress = this.storageServer.getInetSocketAddress();
            this.serverIp = socketAddress.getHostString();
            this.storageClient = new StorageClient1(this.trackerServer, this.storageServer);
            this.log.debug("Get storage server successfully:" + this.serverIp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeConnection() {
        if (this.storageServer != null) {
            try {
                this.storageServer.close();
                if (Objects.nonNull(this.inputStream)) {
                    this.inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.trackerServer != null) {
            try {
                this.trackerServer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String uploadFile(File file) {
        return this.uploadFile(file, null);
    }

    public String uploadFile(File file, Map<String, String> metaList) {
        FileInputStream fileInputStream = null;
        try {
            String fileExtName = file.getName().substring(file.getName().lastIndexOf(".") + 1);
            fileInputStream = new FileInputStream(file);
            byte[] buff = this.fileToByte(fileInputStream, file.length());
            String string = this.uploadFile(buff, fileExtName, metaList);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String uploadFile(byte[] buff, String fileExtName, Map<String, String> fileInfo) {
        try {
            NameValuePair[] nameValuePairs = null;
            if (fileInfo != null) {
                nameValuePairs = new NameValuePair[fileInfo.size()];
                int index = 0;
                for (Map.Entry<String, String> entry : fileInfo.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    nameValuePairs[index++] = new NameValuePair(name, value);
                }
            }
            return this.storageClient.upload_file1(buff, fileExtName, nameValuePairs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String uploadFileByGroup(String groupName, byte[] buff, String fileExtName, NameValuePair[] nameValuePairs) {
        try {
            return this.storageClient.upload_appender_file1(groupName, buff, fileExtName, nameValuePairs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getFileInfo(String fileId) {
        try {
            NameValuePair[] metaList = this.storageClient.get_metadata1(fileId);
            if (metaList != null) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                for (NameValuePair metaItem : metaList) {
                    map.put(metaItem.getName(), metaItem.getValue());
                    System.out.println(metaItem.getName() + ":" + metaItem.getValue());
                }
                return map;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return null;
    }

    public int updateFileInfo(String fileId, Map<String, String> fileInfos) {
        try {
            if (fileInfos != null) {
                NameValuePair[] nameValuePairs = new NameValuePair[fileInfos.size()];
                int index = 0;
                for (Map.Entry<String, String> entry : fileInfos.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    nameValuePairs[index++] = new NameValuePair(name, value);
                }
                return this.storageClient.set_metadata1(fileId, nameValuePairs, (byte)77);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return -1;
    }

    public int deleteFile(String fileId) {
        this.checkFileId(fileId);
        try {
            return this.storageClient.delete_file1(fileId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public int downloadFile(String fileId, File outFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InputStream downloadLargeFile(String fileId) {
        this.checkFileId(fileId);
        try {
            String httpAddress = "http://" + this.serverIp + "/" + fileId;
            URL url = new URL(httpAddress);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection httpurlconnection = (HttpURLConnection)urlConnection;
            httpurlconnection.setRequestProperty("Charset", "UTF-8");
            httpurlconnection.connect();
            this.inputStream = httpurlconnection.getInputStream();
            return this.inputStream;
        }
        catch (Exception e) {
            this.log.error("FastDFS download large file error:" + e.getMessage() + "{}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] downloadFile(String fileId) {
        this.checkFileId(fileId);
        try {
            String httpAddress = "http://" + this.serverIp + "/" + fileId;
            System.out.println(httpAddress);
            URL url = new URL(httpAddress);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            int fileLength = httpURLConnection.getContentLength();
            return this.fileToByte(httpURLConnection.getInputStream(), fileLength);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private byte[] fileToByte(InputStream inStream, long fileLength) throws IOException {
        byte[] buffer = new byte[262144];
        byte[] fileBuffer = new byte[(int)fileLength];
        int count = 0;
        int length = 0;
        while ((length = inStream.read(buffer)) != -1) {
            for (int i = 0; i < length; ++i) {
                fileBuffer[count + i] = buffer[i];
            }
            count += length;
        }
        return fileBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void byteToFile(byte[] buf, File file) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void checkFileId(String fileId) {
        String upMenu = "../";
        String currentMenu = "./";
        if (fileId.contains(upMenu) || fileId.contains(currentMenu)) {
            throw new RuntimeException("Illegal file id");
        }
    }
}

