/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.disk;

import cn.com.yusys.yusp.commons.file.FileManagementClient;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDiskClient
implements FileManagementClient {
    private final Logger log = LoggerFactory.getLogger(LocalDiskClient.class);
    private String rootFolder = null;
    private int subFolderNum = 20;
    private InputStream inputStream;

    public void init(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    public void initConnection() {
        if (this.rootFolder.endsWith("/") || this.rootFolder.endsWith("\\")) {
            this.rootFolder = this.rootFolder.substring(0, this.rootFolder.length() - 1);
        }
        this.createFolder(this.rootFolder);
    }

    private void createFolder(String folder) {
        File rfolder = new File(folder);
        if (!rfolder.exists()) {
            this.log.info(folder + " Folder does not exist, will be created automatically");
            if (rfolder.mkdirs()) {
                this.log.info(folder + " create folder successfully");
            } else {
                this.log.error(folder + " create folder failed");
            }
        }
    }

    public void closeConnection() {
        try {
            if (Objects.nonNull(this.inputStream)) {
                this.inputStream.close();
            }
        }
        catch (Exception e) {
            this.log.error("Error closing output stream " + e.getMessage() + "{}" + e);
        }
    }

    public String uploadFile(File file) {
        return this.uploadFile(file, null);
    }

    public String uploadFile(File file, Map<String, String> metaList) {
        FileInputStream fileInputStream = null;
        try {
            String fileExtName = file.getName().substring(file.getName().lastIndexOf(".") + 1);
            fileInputStream = new FileInputStream(file);
            byte[] buff = this.fileToByte(fileInputStream, file.length());
            String string = this.uploadFile(buff, fileExtName, metaList);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String uploadFile(byte[] buff, String fileExtName, Map<String, String> fileInfo) {
        int subFolder = new Random().nextInt(this.subFolderNum);
        int subSubFolder = new Random().nextInt(this.subFolderNum);
        String subFolderT = "" + subFolder + "/" + subSubFolder;
        String folder = this.rootFolder + "/" + subFolderT;
        this.createFolder(folder);
        String newFileName = this.generateNewFileName(fileExtName);
        File temp = new File(folder + "/" + newFileName);
        LocalDiskClient.byteToFile(buff, temp);
        return subFolderT + "/" + newFileName;
    }

    public Map<String, String> getFileInfo(String fileId) {
        this.log.error("This method is not supported for local disk storage: getFileInfo(String fileId)");
        return null;
    }

    public int updateFileInfo(String fileId, Map<String, String> fileInfos) {
        this.log.error("This method is not supported for local disk storage: updateFileInfo(String fileId, Map<String, String> fileInfos)");
        return 1;
    }

    public int deleteFile(String fileId) {
        this.checkFileId(fileId);
        File file = new File(this.rootFolder + "/" + fileId);
        if (file.exists()) {
            if (!file.delete()) {
                this.log.error(fileId + "Delete file failed");
                return 1;
            }
        } else {
            this.log.error(fileId + " File does not exist, delete failed");
            return 1;
        }
        this.log.debug(fileId + "Delete file successfully");
        return 0;
    }

    /*
     * Exception decompiling
     */
    public int downloadFile(String fileId, File outFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InputStream downloadLargeFile(String fileId) {
        this.checkFileId(fileId);
        File file = new File(this.rootFolder + "/" + fileId);
        if (file.exists()) {
            try {
                this.inputStream = new FileInputStream(file);
                return this.inputStream;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.log.error(fileId + " File does not exist, download failed");
        return null;
    }

    public byte[] downloadFile(String fileId) {
        this.checkFileId(fileId);
        File file = new File(this.rootFolder + "/" + fileId);
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                byte[] byArray = this.fileToByte(fileInputStream, file.length());
                return byArray;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.log.error(fileId + " File does not exist, download failed");
        return null;
    }

    private byte[] fileToByte(InputStream inStream, long fileLength) throws IOException {
        byte[] buffer = new byte[262144];
        byte[] fileBuffer = new byte[(int)fileLength];
        int count = 0;
        int length = 0;
        while ((length = inStream.read(buffer)) != -1) {
            for (int i = 0; i < length; ++i) {
                fileBuffer[count + i] = buffer[i];
            }
            count += length;
        }
        return fileBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void byteToFile(byte[] buf, File file) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String generateNewFileName(String fileExtName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String currentTime = df.format(new Date());
        if (null == fileExtName || "".equals(fileExtName)) {
            return currentTime + "-" + UUID.randomUUID().toString().toUpperCase().replace("-", "").substring(0, 8);
        }
        return currentTime + "-" + UUID.randomUUID().toString().toUpperCase().replace("-", "").substring(0, 8) + "." + fileExtName;
    }

    private void checkFileId(String fileId) {
        String upMenu = "../";
        String currentMenu = "./";
        if (fileId.contains(upMenu) || fileId.contains(currentMenu)) {
            throw new RuntimeException("Illegal file id");
        }
    }
}

