/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file;

import cn.com.yusys.yusp.commons.config.ApplicationProperties;
import cn.com.yusys.yusp.commons.file.ClientFactory;
import cn.com.yusys.yusp.commons.file.FileManagementClient;
import cn.com.yusys.yusp.commons.file.disk.LocalDiskClient;
import cn.com.yusys.yusp.commons.file.fastdfs.FastDFSClient;
import org.springframework.beans.factory.annotation.Autowired;

public class FileManagementClientFactory
implements ClientFactory {
    @Autowired
    ApplicationProperties applicationProperties;
    FileManagementClient fileManagementCilent = null;

    public FileManagementClient getFileManagementClient() {
        String clientType = this.applicationProperties.getFile().getFileStorageType();
        return this.getFileManagementClient(clientType);
    }

    public FileManagementClient getFileManagementClient(String clientType) {
        if ("fastdfs".equalsIgnoreCase(clientType)) {
            FastDFSClient fastDFSClient = new FastDFSClient();
            fastDFSClient.init(this.applicationProperties.getFile().getFastdfsTrackIp());
            return fastDFSClient;
        }
        if ("localdisk".equalsIgnoreCase(clientType)) {
            LocalDiskClient localDiskClient = new LocalDiskClient();
            localDiskClient.init(this.applicationProperties.getFile().getLocalDiskPath());
            return localDiskClient;
        }
        return null;
    }

    public FileManagementClient getFileManagementClient(String clientType, String connectionParam) {
        if ("fastdfs".equalsIgnoreCase(clientType)) {
            FastDFSClient fastDFSClient = new FastDFSClient();
            fastDFSClient.init(connectionParam);
            return fastDFSClient;
        }
        if ("localdisk".equalsIgnoreCase(clientType)) {
            LocalDiskClient localDiskClient = new LocalDiskClient();
            localDiskClient.init(connectionParam);
            return localDiskClient;
        }
        return null;
    }
}

