/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.fastdfs;

import cn.com.yusys.yusp.commons.file.FileManagementClient;
import cn.com.yusys.yusp.commons.file.fastdfs.ClientGlobal;
import cn.com.yusys.yusp.commons.file.fastdfs.NameValuePair;
import cn.com.yusys.yusp.commons.file.fastdfs.StorageClient1;
import cn.com.yusys.yusp.commons.file.fastdfs.StorageServer;
import cn.com.yusys.yusp.commons.file.fastdfs.TrackerClient;
import cn.com.yusys.yusp.commons.file.fastdfs.TrackerServer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastDFSClient
implements FileManagementClient {
    private final Logger log = LoggerFactory.getLogger(FastDFSClient.class);
    private StorageClient1 storageClient;
    private TrackerServer trackerServer;
    private String serverIp = null;
    private String trackers = null;

    public void init(String trackers) {
        this.log.debug("\u8bbe\u7f6etrackerip:" + trackers);
        this.trackers = trackers;
    }

    public void initConnection() {
        try {
            this.log.debug("\u521d\u59cb\u5316\u8fde\u63a5\u5f00\u59cb:trackerip->" + this.trackers);
            ClientGlobal.initByTrackers(this.trackers);
            TrackerClient trackerClient = new TrackerClient(ClientGlobal.g_tracker_group);
            this.trackerServer = trackerClient.getConnection();
            if (this.trackerServer == null) {
                throw new Exception("\u83b7\u53d6\u5b58\u50a8\u670d\u52a1\u5668\u5931\u8d25\uff0ctrackerServer\u9636\u6bb5");
            }
            StorageServer storageServer = trackerClient.getStoreStorage(this.trackerServer);
            if (storageServer == null) {
                throw new Exception("\u83b7\u53d6\u5b58\u50a8\u670d\u52a1\u5668\u5931\u8d25\uff0cStorageServer\u9636\u6bb5");
            }
            InetSocketAddress socketAddress = storageServer.getInetSocketAddress();
            this.serverIp = socketAddress.getHostString();
            this.storageClient = new StorageClient1(this.trackerServer, storageServer);
            this.log.debug("\u83b7\u53d6\u5b58\u50a8 \u670d\u52a1\u5668\u6210\u529f:" + this.serverIp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeConnection() {
        if (this.trackerServer != null) {
            try {
                this.trackerServer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String uploadFile(File file) {
        return this.uploadFile(file, null);
    }

    public String uploadFile(File file, Map<String, String> metaList) {
        FileInputStream fileInputStream = null;
        try {
            String fileExtName = file.getName().substring(file.getName().lastIndexOf(".") + 1);
            fileInputStream = new FileInputStream(file);
            byte[] buff = this.fileToByte(fileInputStream, file.length());
            String string = this.uploadFile(buff, fileExtName, metaList);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String uploadFile(byte[] buff, String fileExtName, Map<String, String> fileInfo) {
        try {
            NameValuePair[] nameValuePairs = null;
            if (fileInfo != null) {
                nameValuePairs = new NameValuePair[fileInfo.size()];
                int index = 0;
                for (Map.Entry<String, String> entry : fileInfo.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    nameValuePairs[index++] = new NameValuePair(name, value);
                }
            }
            return this.storageClient.upload_file1(buff, fileExtName, nameValuePairs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String uploadFileByGroup(String groupName, byte[] buff, String fileExtName, NameValuePair[] nameValuePairs) {
        try {
            return this.storageClient.upload_appender_file1(groupName, buff, fileExtName, nameValuePairs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getFileInfo(String fileId) {
        try {
            NameValuePair[] metaList = this.storageClient.get_metadata1(fileId);
            if (metaList != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (NameValuePair metaItem : metaList) {
                    map.put(metaItem.getName(), metaItem.getValue());
                    System.out.println(metaItem.getName() + ":" + metaItem.getValue());
                }
                return map;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return null;
    }

    public int updateFileInfo(String fileId, Map<String, String> fileInfos) {
        try {
            NameValuePair[] nameValuePairs = null;
            if (fileInfos != null) {
                nameValuePairs = new NameValuePair[fileInfos.size()];
                int index = 0;
                for (Map.Entry<String, String> entry : fileInfos.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    nameValuePairs[index++] = new NameValuePair(name, value);
                }
                return this.storageClient.set_metadata1(fileId, nameValuePairs, (byte)77);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return -1;
    }

    public int deleteFile(String fileId) {
        try {
            return this.storageClient.delete_file1(fileId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public int downloadFile(String fileId, File outFile) {
        FileOutputStream fos = null;
        try {
            byte[] content = this.downloadFile(fileId);
            fos = new FileOutputStream(outFile);
            FastDFSClient.byteToFile(content, outFile);
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public byte[] downloadFile(String fileId) {
        try {
            String httpAddress = "http://" + this.serverIp + "/" + fileId;
            System.out.println(httpAddress);
            URL url = new URL(httpAddress);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            int fileLength = httpURLConnection.getContentLength();
            return this.fileToByte(httpURLConnection.getInputStream(), fileLength);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private byte[] fileToByte(InputStream inStream, long fileLength) throws IOException {
        byte[] buffer = new byte[262144];
        byte[] fileBuffer = new byte[(int)fileLength];
        int count = 0;
        int length = 0;
        while ((length = inStream.read(buffer)) != -1) {
            for (int i = 0; i < length; ++i) {
                fileBuffer[count + i] = buffer[i];
            }
            count += length;
        }
        return fileBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void byteToFile(byte[] buf, File file) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

