/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.web.rest;

import cn.com.yusys.yusp.commons.excel.ExcelConstant;
import cn.com.yusys.yusp.commons.excel.ExcelRemoteCall;
import cn.com.yusys.yusp.commons.excel.ExcelTaskManager;
import cn.com.yusys.yusp.commons.excel.ExcelUtil;
import cn.com.yusys.yusp.commons.file.ClientFactory;
import cn.com.yusys.yusp.commons.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.MimeMappingUtils;
import cn.com.yusys.yusp.commons.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;

public class IoResourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(IoResourceFactory.class);
    @Autowired
    ExcelTaskManager excelTaskManager;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    ClientFactory fileManagementCilentFactory;
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Autowired(required=false)
    ExcelRemoteCall excelRemoteCall;

    public void export(QueryModel queryModel, HttpServletRequest request, HttpServletResponse response, String exportSql, String pojoClassName) throws IOException {
        logger.info("Start exporting excel");
        try {
            SqlSession sqlSession = this.sqlSessionFactory.openSession();
            List list = sqlSession.selectList(exportSql, (Object)queryModel);
            if (sqlSession != null) {
                sqlSession.clearCache();
                sqlSession.close();
            }
            StringBuffer sb = new StringBuffer();
            logger.info("Start creating workbook!");
            Workbook book = ExcelUtil.createWorkBook(list, ExcelConstant.BATCH_SIZE, pojoClassName, sb, true, true, this.excelRemoteCall);
            logger.info("Create workbook successfully: {}", (Object)book);
            if (StringUtil.isEmpty((CharSequence)sb)) {
                sb.append("\u7a7a");
            }
            String fileName = sb + ".xlsx";
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                logger.info("Start writing data");
                response.setContentType(MimeMappingUtils.getMimeType((String)fileName));
                response.setHeader("Content-Disposition", "attachment; filename=" + MimeMappingUtils.getEncodeFileName((HttpServletRequest)request, (String)fileName));
                book.write((OutputStream)os);
                byte[] bytes = os.toByteArray();
                response.getOutputStream().write(bytes);
                response.getOutputStream().flush();
                logger.info("Write data successfully!");
            }
        }
        catch (Exception e) {
            response.sendError(500, e.getMessage());
        }
    }

    public String asyncExport(QueryModel queryModel, Integer fetchSize, String exportSql, String pojoClassName) {
        logger.debug("Add excel export task to asynchronous export task pool--");
        String taskId = this.excelTaskManager.addExcelExportTask(exportSql, fetchSize, queryModel, pojoClassName);
        return taskId;
    }
}

