/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.text.write;

import cn.com.yusys.yusp.commons.text.Record;
import cn.com.yusys.yusp.commons.text.write.ExportFileConfig;
import cn.com.yusys.yusp.commons.util.BeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ExportAnalyser {
    public static String getWriterData(Object dataObject, String templateName, String dataSplit, boolean existKey, String keyValueSplit) throws Exception {
        List<Record> records = ExportFileConfig.instance().getTemplateRecords(templateName);
        return ExportAnalyser.getWriterData(dataObject, records, dataSplit, existKey, keyValueSplit);
    }

    public static String getWriterData(Object dataObject, List<Record> records, String dataSplit, boolean existKey, String keyValueSplit) throws Exception {
        if (Objects.nonNull(records) && !records.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < records.size(); ++i) {
                Record record = records.get(i);
                if (existKey) {
                    sb.append(record.getAliasName()).append(keyValueSplit);
                }
                sb.append(record.getDataValue(BeanUtil.getProptery((Object)dataObject, (String)record.getName())));
                if (i >= records.size() - 1) continue;
                sb.append(dataSplit);
            }
            return sb.toString();
        }
        return null;
    }

    public static List<String> getWriterDatas(Collection<Object> dataObjects, String templateName, String dataSplit, boolean existKey, String keyValueSplit) throws Exception {
        ArrayList<String> list = new ArrayList<String>(dataObjects.size());
        List<Record> records = ExportFileConfig.instance().getTemplateRecords(templateName);
        if (Objects.nonNull(dataObjects) && !dataObjects.isEmpty()) {
            for (Object dataObject : dataObjects) {
                String dataString = ExportAnalyser.getWriterData(dataObject, records, dataSplit, existKey, keyValueSplit);
                list.add(dataString);
            }
        }
        return list;
    }
}

