/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.text.read;

import cn.com.yusys.yusp.commons.text.TextConfig;
import cn.com.yusys.yusp.commons.text.read.ImportAnalyser;
import cn.com.yusys.yusp.commons.util.FileUtil;
import cn.com.yusys.yusp.commons.util.StringUtil;
import java.io.BufferedReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class ImportReader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> List<T> importFile(TextConfig textConfig, Integer currPage, Integer size, Class<T> clazz) throws Exception {
        if (!FileUtil.isFile((String)textConfig.getFilePath())) return Collections.EMPTY_LIST;
        LinkedList<String> listData = new LinkedList();
        if (currPage == null || size == null) {
            listData = FileUtil.readAllLines((String)textConfig.getFilePath(), (String)textConfig.getCharset());
        } else {
            int currLine = ImportReader.getNextLineNumber(currPage, size);
            boolean isComplete = false;
            try (BufferedReader reader = Files.newBufferedReader(Paths.get(textConfig.getFilePath(), new String[0]), Charset.forName(textConfig.getCharset()));){
                String line;
                int i2;
                for (i2 = 0; i2 < currLine; ++i2) {
                    line = reader.readLine();
                    if (!StringUtil.isEmpty((CharSequence)line)) continue;
                    isComplete = true;
                    break;
                }
                if (isComplete) {
                    List i2 = Collections.EMPTY_LIST;
                    return i2;
                }
                for (i2 = 0; i2 < size && !StringUtil.isEmpty((CharSequence)(line = reader.readLine())); ++i2) {
                    listData.add(line);
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ImportReader.class).error(e.getMessage(), (Throwable)e);
            }
        }
        if (!clazz.isAssignableFrom(String.class)) return ImportAnalyser.getReadData(listData, textConfig.getTempleteId(), textConfig.getDataSplit(), StringUtil.isNotEmpty((CharSequence)textConfig.getKeyValueSplit()), textConfig.getKeyValueSplit(), clazz);
        return listData;
    }

    private static int getNextLineNumber(int currPage, int size) {
        return (currPage > 0 ? currPage - 1 : 0) * size;
    }
}

