/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.text.cache;

import cn.com.yusys.yusp.commons.text.cache.Cache;
import cn.com.yusys.yusp.commons.text.cache.CacheInitialize;
import cn.com.yusys.yusp.commons.util.StringUtil;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCache
implements Cache {
    private static Logger logger = LoggerFactory.getLogger(DefaultCache.class);
    private static Map<String, Object> cacheMap = new ConcurrentHashMap<String, Object>();
    private Map<String, CacheInitialize> initCaches;

    @Override
    public <T> T get(String key) {
        return (T)cacheMap.get(key);
    }

    @Override
    public void add(String cacheKey, String key, Object value) {
        Object object = cacheMap.get(cacheKey);
        if (Objects.nonNull(object)) {
            if (object instanceof Map) {
                Map keyMap = (Map)object;
                keyMap.put(key, value);
            }
        } else {
            ConcurrentHashMap<String, Object> keyMap = new ConcurrentHashMap<String, Object>();
            keyMap.put(key, value);
            cacheMap.put(cacheKey, keyMap);
        }
    }

    @Override
    public void add(String cacheKey, Object cacheValue) {
        Object object = cacheMap.get(cacheKey);
        if (!Objects.equals(object, cacheValue)) {
            cacheMap.remove(cacheKey);
            cacheMap.put(cacheKey, cacheValue);
        }
    }

    @Override
    public boolean containsKey(String key) {
        return cacheMap.containsKey(key);
    }

    @Override
    public boolean reload() {
        this.destory();
        this.load();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reload(String cacheKey) {
        logger.info("Cache\uff1a" + cacheKey + "reload start......");
        CacheInitialize cacheInit = this.initCaches.get(cacheKey);
        if (Objects.nonNull(cacheInit)) {
            Object cacheValue = cacheInit.getInitCacheData();
            if (Objects.nonNull(cacheValue)) {
                Map<String, Object> map = cacheMap;
                synchronized (map) {
                    cacheMap.remove(cacheKey);
                    cacheMap.put(cacheKey, cacheValue);
                }
                logger.info("Cache\uff1a" + cacheKey + "reload end......");
            } else {
                logger.warn("Cache\uff1a" + cacheKey + " Reload return object is empty, this reload will be abandoned!");
            }
        } else {
            logger.warn("There is no corresponding loading object for the cache :" + cacheKey + " to be reloaded at present!");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load() {
        if (Objects.nonNull(this.initCaches) && !this.initCaches.isEmpty()) {
            Map<String, Object> map = cacheMap;
            synchronized (map) {
                for (Map.Entry<String, CacheInitialize> entry : this.initCaches.entrySet()) {
                    String cacheKey = entry.getKey();
                    logger.info("Cache:" + cacheKey + " . Load cache data start......");
                    Object cacheValue = entry.getValue().getInitCacheData();
                    if (Objects.nonNull(cacheValue) && StringUtil.isNotEmpty((CharSequence)cacheKey)) {
                        this.add(cacheKey, cacheValue);
                        logger.info("Cache:" + cacheKey + " . Load cache data start......");
                        continue;
                    }
                    logger.warn("The key or value returned by the cache is empty. Discard!");
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destory() {
        Map<String, Object> map = cacheMap;
        synchronized (map) {
            cacheMap.clear();
        }
    }

    public Map<String, CacheInitialize> getInitCaches() {
        return this.initCaches;
    }

    public void setInitCaches(Map<String, CacheInitialize> initCaches) {
        this.initCaches = initCaches;
    }
}

