/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.pdf;

import cn.com.yusys.yusp.commons.util.BeanUtil;
import cn.com.yusys.yusp.commons.util.StringUtil;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class PdfReaderUtil {
    private static final Logger logger = LoggerFactory.getLogger(PdfReaderUtil.class);

    public static <T> List<T> readerPdf(String path, String tableName, boolean ignoreTableHeader, List<String> columnSeq, Class<T> clazz) throws Exception {
        LinkedList<T> list = new LinkedList<T>();
        List<String> datas = PdfReaderUtil.reader(path);
        boolean isStart = false;
        for (int i = 0; i < datas.size(); ++i) {
            String data = StringUtil.trim((String)datas.get(i));
            if (Objects.equals(tableName, data)) {
                isStart = true;
                continue;
            }
            if (!isStart) continue;
            if (ignoreTableHeader) {
                ignoreTableHeader = false;
                continue;
            }
            T header = PdfReaderUtil.parseLineText(data, columnSeq, clazz);
            if (!Objects.nonNull(header)) continue;
            list.add(header);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static List<String> reader(String path) throws Exception {
        try (PDDocument document = PDDocument.load((InputStream)ResourceUtils.getURL((String)path).openStream());){
            int pages = document.getNumberOfPages();
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setSortByPosition(true);
            stripper.setStartPage(1);
            stripper.setEndPage(pages);
            String content = stripper.getText(document);
            List<String> list = Arrays.asList(content.split("\\n", -1));
            return list;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private static <T> T parseLineText(String text, List<String> columnSeq, Class<T> clazz) throws Exception {
        String[] texts = text.split(" ", -1);
        if (texts.length != columnSeq.size()) {
            logger.warn("Intercept length mismatch!");
            return null;
        }
        Object object = BeanUtil.newInstance(clazz);
        for (int i = 0; i < columnSeq.size(); ++i) {
            BeanUtil.setProptery((Object)object, (String)columnSeq.get(i), (Object)texts[i]);
        }
        return (T)object;
    }
}

