/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excel;

import cn.com.yusys.yusp.commons.domain.ExcelColumnDomain;
import cn.com.yusys.yusp.commons.excel.ExcelConstant;
import cn.com.yusys.yusp.commons.excel.ExcelImportExportUtil;
import cn.com.yusys.yusp.commons.excel.ExcelRemoteCall;
import cn.com.yusys.yusp.commons.excel.annotation.ExcelName;
import cn.com.yusys.yusp.commons.file.ClientFactory;
import cn.com.yusys.yusp.commons.file.FileManagementClient;
import cn.com.yusys.yusp.commons.mapper.QueryModel;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;

public class ExcelExportThread
implements Runnable {
    String sqlId;
    Integer fetchSize;
    QueryModel queryModel;
    String taskId;
    Class<?> clazz;
    StringRedisTemplate redisTemplate;
    SqlSessionFactory sqlSessionFactory;
    ExcelRemoteCall excelRemoteCall;
    List<?> dataList;
    ClientFactory clientFactory;
    private long timeout;

    public ExcelExportThread(List<?> dataList, String taskId, Class<?> clazz, StringRedisTemplate redisTemplate, ExcelRemoteCall excelRemoteCall, ClientFactory clientFactory, long timeout) {
        this.clazz = clazz;
        this.taskId = taskId;
        this.dataList = dataList;
        this.redisTemplate = redisTemplate;
        this.excelRemoteCall = excelRemoteCall;
        this.clientFactory = clientFactory;
        this.timeout = timeout;
    }

    public ExcelExportThread(String sqlId, Integer fetchSize, QueryModel queryModel, String taskId, Class<?> clazz, StringRedisTemplate redisTemplate, SqlSessionFactory sqlSessionFactory, ExcelRemoteCall excelRemoteCall, ClientFactory clientFactory, long timeout) {
        this.sqlId = sqlId;
        this.fetchSize = fetchSize;
        this.taskId = taskId;
        this.clazz = clazz;
        this.redisTemplate = redisTemplate;
        this.sqlSessionFactory = sqlSessionFactory;
        this.queryModel = queryModel;
        this.excelRemoteCall = excelRemoteCall;
        this.timeout = timeout;
        this.clientFactory = clientFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SqlSession sqlSession = null;
        SXSSFWorkbook wb = null;
        FileOutputStream fileOut = null;
        File file = null;
        FileManagementClient fastDFSClient = this.clientFactory.getFileManagementClient();
        String fileName = "ExportExcel";
        String sheetName = "DataTable";
        try {
            if (this.clazz.isAnnotationPresent(ExcelName.class)) {
                ExcelName classAnnotation = this.clazz.getDeclaredAnnotation(ExcelName.class);
                fileName = classAnnotation.value();
                sheetName = classAnnotation.sheet();
            }
            if (!fileName.endsWith(".xlsx")) {
                fileName = fileName + ".xlsx";
            }
            Map<String, ExcelColumnDomain> columnMap = ExcelImportExportUtil.getColumnMap(this.clazz);
            wb = new SXSSFWorkbook(100);
            SXSSFSheet sheet = wb.createSheet(sheetName);
            Row titleRow = sheet.createRow(0);
            CellStyle cellStyle = wb.createCellStyle();
            cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            ExcelImportExportUtil.assembleTitle(titleRow, cellStyle, columnMap);
            if (null != this.sqlSessionFactory && null != this.sqlId) {
                sqlSession = this.sqlSessionFactory.openSession();
                Page page = PageHelper.startPage((int)0, (int)1);
                if (this.queryModel == null) {
                    this.queryModel = new QueryModel();
                }
                sqlSession.selectList(this.sqlId, (Object)this.queryModel);
                int totalCount = new Long(page.getTotal()).intValue();
                PageHelper.clearPage();
                if (null != this.fetchSize && this.fetchSize < totalCount) {
                    totalCount = this.fetchSize;
                }
                int queryTimes = totalCount % ExcelConstant.BATCH_SIZE == 0 ? totalCount / ExcelConstant.BATCH_SIZE : totalCount / ExcelConstant.BATCH_SIZE + 1;
                for (int i = 0; i < queryTimes; ++i) {
                    PageHelper.startPage((int)(i + 1), (int)ExcelConstant.BATCH_SIZE);
                    List resultBatchList = sqlSession.selectList(this.sqlId, (Object)this.queryModel);
                    PageHelper.clearPage();
                    ExcelImportExportUtil.assembleData(resultBatchList, (Sheet)sheet, i * ExcelConstant.BATCH_SIZE, this.fetchSize, columnMap, this.clazz, this.excelRemoteCall);
                    resultBatchList.clear();
                    int percent = ExcelImportExportUtil.getPercentInt(i + 1, queryTimes);
                    percent = percent == 100 ? 99 : percent;
                    ExcelImportExportUtil.updateRedisTaskInfo(this.taskId, "export", percent, fileName, null, this.redisTemplate, this.timeout);
                }
            } else if (!CollectionUtils.isEmpty(this.dataList)) {
                ExcelImportExportUtil.assembleData(this.dataList, (Sheet)sheet, 1, this.fetchSize, columnMap, this.clazz, this.excelRemoteCall);
                ExcelImportExportUtil.updateRedisTaskInfo(this.taskId, "export", 99, fileName, null, this.redisTemplate, this.timeout);
            }
            String completFilePath = ExcelConstant.EXCEL_FILE_DIR + this.taskId + "_" + fileName;
            fileOut = new FileOutputStream(completFilePath);
            wb.write((OutputStream)fileOut);
            file = new File(completFilePath);
            fastDFSClient.initConnection();
            String fastDFSUuid = fastDFSClient.uploadFile(file);
            ExcelImportExportUtil.updateRedisTaskInfo(this.taskId, "export", 100, fileName, fastDFSUuid, this.redisTemplate, this.timeout);
        }
        catch (Exception e) {
            e.printStackTrace();
            ExcelImportExportUtil.updateRedisTaskInfo(this.taskId, "export", -1, fileName, null, this.redisTemplate, this.timeout);
        }
        finally {
            try {
                if (null != fastDFSClient) {
                    fastDFSClient.closeConnection();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (null != sqlSession) {
                    sqlSession.clearCache();
                    sqlSession.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (null != fileOut) {
                    fileOut.close();
                }
                if (null != wb) {
                    wb.dispose();
                    wb.close();
                }
                if (null != file && file.exists()) {
                    file.delete();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

