/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.text.cache;

import cn.com.yusys.yusp.commons.text.cache.Cache;
import cn.com.yusys.yusp.commons.util.StringUtil;
import java.util.Map;
import java.util.Objects;

public final class CacheManager {
    private static Cache cache;

    public CacheManager(Cache cache) {
        CacheManager.cache = cache;
    }

    private static final void assertCache() throws Exception {
        if (Objects.isNull(cache)) {
            throw new IllegalAccessException("Cache not initialize!");
        }
    }

    public static final <T> T getCacheMap(String cacheKey) throws Exception {
        CacheManager.assertCache();
        if (StringUtil.isNotEmpty((CharSequence)cacheKey)) {
            return cache.get(cacheKey);
        }
        return null;
    }

    public static final <T> T getCacheObject(String cacheKey, String objectkey) throws Exception {
        Map cacheObjectMap = (Map)CacheManager.getCacheMap(cacheKey);
        if (Objects.nonNull(cacheObjectMap) && !cacheObjectMap.isEmpty() && StringUtil.isNotEmpty((CharSequence)objectkey)) {
            return (T)cacheObjectMap.get(objectkey);
        }
        return null;
    }

    public static final void addCache(String cacheKey, Object value) throws Exception {
        CacheManager.assertCache();
        cache.add(cacheKey, value);
    }
}

