/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excel;

import cn.com.yusys.yusp.commons.config.ApplicationProperties;
import cn.com.yusys.yusp.commons.excel.ExcelConstant;
import cn.com.yusys.yusp.commons.excel.ExcelExportThread;
import cn.com.yusys.yusp.commons.excel.ExcelImportExportUtil;
import cn.com.yusys.yusp.commons.excel.ExcelImportThread;
import cn.com.yusys.yusp.commons.excel.ExcelPrimaryId;
import cn.com.yusys.yusp.commons.excel.ExcelRemoteCall;
import cn.com.yusys.yusp.commons.excel.ExcelTaskManager;
import cn.com.yusys.yusp.commons.file.ClientFactory;
import cn.com.yusys.yusp.commons.mapper.QueryModel;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.multipart.MultipartFile;

public class ExcelTaskManagerMybatisImpl
implements ExcelTaskManager,
InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(ExcelTaskManagerMybatisImpl.class);
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Autowired
    Executor taskExecutor;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    ApplicationProperties applicationProperties;
    @Autowired
    ClientFactory fileManagementClientFactory;
    @Autowired(required=false)
    ExcelRemoteCall excelRemoteCall;
    @Autowired(required=false)
    ExcelPrimaryId excelPrimaryId;

    @Override
    public String addExcelExportTask(String sqlId, Integer fetchSize, QueryModel queryModel, String clazzName) {
        String taskId = "failure";
        taskId = ExcelImportExportUtil.addRedisTaskInfo("export", this.stringRedisTemplate);
        try {
            Class<?> clazz = Class.forName(clazzName);
            ExcelExportThread exportTask = new ExcelExportThread(sqlId, fetchSize, queryModel, taskId, clazz, this.stringRedisTemplate, this.sqlSessionFactory, this.excelRemoteCall, this.fileManagementClientFactory);
            this.taskExecutor.execute(exportTask);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return taskId;
    }

    @Override
    public String addExcelExportTaskByDataList(List<?> dataList, Integer fetchSize, QueryModel queryModel, String clazzName) {
        String taskId = "failure";
        taskId = ExcelImportExportUtil.addRedisTaskInfo("export", this.stringRedisTemplate);
        try {
            Class<?> clazz = Class.forName(clazzName);
            ExcelExportThread exportTask = new ExcelExportThread(dataList, taskId, clazz, this.stringRedisTemplate, this.excelRemoteCall, this.fileManagementClientFactory);
            this.taskExecutor.execute(exportTask);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return taskId;
    }

    @Override
    public String addExcelImportTask(MultipartFile file, String clazzName, String sqlId) {
        return this.addExcelImportTask(file, clazzName, sqlId, null);
    }

    @Override
    public String addExcelImportTask(MultipartFile file, String clazzName, String sqlId, Map<String, Object> param) {
        String taskId = "failure";
        try {
            String fileName = this.generateImportFile(file);
            Class<?> clazz = Class.forName(clazzName);
            taskId = ExcelImportExportUtil.addRedisTaskInfo("import", this.stringRedisTemplate);
            ExcelImportThread importTask = new ExcelImportThread(fileName, taskId, sqlId, clazz, this.stringRedisTemplate, this.sqlSessionFactory, this.excelRemoteCall, this.excelPrimaryId, param);
            this.taskExecutor.execute(importTask);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            this.logger.error(e.getMessage());
        }
        return taskId;
    }

    private String generateImportFile(MultipartFile file) throws IOException {
        String fileName = file.getOriginalFilename();
        String fileNameExt = fileName.substring(fileName.lastIndexOf(".") + 1);
        fileName = System.currentTimeMillis() + "_import." + fileNameExt;
        File newFile = new File(ExcelConstant.EXCEL_FILE_DIR + fileName);
        file.transferTo(newFile);
        return fileName;
    }

    public void afterPropertiesSet() throws Exception {
        File fileDir;
        String excelFileDir = this.applicationProperties.getExcel().getTempFileDir();
        if (excelFileDir != null && !(fileDir = new File(ExcelConstant.EXCEL_FILE_DIR = excelFileDir.endsWith("/") || excelFileDir.endsWith("\\") ? excelFileDir : excelFileDir + File.separator)).exists()) {
            fileDir.mkdir();
        }
        ExcelConstant.BATCH_SIZE = this.applicationProperties.getExcel().getBatchSize();
    }
}

