/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.web.rest;

import cn.com.yusys.yusp.commons.excel.ExcelConstant;
import cn.com.yusys.yusp.commons.excel.ExcelTaskManager;
import cn.com.yusys.yusp.commons.excel.ExcelUtil;
import cn.com.yusys.yusp.commons.file.ClientFactory;
import cn.com.yusys.yusp.commons.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.MimeMappingUtils;
import cn.com.yusys.yusp.commons.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;

public class IoResourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(IoResourceFactory.class);
    @Autowired
    ExcelTaskManager excelTaskManager;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    ClientFactory fileManagementCilentFactory;
    @Autowired
    SqlSessionFactory sqlSessionFactory;

    public void export(QueryModel queryModel, HttpServletRequest request, HttpServletResponse response, String exportSql, String pojoClassName) throws IOException {
        logger.info("\u5f00\u59cb\u5bfc\u51faexcel");
        try {
            SqlSession sqlSession = this.sqlSessionFactory.openSession();
            List list = sqlSession.selectList(exportSql, (Object)queryModel);
            if (sqlSession != null) {
                sqlSession.clearCache();
                sqlSession.close();
            }
            StringBuffer sb = new StringBuffer();
            logger.info("\u5f00\u59cb\u521b\u5efa\u5de5\u4f5c\u7c3f!");
            Workbook book = ExcelUtil.createWorkBook(list, ExcelConstant.BATCH_SIZE, pojoClassName, sb, true, true);
            logger.info("\u6210\u529f\u521b\u5efa\u5de5\u4f5c\u7c3f:{}", (Object)book);
            if (StringUtil.isEmpty((CharSequence)sb)) {
                sb.append("\u7a7a");
            }
            String fileName = sb + ".xlsx";
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                logger.info("\u5f00\u59cb\u5199\u5165\u6570\u636e");
                response.setContentType(MimeMappingUtils.getMimeType((String)fileName));
                response.setHeader("Content-Disposition", "attachment; filename=" + MimeMappingUtils.getEncodeFileName((HttpServletRequest)request, (String)fileName));
                book.write((OutputStream)os);
                byte[] bytes = os.toByteArray();
                response.getOutputStream().write(bytes);
                response.getOutputStream().flush();
                logger.info("\u5199\u5165\u6570\u636e\u6210\u529f!");
            }
        }
        catch (Exception e) {
            response.sendError(500, e.getMessage());
        }
    }

    public String asyncExport(QueryModel queryModel, Integer fetchSize, String exportSql, String pojoClassName) {
        logger.debug("\u5c06excel\u5bfc\u51fa\u4efb\u52a1\u6dfb\u52a0\u5230\u5f02\u6b65\u5bfc\u51fa\u4efb\u52a1\u6c60--");
        String taskId = this.excelTaskManager.addExcelExportTask(exportSql, fetchSize, queryModel, pojoClassName);
        return taskId;
    }
}

