/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.view;

import cn.com.yusys.yusp.commons.view.AbstractPdfView;
import cn.com.yusys.yusp.commons.view.STSongFont;
import com.itextpdf.text.Document;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

public class PdfView
extends AbstractPdfView {
    public PdfView() {
    }

    public PdfView(String tempName) {
        super(tempName);
    }

    @Override
    protected void buildPdfDocument(Map<String, Object> model, Document document, PdfWriter writer, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewTemplateName = this.getTemplateName();
        String templateContentType = this.getContentType();
        String fileName = "";
        String downloadFileName = this.getDownloadFileName();
        boolean isOnlineBrowse = this.getIsOnlineBrowse();
        if (viewTemplateName == null) {
            throw new IllegalArgumentException("Property 'templateName' is required");
        }
        if (templateContentType != null) {
            response.setContentType(templateContentType);
        } else {
            response.setContentType("application/pdf;charset=UTF-8");
        }
        if (downloadFileName == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            fileName = sdf.format(new Date()) + ".pdf";
        } else {
            fileName = !downloadFileName.endsWith(".pdf") ? downloadFileName + ".pdf" : downloadFileName;
        }
        if (isOnlineBrowse) {
            response.setHeader("Content-Disposition", "inline;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        } else {
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        }
        ServletContext servletContext = request.getServletContext();
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        WebContext webctx = new WebContext(request, response, servletContext, request.getLocale(), model);
        StringWriter stringWriter = new StringWriter();
        SpringTemplateEngine springTemplateEngine = (SpringTemplateEngine)webApplicationContext.getBean(SpringTemplateEngine.class);
        springTemplateEngine.process(viewTemplateName, (IContext)webctx, (Writer)stringWriter);
        String htmlStr = stringWriter.toString();
        XMLWorkerHelper.getInstance().parseXHtml(writer, document, (InputStream)new ByteArrayInputStream(htmlStr.getBytes()), Charset.defaultCharset(), (FontProvider)new STSongFont());
    }
}

