/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excel;

import cn.com.yusys.yusp.commons.excel.ExcelConstant;
import cn.com.yusys.yusp.commons.excel.ExcelImportExportUtil;
import cn.com.yusys.yusp.commons.excel.ExcelPrimaryId;
import cn.com.yusys.yusp.commons.excel.ExcelRemoteCall;
import com.monitorjbl.xlsx.StreamingReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class ExcelImportThread
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(ExcelImportThread.class);
    String fileName;
    StringRedisTemplate stringRedisTemplate;
    String sqlId;
    String taskId;
    Class<?> clazz;
    SqlSessionFactory sqlSessionFactory;
    ExcelRemoteCall excelRemoteCall;
    ExcelPrimaryId excelPrimaryId;

    public ExcelImportThread(String fileName, String taskId, String sqlId, Class<?> clazz, StringRedisTemplate stringRedisTemplate, SqlSessionFactory sqlSessionFactory, ExcelRemoteCall excelRemoteCall, ExcelPrimaryId excelPrimaryId) {
        this.fileName = fileName;
        this.taskId = taskId;
        this.sqlId = sqlId;
        this.clazz = clazz;
        this.stringRedisTemplate = stringRedisTemplate;
        this.sqlSessionFactory = sqlSessionFactory;
        this.excelRemoteCall = excelRemoteCall;
        this.excelPrimaryId = excelPrimaryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SqlSession sqlSession = null;
        File excelFile = null;
        InputStream inputStream = null;
        try {
            sqlSession = this.sqlSessionFactory.openSession();
            Map<Integer, Field> columnMap = ExcelImportExportUtil.getColumnIndexMap(this.clazz);
            excelFile = new File(ExcelConstant.EXCEL_FILE_DIR + this.fileName);
            inputStream = new FileInputStream(excelFile);
            Workbook workbook = StreamingReader.builder().rowCacheSize(100).bufferSize(4096).open(inputStream);
            int currentSheet = 1;
            int totalSheetNum = workbook.getNumberOfSheets();
            Iterator sheetIterator = workbook.sheetIterator();
            while (sheetIterator.hasNext()) {
                Sheet sheet = (Sheet)sheetIterator.next();
                int totalRowNum = sheet.getLastRowNum();
                Iterator rowIterator = sheet.rowIterator();
                while (rowIterator.hasNext()) {
                    Row row = (Row)rowIterator.next();
                    if (row.getRowNum() == 0) continue;
                    Object obj = this.clazz.newInstance();
                    Iterator cellIterator = row.cellIterator();
                    for (int index = 0; index < columnMap.keySet().size() && cellIterator.hasNext(); ++index) {
                        Cell cell = (Cell)cellIterator.next();
                        Field field = columnMap.get(index);
                        field.setAccessible(true);
                        ExcelImportExportUtil.setFieldValue(cell, field, obj, this.excelRemoteCall, this.excelPrimaryId);
                    }
                    sqlSession.insert(this.sqlId, obj);
                    if (row.getRowNum() % 2 != 0) continue;
                    int rowPercent = ExcelImportExportUtil.getPercentInt(row.getRowNum(), totalRowNum);
                    int sheetPercent = ExcelImportExportUtil.getPercentInt(currentSheet, totalSheetNum);
                    int totalPercent = ExcelImportExportUtil.getPercentInt(rowPercent * sheetPercent, 10000);
                    ExcelImportExportUtil.updateRedisTaskInfo(this.taskId, "import", totalPercent, this.fileName, null, this.stringRedisTemplate);
                }
                ++currentSheet;
            }
            ExcelImportExportUtil.updateRedisTaskInfo(this.taskId, "import", 100, this.fileName, null, this.stringRedisTemplate);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            e.printStackTrace();
            ExcelImportExportUtil.updateRedisTaskInfo(this.taskId, "import", -1, this.fileName, null, this.stringRedisTemplate);
        }
        finally {
            if (null != sqlSession) {
                sqlSession.close();
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != excelFile) {
                excelFile.delete();
            }
        }
    }
}

