/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.config.ApplicationProperties;
import cn.com.yusys.yusp.commons.config.FileManageAutoConfiguration;
import cn.com.yusys.yusp.commons.config.MyBatisExtendAutoConfiguration;
import cn.com.yusys.yusp.commons.excel.ExcelPrimaryId;
import cn.com.yusys.yusp.commons.excel.ExcelPrimaryIdDefaultImpl;
import cn.com.yusys.yusp.commons.excel.ExcelRemoteCall;
import cn.com.yusys.yusp.commons.excel.ExcelRemoteCallDefaultImpl;
import cn.com.yusys.yusp.commons.excel.ExcelTaskManager;
import cn.com.yusys.yusp.commons.excel.ExcelTaskManagerMybatisImpl;
import cn.com.yusys.yusp.commons.file.ClientFactory;
import cn.com.yusys.yusp.commons.web.rest.IoResourceFactory;
import java.util.concurrent.Executor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfigureAfter(value={MyBatisExtendAutoConfiguration.class, FileManageAutoConfiguration.class})
@EnableConfigurationProperties(value={ApplicationProperties.class})
@ConditionalOnProperty(name={"application.excel.enabled"}, havingValue="true")
public class ExcelTaskAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ExcelTaskAutoConfiguration.class);

    @Bean(name={"excelTaskManager"})
    @ConditionalOnBean(value={Executor.class, ClientFactory.class, SqlSessionFactory.class})
    public ExcelTaskManager getExcelTaskManager() {
        logger.info("\u57fa\u4e8emybatis\u7684ExcelTaskManager\u52a0\u8f7d\u6210\u529f");
        return new ExcelTaskManagerMybatisImpl();
    }

    @Bean(name={"excelRemoteCall"})
    @ConditionalOnMissingBean(value={ExcelRemoteCall.class})
    public ExcelRemoteCall getExcelRemoteCall() {
        logger.info("\u52a0\u8f7d\u7f3a\u7701\u7684ExcelRemoteCallDefaultImpl");
        return new ExcelRemoteCallDefaultImpl();
    }

    @Bean
    public IoResourceFactory ioResourceFactory() {
        return new IoResourceFactory();
    }

    @Bean(name={"excelPrimaryId"})
    @ConditionalOnMissingBean(value={ExcelPrimaryId.class})
    public ExcelPrimaryId getExcelPrimaryId() {
        logger.info("\u52a0\u8f7d\u7f3a\u7701\u7684ExcelPrimaryIdDefaultImpl");
        return new ExcelPrimaryIdDefaultImpl();
    }
}

