/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excel;

import cn.com.yusys.yusp.commons.domain.ExcelColumnDomain;
import cn.com.yusys.yusp.commons.excel.ExcelRemoteCall;
import cn.com.yusys.yusp.commons.excel.annotation.ExcelColumn;
import cn.com.yusys.yusp.commons.excel.annotation.ExcelColumnDateformat;
import cn.com.yusys.yusp.commons.excel.annotation.ExcelColumnDictCode;
import cn.com.yusys.yusp.commons.excel.annotation.ExcelColumnPricision;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ExcelImportExportUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelImportExportUtil.class);
    private static Map<String, Map<String, String>> dictCodeMap = new HashMap<String, Map<String, String>>();

    public static String addRedisTaskInfo(String taskType, StringRedisTemplate stringRedisTemplate) {
        String taskId = UUID.randomUUID().toString().toLowerCase().replace("-", "");
        JSONObject jo = new JSONObject();
        try {
            jo.put("taskType", (Object)taskType);
            jo.put("percent", 0);
        }
        catch (JSONException e) {
            logger.error("addRedisTaskInfo Error: " + e.getMessage(), (Throwable)e);
        }
        stringRedisTemplate.opsForValue().set((Object)taskId, (Object)jo.toString());
        return taskId;
    }

    public static void updateRedisTaskInfo(String taskId, String taskType, Integer percent, String fileName, String fastDFSUuid, StringRedisTemplate stringRedisTemplate) {
        JSONObject jo = new JSONObject();
        try {
            jo.put("taskType", (Object)taskType);
            jo.put("percent", (Object)percent);
            jo.put("fileName", (Object)fileName);
            if (!StringUtils.isEmpty((Object)fastDFSUuid)) {
                jo.put("fastDFSUuid", (Object)fastDFSUuid);
            }
        }
        catch (JSONException e) {
            logger.error("updateRedisTaskInfo Error: " + e.getMessage(), (Throwable)e);
        }
        stringRedisTemplate.opsForValue().set((Object)taskId, (Object)jo.toString());
    }

    public static JSONObject getRedisTaskInfo(String taskId, StringRedisTemplate stringRedisTemplate) {
        String result = (String)stringRedisTemplate.opsForValue().get((Object)taskId);
        JSONObject jo = new JSONObject();
        try {
            if (!StringUtils.isEmpty((Object)result)) {
                jo = new JSONObject(result);
            }
        }
        catch (JSONException e) {
            logger.error("getRedisTaskInfo Error: " + e.getMessage(), (Throwable)e);
        }
        return jo;
    }

    public static SXSSFWorkbook exportTemplate(Class<?> clazz) {
        SXSSFWorkbook wb = null;
        Map<String, ExcelColumnDomain> columnMap = ExcelImportExportUtil.getColumnMap(clazz);
        wb = new SXSSFWorkbook(100);
        SXSSFSheet sh = wb.createSheet();
        Row titleRow = sh.createRow(0);
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)12);
        cellStyle.setFont(font);
        ExcelImportExportUtil.assembleTitle(titleRow, cellStyle, columnMap);
        return wb;
    }

    public static Map<Integer, Field> getColumnIndexMap(Class<?> clazz) {
        Field[] declaredFields;
        HashMap<Integer, Field> columnMap = new HashMap<Integer, Field>();
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExcelColumn.class)) continue;
            ExcelColumn column = field.getAnnotation(ExcelColumn.class);
            columnMap.put(column.index(), field);
        }
        return columnMap;
    }

    public static Map<String, ExcelColumnDomain> getColumnMap(Class<?> clazz) {
        Field[] declaredFields;
        HashMap<String, ExcelColumnDomain> columnMap = new HashMap<String, ExcelColumnDomain>();
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            ExcelColumnDomain columnDomain = new ExcelColumnDomain();
            if (!field.isAnnotationPresent(ExcelColumn.class)) continue;
            ExcelColumn column = field.getAnnotation(ExcelColumn.class);
            columnDomain.setColumnTitle(column.title());
            columnDomain.setColumnIndex(column.index());
            if (field.isAnnotationPresent(ExcelColumnDateformat.class)) {
                ExcelColumnDateformat dateFormatAnno = field.getAnnotation(ExcelColumnDateformat.class);
                columnDomain.setDateFormat(dateFormatAnno.value());
            }
            if (field.isAnnotationPresent(ExcelColumnDictCode.class)) {
                ExcelColumnDictCode dictCodeAnno = field.getAnnotation(ExcelColumnDictCode.class);
                columnDomain.setDictCode(dictCodeAnno.value());
            }
            if (field.isAnnotationPresent(ExcelColumnPricision.class)) {
                ExcelColumnPricision pricisionAnno = field.getAnnotation(ExcelColumnPricision.class);
                columnDomain.setPricision(pricisionAnno.value());
            }
            columnMap.put(field.getName(), columnDomain);
        }
        return columnMap;
    }

    public static void assembleTitle(Row titleRow, CellStyle cellStyle, Map<String, ExcelColumnDomain> columnMap) {
        for (String key : columnMap.keySet()) {
            ExcelColumnDomain columnDomain = columnMap.get(key);
            Cell cell = titleRow.createCell(columnDomain.getColumnIndex().intValue());
            cell.setCellStyle(cellStyle);
            cell.setCellValue(columnDomain.getColumnTitle());
        }
    }

    public static void assembleData(List<?> dataList, Sheet sh, int currentRowIndex, Integer fetchSize, Map<String, ExcelColumnDomain> columnMap, Class<?> clazz, ExcelRemoteCall excelRemoteCall) {
        if (!CollectionUtils.isEmpty(dataList)) {
            try {
                for (int index = 0; index < dataList.size(); ++index) {
                    Row dataRow = sh.createRow(currentRowIndex + index + 1);
                    for (String fieldNameKey : columnMap.keySet()) {
                        Double tempNumber;
                        BigDecimal bg;
                        ExcelColumnDomain columnDomain = columnMap.get(fieldNameKey);
                        Cell dataCell = dataRow.createCell(columnDomain.getColumnIndex().intValue());
                        Field field = clazz.getDeclaredField(fieldNameKey);
                        field.setAccessible(true);
                        Object fieldValue = null;
                        Object pojoORMap = dataList.get(index);
                        if (null == pojoORMap) continue;
                        if (pojoORMap instanceof Map) {
                            Map objMap = (Map)dataList.get(index);
                            fieldValue = objMap.get(fieldNameKey);
                        } else if (pojoORMap.getClass().equals(clazz)) {
                            fieldValue = field.get(pojoORMap);
                        }
                        if (null == fieldValue) continue;
                        if (null != columnDomain.getDictCode()) {
                            String textValue = ExcelImportExportUtil.convertDictValueTextByCode(columnDomain.getDictCode(), String.valueOf(fieldValue), true, excelRemoteCall);
                            dataCell.setCellValue(textValue);
                            continue;
                        }
                        if (fieldValue instanceof Date) {
                            String formatStr = "yyyy-MM-dd HH:mm:ss";
                            if (null != columnDomain.getDateFormat()) {
                                formatStr = columnDomain.getDateFormat();
                            }
                            SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                            dataCell.setCellValue(sdf.format(fieldValue));
                            continue;
                        }
                        if (fieldValue instanceof Double || fieldValue instanceof Float) {
                            if (null != columnDomain.getPricision()) {
                                bg = new BigDecimal(String.valueOf(fieldValue));
                                tempNumber = bg.setScale((int)columnDomain.getPricision(), 4).doubleValue();
                                dataCell.setCellValue(tempNumber.doubleValue());
                                continue;
                            }
                            dataCell.setCellValue(String.valueOf(fieldValue));
                            continue;
                        }
                        if (null != columnDomain.getPricision()) {
                            bg = BigDecimal.valueOf(Double.parseDouble(String.valueOf(fieldValue)));
                            tempNumber = bg.setScale((int)columnDomain.getPricision(), 4).doubleValue();
                            dataCell.setCellValue(tempNumber.doubleValue());
                            continue;
                        }
                        dataCell.setCellValue(String.valueOf(fieldValue));
                    }
                    if (null == fetchSize || sh.getPhysicalNumberOfRows() - 1 != fetchSize) continue;
                    return;
                }
            }
            catch (Exception e) {
                logger.error("assembleData Error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setFieldValue(Cell cell, Field field, Object obj, ExcelRemoteCall excelRemoteCall) {
        if (null != cell) {
            try {
                if (!"General".equalsIgnoreCase(cell.getCellStyle().getDataFormatString()) && 0 != cell.getCellStyle().getDataFormat()) {
                    if (null != cell.getDateCellValue()) {
                        String formatStr = "yyyy-MM-dd HH:mm:ss";
                        if (field.isAnnotationPresent(ExcelColumnDateformat.class)) {
                            formatStr = field.getAnnotation(ExcelColumnDateformat.class).value();
                        }
                        Date cellDate = cell.getDateCellValue();
                        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                        if (field.getType().equals(Date.class)) {
                            field.set(obj, cellDate);
                        } else {
                            field.set(obj, sdf.format(cellDate));
                        }
                    }
                } else if (field.isAnnotationPresent(ExcelColumnPricision.class)) {
                    BigDecimal bg = new BigDecimal(Double.parseDouble(cell.getStringCellValue()));
                    int pricision = field.getAnnotation(ExcelColumnPricision.class).value();
                    Double tempNumber = bg.setScale(pricision, 4).doubleValue();
                    if (field.getType().equals(String.class)) {
                        field.set(obj, String.valueOf(tempNumber));
                    } else {
                        field.set(obj, tempNumber);
                    }
                } else if (field.isAnnotationPresent(ExcelColumnDictCode.class)) {
                    String dictCode = field.getAnnotation(ExcelColumnDictCode.class).value();
                    String dictText = cell.getStringCellValue();
                    String dictValue = ExcelImportExportUtil.convertDictValueTextByCode(dictCode, dictText, false, excelRemoteCall);
                    field.set(obj, dictValue);
                } else if (field.getType().equals(Double.class)) {
                    BigDecimal bg = new BigDecimal(Double.parseDouble(cell.getStringCellValue()));
                    field.set(obj, bg.doubleValue());
                } else if (field.getType().equals(Integer.class)) {
                    BigDecimal bg = new BigDecimal(Double.parseDouble(cell.getStringCellValue()));
                    field.set(obj, bg.intValue());
                } else if (field.getType().equals(Date.class)) {
                    String formatStr = "yyyy-MM-dd HH:mm:ss";
                    if (field.isAnnotationPresent(ExcelColumnDateformat.class)) {
                        formatStr = field.getAnnotation(ExcelColumnDateformat.class).value();
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                    field.set(obj, sdf.parse(cell.getStringCellValue()));
                } else {
                    field.set(obj, cell.getStringCellValue());
                }
            }
            catch (Exception e) {
                logger.error("setFieldValue Error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static String convertDictValueTextByCode(String dictCode, String key, Boolean valueToText, ExcelRemoteCall excelRemoteCall) {
        String result = key;
        if (null != excelRemoteCall) {
            try {
                Map<String, String> itemMap = dictCodeMap.get(dictCode);
                if (null == itemMap) {
                    itemMap = excelRemoteCall.getItemListBylookupcode(dictCode);
                    dictCodeMap.put(dictCode, itemMap);
                }
                if (null != itemMap && !itemMap.isEmpty()) {
                    if (valueToText.booleanValue()) {
                        if (itemMap.containsKey(key)) {
                            return itemMap.get(key);
                        }
                    } else {
                        for (Map.Entry<String, String> entry : itemMap.entrySet()) {
                            if (!key.equals(entry.getValue())) continue;
                            return entry.getKey();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("convertDictValueTextByCode Error: " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static Integer getPercentInt(int a, int b) {
        if (0 == b) {
            return 0;
        }
        double result = (double)a * 1.0 / ((double)b * 1.0);
        DecimalFormat decimalFormat = new DecimalFormat("#%");
        String percent = decimalFormat.format(result);
        return Integer.parseInt(percent.replace("%", ""));
    }
}

