/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.worker;

import cn.com.yusys.yusp.bsp.app.config.AppStartAssist;
import cn.com.yusys.yusp.bsp.app.config.BspAutoConfiguration;
import cn.com.yusys.yusp.bsp.communication.MapRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.dataformat.MsgConvertUtil;
import cn.com.yusys.yusp.bsp.filter.BspFilter;
import cn.com.yusys.yusp.bsp.filter.BspFilterResult;
import cn.com.yusys.yusp.bsp.filter.ExecutionStatus;
import cn.com.yusys.yusp.bsp.resources.ResourceException;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.ServiceEntity;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ExpressTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import cn.com.yusys.yusp.bsp.toolkit.reflect.BeanMapUtil;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.IService;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import cn.com.yusys.yusp.bsp.workflow.worker.AbstractDataProcess;
import cn.com.yusys.yusp.bsp.workflow.worker.AbstractWorker;
import cn.com.yusys.yusp.bsp.workflow.worker.IServiceUrl;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class BizWorker
extends AbstractWorker {
    private RestTemplate restTemplate = BspAutoConfiguration.getRestTemplateInstance();

    @Override
    protected boolean executeJob() throws Throwable {
        BeanMapUtil util = new BeanMapUtil();
        Map context = this.session.getContext();
        IServiceUrl serviceUrlProcess = this.msgConfig.getServiceUrl();
        AbstractDataProcess dataProcess = this.msgConfig.getDataProcess();
        if (this.session.getInRequest() instanceof MapRequest) {
            String tradeValue;
            String tradeCode = tradeValue = (String)context.get("G_TRANSCODE");
            ServiceEntity entity = null;
            if ("local".equals(this.serviceConfig.getServiceType())) {
                if (StringTools.isEmpty(tradeValue)) {
                    throw new Exception("Transaction code cannot be empty when calling local service");
                }
                entity = AppStartAssist.get_serviceEntityMap().get(tradeValue);
                if (entity == null) {
                    throw new Exception("The annotation corresponding to transaction [" + tradeValue + "] does not exist");
                }
                if (!StringTools.isEmpty(entity.getCode())) {
                    tradeCode = entity.getCode();
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("Get transaction code: [{}]", (Object)tradeCode);
            }
            if ("flow".equals(this.serviceConfig.getServiceType())) {
                IService service = null;
                try {
                    service = (IService)BspAutoConfiguration.applicationContext.getBean(IService.class);
                }
                catch (Exception e) {
                    throw new Exception("flow service not available");
                }
                Map inMap = (Map)context.get("__T_AUTOPACK");
                if (inMap == null) {
                    inMap = context;
                }
                Map<String, Object> outMap = service.execute(tradeCode, inMap);
                context.put((String)"__T_AUTOPACK", outMap);
                context.putAll(outMap);
            } else {
                Object inPara = null;
                Map inMap = (Map)context.get("__T_AUTOPACK");
                if (inMap == null) {
                    inMap = context;
                }
                inPara = util.mapToBean(inMap, entity.getParaType(), entity.getParameterType());
                Object outPara = entity.getMethod().invoke(entity.getBean(), inPara);
                Map<String, Object> outMap = util.beanToMap(outPara);
                context.put((String)"__T_AUTOPACK", outMap);
                context.putAll(outMap);
            }
        } else {
            Map inMap;
            String tradeValue;
            int remainLen;
            byte[] recvData = this.processRecv(this.session);
            if (dataProcess != null) {
                recvData = dataProcess.processRecvData(recvData, context);
            }
            Map<String, Object> unpackMap = null;
            int searchIndex = 0;
            if (!StringTools.isEmpty(this.msgConfig.getInputMsgType()) && !this.msgConfig.getInputMsgType().equals("NONE")) {
                unpackMap = MsgConvertUtil.unpackMsg(recvData, context, this.msgConfig.getInputMsgPath(), this.msgConfig.getInputMsgType(), this.msgConfig.getMsgEncode());
                searchIndex = (Integer)context.remove("__T_SEARCHINDEX");
            }
            if (searchIndex > 0 && (remainLen = recvData.length - searchIndex) > 0) {
                byte[] remainData = new byte[remainLen];
                System.arraycopy(recvData, searchIndex, remainData, 0, remainLen);
                recvData = remainData;
            }
            String tradeCode = tradeValue = ExpressTools.getStringValue(this.serviceConfig.getTradeCodeVar(), context);
            ServiceEntity entity = null;
            if ("local".equals(this.serviceConfig.getServiceType())) {
                if (StringTools.isEmpty(tradeValue)) {
                    throw new Exception("Transaction code cannot be empty when calling local service");
                }
                entity = AppStartAssist.get_serviceEntityMap().get(tradeValue);
                if (entity == null) {
                    throw new Exception("The annotation corresponding to transaction [" + tradeValue + "] does not exist");
                }
                if (!StringTools.isEmpty(entity.getCode())) {
                    tradeCode = entity.getCode();
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("Get transaction code: [{}]", (Object)tradeCode);
            }
            String reqMsgType = this.msgConfig.getReqMsgType();
            if (!(searchIndex < 0 || StringTools.isEmpty(tradeCode) || StringTools.isEmpty(reqMsgType) || reqMsgType.equals("NONE"))) {
                String reqMfd = String.valueOf(this.msgConfig.getInServicePath()) + tradeCode + "_in_req.mfd";
                Map<String, Object> unpackMapBody = MsgConvertUtil.unpackMsg(recvData, context, FileTools.isExist(reqMfd) ? reqMfd : null, this.msgConfig.getReqMsgType(), this.msgConfig.getMsgEncode());
                if (unpackMap == null) {
                    unpackMap = unpackMapBody;
                } else {
                    unpackMap.putAll(unpackMapBody);
                }
            }
            context.put((String)"__T_AUTOPACK", unpackMap);
            BspFilterResult result = this.executeBspFilter(this.msgConfig.getPreFilter(), context);
            if (result != null) {
                throw result.getException();
            }
            String serviceType = this.serviceConfig.getServiceType();
            if ("local".equals(serviceType)) {
                Object inPara = null;
                inMap = (Map)context.get("__T_AUTOPACK");
                if (inMap == null) {
                    inMap = context;
                }
                inPara = util.mapToBean(inMap, entity.getParaType(), entity.getParameterType());
                Object outPara = entity.getMethod().invoke(entity.getBean(), inPara);
                Map<String, Object> outMap = util.beanToMap(outPara);
                context.put("__T_AUTOPACK", outMap);
                context.putAll(outMap);
            } else if ("flow".equals(serviceType)) {
                IService service = null;
                try {
                    service = (IService)BspAutoConfiguration.applicationContext.getBean(IService.class);
                }
                catch (Exception e) {
                    throw new Exception("flow service not available");
                }
                inMap = (Map)context.get("__T_AUTOPACK");
                if (inMap == null) {
                    inMap = context;
                }
                Map<String, Object> outMap = service.execute(tradeCode, inMap);
                context.put("__T_AUTOPACK", outMap);
                context.putAll(outMap);
            } else if ("remote".equals(serviceType)) {
                inMap = (Map)context.get("__T_AUTOPACK");
                if (inMap == null) {
                    inMap = context;
                }
                String reqData = util.mapToJson(inMap);
                String url = "";
                url = serviceUrlProcess != null ? serviceUrlProcess.processServiceUrl(context, this.serviceConfig) : ("filePath".equals(this.serviceConfig.getServiceType()) ? this.mappingServiceUrl(tradeCode) : (String)OgnlTools.getValue(this.serviceConfig.getServiceName(), context));
                String retData = this.msInvoke(reqData, url);
                Map<String, Object> outMap = util.jsonToMap(retData);
                context.put("__T_AUTOPACK", outMap);
                context.putAll(outMap);
            } else {
                throw new Exception("Service type [" + serviceType + "] is not supported");
            }
            result = this.executeBspFilter(this.msgConfig.getPostFilter(), context);
            if (result != null) {
                throw result.getException();
            }
            String respMfd = String.valueOf(this.msgConfig.getInServicePath()) + tradeCode + "_in_resp.mfd";
            byte[] retData = MsgConvertUtil.packMsg(context, FileTools.isExist(respMfd) ? respMfd : null, this.msgConfig.getRespMsgType(), this.msgConfig.getMsgEncode());
            if (dataProcess != null) {
                retData = dataProcess.processSendData(retData, context);
            }
            this.processSend(this.session, retData);
        }
        return true;
    }

    private String mappingServiceUrl(String tradeCode) throws ResourceException {
        Properties properties = (Properties)ResourcePortal.getInstance().getResource("properties", String.valueOf(this.msgConfig.getInServicePath()) + "tradeMapping.properties");
        return properties.getProperty(tradeCode);
    }

    private BspFilterResult executeBspFilter(TreeSet<BspFilter> preFilter, Map<String, Object> context) {
        for (BspFilter bspFilter : preFilter) {
            try {
                BspFilterResult result = bspFilter.runFilter(context);
                if (result.getResult()) continue;
                return result;
            }
            catch (Exception e) {
                BspFilterResult result = new BspFilterResult(ExecutionStatus.FAILED);
                result.setException(e);
                return result;
            }
        }
        return null;
    }

    private String msInvoke(String reqData, String url) throws Exception {
        if (StringTools.isEmpty(url)) {
            throw new Exception("Microservice call @ request URL is empty");
        }
        if (!url.startsWith("http://")) {
            url = "http://" + url;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json;charset=UTF-8");
        headers.add("Accept", "application/json");
        HttpEntity httpEntity = new HttpEntity((Object)reqData, (MultiValueMap)headers);
        logger.info("Microservice call @ request URL [{}]", (Object)url);
        logger.info("Microservice call @ send data: \n{}", (Object)reqData);
        ResponseEntity ret = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        logger.info("Microservice call @ receive data: \n{}", ret.getBody());
        return (String)ret.getBody();
    }

    private byte[] processRecv(Session session) throws Exception {
        Map<String, Object> context = session.getContext();
        StreamRequest srt = (StreamRequest)session.getInRequest();
        Socket socket = this.parseDatasourceWrapper(srt);
        IComm comm = session.getComm();
        if (socket != null && comm != null) {
            try {
                byte[] byArray = comm.processRecv(context, srt);
                return byArray;
            }
            finally {
                if (!srt.isTimeStart()) {
                    srt.setTimeStart(true);
                    session.setTradeStartTime(System.currentTimeMillis());
                }
            }
        }
        throw new ComponentException("Communication configuration is not defined");
    }

    protected Socket parseDatasourceWrapper(StreamRequest srt) throws Exception {
        Object o = srt.getDatasourceWrapper();
        Socket socket = null;
        if (o instanceof SocketWrapper) {
            socket = ((SocketWrapper)o).getSocket();
        } else if (o instanceof Socket) {
            socket = (Socket)o;
        } else {
            throw new Exception("Streamrequest does not support the type [" + o.getClass().getName() + "] temporarily");
        }
        return socket;
    }
}

