/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.worker;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.dataformat.MsgConvertUtil;
import cn.com.yusys.yusp.bsp.resources.ExceptionAnalyzer;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.log.Slf4jSpanLogger;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.config.MsgConfig;
import cn.com.yusys.yusp.bsp.workflow.config.ServiceConfig;
import cn.com.yusys.yusp.bsp.workflow.worker.IWorker;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorker
implements IWorker {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractWorker.class);
    private static final Logger f5Logger = LoggerFactory.getLogger((String)"cn.com.yusys.yusp.bsp.workflow.worker.F5Logger");
    protected Session session;
    protected MsgConfig msgConfig;
    protected ServiceConfig serviceConfig;
    protected String publicIn;
    protected String publicOut;

    @Override
    public void run() {
        Slf4jSpanLogger spanLogger;
        block16: {
            block15: {
                spanLogger = new Slf4jSpanLogger();
                spanLogger.logStartedSpan(this.session.getSpan(), this.session.getSpan());
                if (this.session.getInRequest().isTimeStart()) {
                    this.session.setTradeStartTime(System.currentTimeMillis());
                }
                if (!this.session.isF5Check() || !this.f5Check()) break block15;
                if (this.session != null) {
                    this.session.destory();
                }
                return;
            }
            try {
                logger.info("Transaction begins");
                this.executeJob();
            }
            catch (IOException e) {
                logger.error("Transaction exception", (Throwable)e);
                this.session.getInRequest().setCloseFlag(true);
                if (this.session != null) {
                    this.session.destory();
                }
                break block16;
            }
            catch (Throwable t) {
                try {
                    logger.error("Transaction exception", t);
                    this.session.getInRequest().setCloseFlag(true);
                    ExceptionAnalyzer.setContextExceptionInfos(this.session, t, null);
                    if (!StringTools.isEmpty(this.msgConfig.getInErrorPath())) {
                        try {
                            this.session.getContext().remove("__T_AUTOPACK");
                            byte[] retData = MsgConvertUtil.packMsg(this.session.getContext(), this.msgConfig.getInErrorPath(), this.msgConfig.getRespMsgType(), this.msgConfig.getMsgEncode());
                            this.processSend(this.session, retData);
                        }
                        catch (Exception e) {
                            logger.warn("Error handling exception", (Object)e.getMessage());
                        }
                    }
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (this.session != null) {
                        this.session.destory();
                    }
                }
            }
            if (this.session == null) break block16;
            this.session.destory();
        }
        long endtime = System.currentTimeMillis();
        this.session.setTradeEndTime(endtime);
        logger.info("Transaction finished, took [{}] ms", (Object)(endtime - this.session.getTradeStartTime()));
        spanLogger.logStoppedSpan();
    }

    protected void processSend(Session session, byte[] data) throws Exception {
        Map<String, Object> context = session.getContext();
        StreamRequest srt = (StreamRequest)session.getInRequest();
        IComm comm = session.getComm();
        comm.processSend(context, data, srt);
    }

    public boolean f5Check() {
        IRequest request = this.session.getInRequest();
        if (request.getRequestType() == 1) {
            StreamRequest streamRequest = (StreamRequest)request;
            Object datasourceWrapper = streamRequest.getDatasourceWrapper();
            SocketWrapper socketWrapper = null;
            if (datasourceWrapper instanceof SocketWrapper) {
                socketWrapper = (SocketWrapper)datasourceWrapper;
                if (!socketWrapper.isFirst()) {
                    return false;
                }
            } else {
                return false;
            }
            socketWrapper.setFirst(false);
            Socket socket = socketWrapper.getSocket();
            int timeout = -1;
            try {
                timeout = socket.getSoTimeout();
                socket.setSoTimeout(10000);
                if (this.f5Check(socketWrapper)) {
                    request.setCloseFlag(true);
                    return true;
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    socket.setSoTimeout(timeout);
                }
                catch (SocketException socketException) {}
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean f5Check(SocketWrapper socketWrapper) throws Exception {
        BufferedInputStream bis = socketWrapper.getBis();
        String f5ReqMsg = this.msgConfig.getF5Reqmsg();
        byte[] src = new byte[]{};
        if (!StringTools.isEmpty(f5ReqMsg)) {
            src = this.f5Msg2byte(f5ReqMsg);
            int f5ReqLen = src.length;
            bis.mark(f5ReqLen);
            byte[] f5Data = new byte[f5ReqLen];
            DataInputStream dis = new DataInputStream(bis);
            try {
                dis.readFully(f5Data);
                if (this.byteCompare(src, f5Data)) {
                    f5Logger.debug("Packet detection: {},data:{}", (Object)socketWrapper.getSocket(), (Object)f5ReqMsg);
                    String f5RespMsg = this.msgConfig.getF5Respmsg();
                    if (!StringTools.isEmpty(f5RespMsg)) {
                        socketWrapper.getBos().write(this.f5Msg2byte(f5RespMsg));
                        socketWrapper.getBos().flush();
                    }
                    return true;
                }
            }
            catch (Exception exception) {}
        } else {
            bis.mark(1);
            int c = bis.read();
            if (c == -1) {
                f5Logger.debug("Packet detection: {}", (Object)socketWrapper.getSocket());
                return true;
            }
        }
        bis.reset();
        return false;
    }

    public byte[] f5Msg2byte(String msg) throws Exception {
        if (msg.startsWith("0x") || msg.startsWith("0X")) {
            msg = msg.substring(2);
            return StringTools.string2Byte(msg);
        }
        return msg.getBytes(this.msgConfig.getMsgEncode());
    }

    public boolean byteCompare(byte[] src, byte[] dest) {
        if (src.length != dest.length) {
            return false;
        }
        int i = 0;
        while (i < dest.length) {
            if ((src[i] & 0xFF) != (dest[i] & 0xFF)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract boolean executeJob() throws Throwable;

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void setPublicIn(String publicIn) {
        this.publicIn = publicIn;
    }

    @Override
    public String getPublicIn() {
        return this.publicIn;
    }

    @Override
    public String getPublicOut() {
        return this.publicOut;
    }

    @Override
    public void setPublicOut(String publicOut) {
        this.publicOut = publicOut;
    }

    public MsgConfig getMsgConfig() {
        return this.msgConfig;
    }

    public void setMsgConfig(MsgConfig msgConfig) {
        this.msgConfig = msgConfig;
    }

    public ServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public void setServiceConfig(ServiceConfig serviceConfig) {
        this.serviceConfig = serviceConfig;
    }
}

