/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.out.proxy;

import cn.com.yusys.yusp.bsp.workflow.comm.out.annotation.BspFeignClient;
import cn.com.yusys.yusp.bsp.workflow.comm.out.annotation.EnableCommFeign;
import cn.com.yusys.yusp.bsp.workflow.comm.out.proxy.CommFeignClientFactoryBean;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class CommFeignClientRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
BeanClassLoaderAware {
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata paramAnnotationMetadata, BeanDefinitionRegistry paramBeanDefinitionRegistry) {
        this.registerSocketFeignClients(paramAnnotationMetadata, paramBeanDefinitionRegistry);
    }

    public void registerSocketFeignClients(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(BspFeignClient.class);
        scanner.addIncludeFilter((TypeFilter)annotationTypeFilter);
        Set<String> basePackages = this.getBasePackages(metadata);
        for (String basePackage : basePackages) {
            Set candidateComponents = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition candidateComponent : candidateComponents) {
                if (!(candidateComponent instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
                AnnotationMetadata annotationMetadata = beanDefinition.getMetadata();
                Assert.isTrue((boolean)annotationMetadata.isInterface(), (String)"@CommFeignClient can only be specified on an interface");
                Map attributes = annotationMetadata.getAnnotationAttributes(BspFeignClient.class.getCanonicalName());
                this.registerFeignClient(registry, annotationMetadata, attributes);
            }
        }
    }

    private void registerFeignClient(BeanDefinitionRegistry registry, AnnotationMetadata annotationMetadata, Map<String, Object> attributes) {
        String className = annotationMetadata.getClassName();
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(CommFeignClientFactoryBean.class);
        definition.addPropertyValue("name", attributes.get("name"));
        definition.addPropertyValue("type", (Object)className);
        definition.setAutowireMode(2);
        String alias = attributes.get("name") + "CommFeignClient";
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        beanDefinition.setPrimary(true);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, className, new String[]{alias});
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                if (beanDefinition.getMetadata().isIndependent()) {
                    if (!beanDefinition.getMetadata().isInterface() || beanDefinition.getMetadata().getInterfaceNames().length != 1 || Annotation.class.getName().equals(beanDefinition.getMetadata().getInterfaceNames()[0])) {
                        // empty if block
                    }
                    try {
                        Class target = ClassUtils.forName((String)beanDefinition.getMetadata().getClassName(), (ClassLoader)CommFeignClientRegistrar.this.classLoader);
                        return !target.isAnnotation();
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)("Could not load target class: " + beanDefinition.getMetadata().getClassName()), (Throwable)ex);
                        return true;
                    }
                }
                return false;
            }
        };
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableCommFeign.class.getCanonicalName());
        String[] basePackage = (String[])attributes.get("basePackages");
        HashSet<String> basePackages = new HashSet<String>();
        basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        if (basePackage != null) {
            int i = 0;
            while (i < basePackage.length) {
                basePackages.add(basePackage[i]);
                ++i;
            }
        }
        return basePackages;
    }
}

