/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.out.impl;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.comm.out.AbstractCommOut;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FixCommOut
extends AbstractCommOut {
    protected String unitName = "Fixed length communication dial-out";
    protected static final String HEADER_DATA_INT = "Integer";
    protected static final String HEADER_DATA_SHORT = "Short";
    protected static final String HEADER_DATA_STR = "String";
    protected static final String HEADER_DATA_BYTE = "Byte";
    private String headerType;
    private String containSelf;
    private String headerLenStr;

    @Override
    public void processSend(Map<String, Object> context, byte[] bsend, AbstractRequest request) throws Exception {
        int startLen;
        StreamRequest streamRequest = (StreamRequest)request;
        DataOutputStream dos = new DataOutputStream(streamRequest.getSocketWrapper().getBos());
        String headerType = this.getInExpressStringValue(this.headerType, "headerType", context);
        boolean containSelf = this.getInExpressBooleanValue(this.containSelf, "containSelf", context);
        int tempLen = startLen = bsend.length;
        try {
            if (HEADER_DATA_SHORT.equals(headerType)) {
                if (containSelf) {
                    tempLen += 2;
                }
                dos.writeShort(tempLen);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} @ Send packet header data[2]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(tempLen, true, 0, 4))});
                }
            } else if (HEADER_DATA_INT.equals(headerType)) {
                if (containSelf) {
                    tempLen += 4;
                }
                dos.writeInt(tempLen);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} @ Send packet header data[4]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(tempLen, true, 0, 8))});
                }
            } else if (HEADER_DATA_BYTE.equals(headerType)) {
                if (containSelf) {
                    ++tempLen;
                }
                dos.writeByte(tempLen);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} @ Send packet header data[1]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(tempLen, true, 0, 2))});
                }
            } else if (HEADER_DATA_STR.equals(headerType)) {
                String headerLenStr = this.getInExpressStringValue(this.headerLenStr, "headerLenStr", context);
                if (StringUtils.isEmpty((CharSequence)headerLenStr)) {
                    throw new ComponentException("The packet header length is empty");
                }
                int headerLen = 0;
                try {
                    headerLen = Integer.parseInt(headerLenStr);
                }
                catch (Exception e) {
                    throw new ComponentException("Packet header length: " + headerLenStr + " is not number");
                }
                if (headerLen <= 0) {
                    throw new ComponentException("Packet header length must be greater than 0");
                }
                if (containSelf) {
                    tempLen += headerLen;
                }
                String sLen = String.valueOf(tempLen);
                StringBuilder sHeaderLen = new StringBuilder();
                int fillLen = headerLen - sLen.length();
                int i = 0;
                while (i < fillLen) {
                    sHeaderLen.append('0');
                    ++i;
                }
                sHeaderLen.append(sLen);
                dos.write(sHeaderLen.toString().getBytes());
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} @ Send packet header data[{}]:\n{}", new Object[]{this.getUnitName(), headerLen, StringTools.toHexTable(sHeaderLen.toString().getBytes())});
                }
            } else {
                throw new Exception(String.valueOf(this.getUnitName()) + " @ Send data, incorrect packet header data type[" + headerType + "]!");
            }
            this.sendMessageData(dos, bsend);
            dos.flush();
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.getUnitName()) + " @ Send data exception", e);
        }
    }

    @Override
    public byte[] processRecv(Map<String, Object> context, AbstractRequest request) throws Exception {
        StreamRequest streamRequest = (StreamRequest)request;
        DataInputStream dis = new DataInputStream(streamRequest.getSocketWrapper().getBis());
        int nHeaderLen = 0;
        String headerType = this.getInExpressStringValue(this.headerType, "headerType", context);
        boolean containSelf = this.getInExpressBooleanValue(this.containSelf, "containSelf", context);
        if (HEADER_DATA_SHORT.equals(headerType)) {
            nHeaderLen = dis.readShort();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ Receive packet header data[2]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(nHeaderLen, true, 0, 4))});
            }
            if (containSelf) {
                nHeaderLen -= 2;
            }
        } else if (HEADER_DATA_INT.equals(headerType)) {
            nHeaderLen = dis.readInt();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ Receive packet header data[4]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(nHeaderLen, true, 0, 8))});
            }
            if (containSelf) {
                nHeaderLen -= 4;
            }
        } else if (HEADER_DATA_BYTE.equals(headerType)) {
            nHeaderLen = dis.readByte();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ Receive packet header data[1]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(nHeaderLen, true, 0, 2))});
            }
            if (containSelf) {
                --nHeaderLen;
            }
        } else if (HEADER_DATA_STR.equals(headerType)) {
            String headerLenStr = this.getInExpressStringValue(this.headerLenStr, "headerLenStr", context);
            if (StringUtils.isEmpty((CharSequence)headerLenStr)) {
                throw new ComponentException("The packet header length is empty");
            }
            int headerLen = 0;
            try {
                headerLen = Integer.parseInt(headerLenStr);
            }
            catch (Exception e) {
                throw new ComponentException("Packet header length: " + headerLenStr + " is not number");
            }
            if (headerLen <= 0) {
                throw new ComponentException("Packet header length must be greater than 0");
            }
            byte[] dataLen = new byte[headerLen];
            dis.readFully(dataLen);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ Receive packet header data[{}]:\n{}", new Object[]{this.getUnitName(), headerLen, StringTools.toHexTable(dataLen)});
            }
            nHeaderLen = Integer.parseInt(new String(dataLen).trim());
            if (containSelf) {
                nHeaderLen -= headerLen;
            }
        } else {
            throw new ComponentException("Receive data, incorrect packet data type [" + headerType + "]!");
        }
        if ((long)nHeaderLen > 0xA00000L) {
            throw new ComponentException("Request too large buffer:" + nHeaderLen + " recv failed");
        }
        if (nHeaderLen < 0) {
            throw new ComponentException("Illegal packet header length : " + nHeaderLen);
        }
        byte[] recv = new byte[nHeaderLen];
        if (nHeaderLen > 0) {
            this.recvMessageData(dis, recv);
        }
        return recv;
    }

    @Override
    public String getUnitName() {
        return this.unitName;
    }

    public String getHeaderType() {
        return this.headerType;
    }

    public void setHeaderType(String headerType) {
        this.headerType = headerType;
    }

    public String getContainSelf() {
        return this.containSelf;
    }

    public void setContainSelf(String containSelf) {
        this.containSelf = containSelf;
    }

    public String getHeaderLenStr() {
        return this.headerLenStr;
    }

    public void setHeaderLenStr(String headerLenStr) {
        this.headerLenStr = headerLenStr;
    }
}

