/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.in.impl;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.DataRequest;
import cn.com.yusys.yusp.bsp.communication.IDataAdapter;
import cn.com.yusys.yusp.bsp.dataformat.LogPhase;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.comm.in.AbstractCommIn;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import java.util.Map;

public class MQCommIn
extends AbstractCommIn {
    protected String unitName = "MQIN";

    @Override
    public void processSend(Map<String, Object> context, byte[] bsend, AbstractRequest request) throws Exception {
        if (request.getRequestType() != 3) {
            throw new ComponentException("unknow request type:" + request.getRequestType());
        }
        DataRequest req = (DataRequest)request;
        req.setContext(context);
        req.setData(bsend);
        ((IDataAdapter)((Object)request.getInAdapter())).send(req);
        if (this.logger.isInfoEnabled()) {
            if (this.printHexLog(LogPhase.SEND)) {
                this.logger.info("{} @ \u53d1\u9001\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), bsend.length, StringTools.toHexTable(bsend, this.getMsgConfig().getMsgEncode())});
            } else {
                this.logger.info("{} @ \u53d1\u9001\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), bsend.length, StringTools.printStr(bsend, this.getMsgConfig().getMsgEncode())});
            }
        }
    }

    @Override
    public byte[] processRecv(Map<String, Object> context, AbstractRequest request) throws Exception {
        byte[] recv = null;
        if (request.getRequestType() != 3) {
            throw new ComponentException("unknow request type:" + request.getRequestType());
        }
        DataRequest req = (DataRequest)request;
        recv = req.getData();
        if (this.logger.isInfoEnabled()) {
            if (this.printHexLog(LogPhase.RECV)) {
                this.logger.info("{} @ \u63a5\u6536\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), recv.length, StringTools.toHexTable(recv, this.getMsgConfig().getMsgEncode())});
            } else {
                this.logger.info("{} @ \u63a5\u6536\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), recv.length, StringTools.printStr(recv, this.getMsgConfig().getMsgEncode())});
            }
        }
        return recv;
    }

    @Override
    protected String getUnitName() {
        return this.unitName;
    }
}

