/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.in.impl;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.core.VarDef;
import cn.com.yusys.yusp.bsp.toolkit.common.BCCPTools;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.comm.in.AbstractCommIn;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import java.io.File;
import java.util.Map;

public class BccpCommIn
extends AbstractCommIn {
    protected String unitName = "Bccp Comm";
    private String version;
    private String applicationCode;
    private String tradeCode;
    private String recvFileDir;
    private String sendFile;
    private String relativeDir;
    private String supportFile;
    private String reserveField;

    @Override
    public void processSend(Map<String, Object> context, byte[] data, AbstractRequest request) throws Exception {
        int i_version = Integer.parseInt(BccpCommIn.getInExpressStringValue(this.version, context));
        Object applicationCode = this.getInExpressObjectValue(this.applicationCode, context);
        Object tradeCode = this.getInExpressObjectValue(this.tradeCode, context);
        Object biz_SN = this.getInExpressObjectValue(this.reserveField, context);
        byte[] bsn = ByteTools.getBytes(biz_SN);
        if (bsn == null || bsn.length == 0) {
            Session session = (Session)context.get("T_SESSION");
            bsn = session.getBsn().getBytes();
        }
        BCCPTools tool = new BCCPTools();
        tool.setVersion(i_version);
        int option = BCCPTools.DATA_OPTION;
        try {
            String encodeProtocol = "GBK";
            byte[] bodyData = new byte[]{};
            byte[] encode = new byte[]{71, 66, 75};
            if (data != null && data.length != 0) {
                int len = data[0] & 0xFF;
                encode = new byte[len];
                System.arraycopy(data, 1, encode, 0, len);
                encodeProtocol = new String(encode);
                bodyData = new byte[data.length - len - 1];
                System.arraycopy(data, len + 1, bodyData, 0, bodyData.length);
            }
            String isSupportFile = BccpCommIn.getInExpressStringValue(this.supportFile, context);
            String sFile = null;
            String simpleFileName = null;
            String relativeDir = null;
            if ("true".equals(isSupportFile)) {
                sFile = BccpCommIn.getInExpressStringValue(this.sendFile, context);
                relativeDir = BccpCommIn.getInExpressStringValue(relativeDir, context);
                if (!StringTools.isEmpty(sFile)) {
                    File f = new File(sFile);
                    if (!f.isFile()) {
                        throw new ComponentException("\u53d1\u9001\u6587\u4ef6\u4e0d\u5b58\u5728:" + sFile);
                    }
                    simpleFileName = f.getName();
                }
            }
            StreamRequest sr = (StreamRequest)request;
            BCCPTools.BCCPProtocol pro = tool.sendProtocol(sr.getSocketWrapper().getBos(), ByteTools.getBytes(applicationCode, encodeProtocol), ByteTools.getBytes(tradeCode, encodeProtocol), bsn, ByteTools.getBytes(simpleFileName, encodeProtocol), ByteTools.getBytes(relativeDir, encodeProtocol), bodyData, option, encode);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ \u53d1\u9001\u534f\u8bae\u5934[{}]:\n{}", new Object[]{this.getUnitName(), pro.getHeadData().length, StringTools.toHexTable(pro.getHeadData())});
                if (VarDef.LOGMESSAGE) {
                    this.logger.info("{} @ \u53d1\u9001\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), bodyData.length, StringTools.toHexTable(bodyData)});
                } else {
                    this.logger.info("{} @ \u53d1\u9001\u6570\u636e[{}],\u62a5\u6587\u6570\u636e\u4e0d\u4e88\u8bb0\u5f55!", new Object[]{this.getUnitName(), bodyData.length});
                }
                byte[] crcData = pro.getCrcData();
                if (crcData != null && crcData.length != 0) {
                    this.logger.info("{} @ \u53d1\u9001\u6570\u636eCRC[{}]:\n{}", new Object[]{this.getUnitName(), crcData.length, StringTools.toHexTable(crcData)});
                }
            }
            if (!StringTools.isEmpty(sFile)) {
                tool.sendFile(sr.getSocketWrapper().getBos(), sFile);
                this.logger.debug("{} @ \u53d1\u9001\u6587\u4ef6[{}]\u6210\u529f", new Object[]{this.getUnitName(), sFile});
            }
        }
        catch (Exception e) {
            throw new ComponentException("\u53d1\u9001\u6570\u636e\u5f02\u5e38:", (Throwable)e, this.getUnitName(), this.getUnitName());
        }
    }

    @Override
    public byte[] processRecv(Map<String, Object> context, AbstractRequest request) throws Exception {
        BCCPTools tool = new BCCPTools();
        BCCPTools.BCCPProtocol pro = null;
        StreamRequest sr = (StreamRequest)request;
        byte[] data = null;
        try {
            pro = tool.receiveProtocol(sr.getSocketWrapper().getBis());
            byte[] encode = pro.getEncode().getBytes();
            data = new byte[encode.length + pro.getData().length + 1];
            data[0] = (byte)encode.length;
            System.arraycopy(encode, 0, data, 1, encode.length);
            System.arraycopy(pro.getData(), 0, data, encode.length + 1, pro.getData().length);
        }
        catch (Exception e) {
            throw new ComponentException();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} @ \u63a5\u6536\u534f\u8bae\u5934[{}]:\n{}", new Object[]{this.getUnitName(), pro.getHeadData().length, StringTools.toHexTable(pro.getHeadData())});
            if (VarDef.LOGMESSAGE) {
                this.logger.info("{} @ \u63a5\u6536\u6570\u636e\u4f53[{}]:\n{}", new Object[]{this.getUnitName(), pro.getData().length, StringTools.toHexTable(pro.getData())});
            } else {
                this.logger.info("{} @ \u63a5\u6536\u6570\u636e\u4f53[{}],\u62a5\u6587\u6570\u636e\u4e0d\u4e88\u8bb0\u5f55!", new Object[]{this.getUnitName(), pro.getData().length});
            }
            if (pro.getCrcData() != null) {
                this.logger.info("{} @ CRC\u6821\u9a8c\u7801[{}]:\n{}", new Object[]{this.getUnitName(), pro.getCrcData().length, StringTools.toHexTable(pro.getCrcData())});
            }
        }
        if (pro.getApplicationCode() != null && pro.getApplicationCode().length != 0) {
            context.put(this.getApplicationCode(), pro.getApplicationCode());
        }
        if (pro.getTradeCode() != null && pro.getTradeCode().length != 0) {
            context.put(this.getTradeCode(), pro.getTradeCode());
        }
        if (pro.getReserveField() != null && pro.getReserveField().length != 0) {
            context.put("G_BSN", pro.getReserveField());
            context.put(this.getReserveField(), pro.getReserveField());
        }
        if (pro.getPackageType() != 0) {
            try {
                String localDir = BccpCommIn.getInExpressStringValue(this.recvFileDir, context);
                if (StringTools.isEmpty(localDir)) {
                    throw new ComponentException("\u63a5\u6536\u6587\u4ef6\u5f02\u5e38,\u672c\u5730\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
                }
                File dir = new File(localDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String fp = tool.receiveFile(sr.getSocketWrapper().getBis(), pro.getFilePath(), pro.getRelativeDir(), localDir);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} @ \u63a5\u6536\u6587\u4ef6\u6210\u529f:[{}]", new Object[]{this.getUnitName(), fp});
                }
            }
            catch (Exception e) {
                throw new ComponentException("\u63a5\u6536\u6587\u4ef6\u5f02\u5e38:", (Throwable)e, this.getUnitName(), this.getUnitName());
            }
        }
        return data;
    }

    @Override
    protected String getUnitName() {
        return this.unitName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getApplicationCode() {
        return this.applicationCode;
    }

    public void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public String getTradeCode() {
        return this.tradeCode;
    }

    public void setTradeCode(String tradeCode) {
        this.tradeCode = tradeCode;
    }

    public String getRecvFileDir() {
        return this.recvFileDir;
    }

    public void setRecvFileDir(String recvFileDir) {
        this.recvFileDir = recvFileDir;
    }

    public String getSendFile() {
        return this.sendFile;
    }

    public void setSendFile(String sendFile) {
        this.sendFile = sendFile;
    }

    public String getRelativeDir() {
        return this.relativeDir;
    }

    public void setRelativeDir(String relativeDir) {
        this.relativeDir = relativeDir;
    }

    public String getSupportFile() {
        return this.supportFile;
    }

    public void setSupportFile(String supportFile) {
        this.supportFile = supportFile;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getReserveField() {
        return this.reserveField;
    }

    public void setReserveField(String reserveField) {
        this.reserveField = reserveField;
    }
}

