/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.xml;

import cn.com.yusys.yusp.bsp.toolkit.xml.SuperXMLNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class SuperXmlTools {
    private String encoding = "utf-8";
    private boolean packSimple = true;
    private boolean endFlag = false;
    private boolean haveValue = false;
    private byte[] defNamespace = "xmlns".getBytes();
    private byte[] startCData = "<![CDATA[".getBytes();
    private byte[] endCData = "]]>".getBytes();
    private ByteArrayOutputStream output;
    private static XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private static final String ATTRI_NAME = "name";
    private static final String BT_DATA = "data";
    private static final String BT_FIELD = "field";
    private static final String BT_SERVICE = "service";
    private static byte[] digits;
    private static byte[] ltEscape;
    private static byte[] gtEscape;
    private static byte[] andEscape;
    private static byte[] quotEscape;

    static {
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        digits = new byte[]{60, 62, 61, 34, 58, 32, 47, 38};
        ltEscape = "&lt;".getBytes();
        gtEscape = "&gt;".getBytes();
        andEscape = "&amp;".getBytes();
        quotEscape = "&quot;".getBytes();
    }

    public void writeStartDocument(boolean packXml) throws Exception {
        this.output = new ByteArrayOutputStream();
        if (packXml) {
            String xml = "<?xml version=\"1.0\" encoding=\"" + this.encoding + "\" ?>";
            this.output.write(xml.getBytes(this.encoding));
        }
    }

    public void writeStartElement(String prefix, String name) throws Exception {
        if (this.endFlag) {
            this.output.write(digits[1]);
        }
        this.output.write(digits[0]);
        if (!this.isEmpty(prefix)) {
            this.output.write(prefix.getBytes(this.encoding));
            this.output.write(digits[4]);
        }
        this.output.write(name.getBytes(this.encoding));
        this.endFlag = true;
    }

    public void writeAttribute(String prefix, String name, String value) throws Exception {
        this.writeAttribute(prefix, name, value.getBytes(this.encoding));
    }

    public void writeAttribute(String prefix, String name, byte[] value) throws Exception {
        if (!this.endFlag) {
            throw new Exception("Property configuration location is incorrect, must precede 'value'");
        }
        this.output.write(digits[5]);
        if (!this.isEmpty(prefix)) {
            this.output.write(prefix.getBytes(this.encoding));
            this.output.write(digits[4]);
        }
        this.output.write(name.getBytes(this.encoding));
        this.output.write(digits[2]);
        this.output.write(digits[3]);
        this.output.write(this.escapeCharacter(value));
        this.output.write(digits[3]);
    }

    public void writeNamespace(String name, String value) throws Exception {
        this.writeNamespace(name, value.getBytes(this.encoding));
    }

    public void writeNamespace(String name, byte[] value) throws Exception {
        if (!this.endFlag) {
            throw new Exception("Namaspace configuration location is incorrect, must precede 'value'");
        }
        this.output.write(digits[5]);
        this.output.write(this.defNamespace);
        this.output.write(digits[4]);
        this.output.write(name.getBytes(this.encoding));
        this.output.write(digits[2]);
        this.output.write(digits[3]);
        this.output.write(value);
        this.output.write(digits[3]);
    }

    public void writeDefaultNamespace(byte[] value) throws Exception {
        if (!this.endFlag) {
            throw new Exception("Default namespace configuration location is incorrect, must precede 'value'");
        }
        this.output.write(digits[5]);
        this.output.write(this.defNamespace);
        this.output.write(digits[2]);
        this.output.write(digits[3]);
        this.output.write(value);
        this.output.write(digits[3]);
    }

    public void writeCData(byte[] data) throws Exception {
        if (this.endFlag) {
            this.output.write(digits[1]);
        }
        this.output.write(this.startCData);
        this.output.write(data);
        this.output.write(this.endCData);
        this.haveValue = true;
        this.endFlag = false;
    }

    public void writeXML(byte[] data) throws Exception {
        if (this.endFlag) {
            this.output.write(digits[1]);
        }
        this.output.write(data);
        this.haveValue = true;
        this.endFlag = false;
    }

    public void writeCharacters(byte[] value) throws Exception {
        if (this.endFlag) {
            this.output.write(digits[1]);
        }
        this.output.write(this.escapeCharacter(value));
        this.haveValue = true;
        this.endFlag = false;
    }

    public void writeEndElement(String prefix, String name, boolean haveChildren) throws Exception {
        if (this.haveValue || haveChildren) {
            this.output.write(digits[0]);
            this.output.write(digits[6]);
            if (!this.isEmpty(prefix)) {
                this.output.write(prefix.getBytes(this.encoding));
                this.output.write(digits[4]);
            }
            this.output.write(name.getBytes(this.encoding));
            this.output.write(digits[1]);
        } else if (this.packSimple) {
            this.output.write(digits[6]);
            this.output.write(digits[1]);
        } else {
            this.output.write(digits[1]);
            this.output.write(digits[0]);
            this.output.write(digits[6]);
            if (!this.isEmpty(prefix)) {
                this.output.write(prefix.getBytes(this.encoding));
                this.output.write(digits[4]);
            }
            this.output.write(name.getBytes(this.encoding));
            this.output.write(digits[1]);
        }
        this.haveValue = false;
        this.endFlag = false;
    }

    public byte[] writeEndDocument() throws Exception {
        byte[] data = this.output.toByteArray();
        this.output.close();
        this.output = null;
        return data;
    }

    public byte[] escapeCharacter(byte[] data) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int index = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] == digits[0]) {
                os.write(data, index, i - index);
                os.write(ltEscape);
                index = i + 1;
            } else if (data[i] == digits[1]) {
                os.write(data, index, i - index);
                os.write(gtEscape);
                index = i + 1;
            } else if (data[i] == digits[3]) {
                os.write(data, index, i - index);
                os.write(quotEscape);
                index = i + 1;
            } else if (data[i] == digits[7]) {
                os.write(data, index, i - index);
                os.write(andEscape);
                index = i + 1;
            }
            ++i;
        }
        if (index != 0) {
            os.write(data, index, data.length - index);
            data = os.toByteArray();
        }
        os.close();
        return data;
    }

    public byte[] getXMLNodeByte(SuperXMLNode xmlNode) throws Exception {
        this.writeStartDocument(false);
        this.writeXMLNode(xmlNode);
        return this.writeEndDocument();
    }

    public void writeXMLNode(SuperXMLNode xmlNode) throws Exception {
        this.writeStartElement(xmlNode.getPrefix(), xmlNode.getName());
        for (String key : xmlNode.getNamespaces().keySet()) {
            if (this.isEmpty(key)) {
                this.writeDefaultNamespace(xmlNode.getNamespaceValue("", this.encoding));
                continue;
            }
            this.writeNamespace(key, xmlNode.getNamespaceValue(key, this.encoding));
        }
        for (String key : xmlNode.getAttrs().keySet()) {
            this.writeAttribute(xmlNode.getAttrs().get(key).getPrefix(), key, xmlNode.getAttributeValue(key, this.encoding));
        }
        if (!this.isEmpty(xmlNode.getCDATA())) {
            this.writeCData(xmlNode.getCData(this.encoding));
        }
        if (!this.isEmpty(xmlNode.getValue())) {
            this.writeCharacters(xmlNode.getValue(this.encoding));
        }
        Object obj = null;
        List tempList = null;
        boolean haveChildren = false;
        for (String key : xmlNode.getChildren().keySet()) {
            haveChildren = true;
            obj = xmlNode.getChildren().get(key);
            if (obj instanceof SuperXMLNode) {
                this.writeXMLNode((SuperXMLNode)obj);
                continue;
            }
            if (!(obj instanceof List)) continue;
            tempList = (List)obj;
            for (SuperXMLNode node : tempList) {
                this.writeXMLNode(node);
            }
        }
        this.writeEndElement(xmlNode.getPrefix(), xmlNode.getName(), haveChildren);
    }

    public void writeWsdlNode(SuperXMLNode xmlNode) throws Exception {
        this.writeStartElement(xmlNode.getPrefix(), xmlNode.getName());
        for (String key : xmlNode.getNamespaces().keySet()) {
            if (this.isEmpty(key)) {
                this.writeDefaultNamespace(xmlNode.getNamespaceValue("", this.encoding));
                continue;
            }
            this.writeNamespace(key, xmlNode.getNamespaceValue(key, this.encoding));
        }
        for (String key : xmlNode.getAttrs().keySet()) {
            this.writeAttribute(xmlNode.getAttrs().get(key).getPrefix(), key, xmlNode.getAttributeValue(key, this.encoding));
        }
        if (!this.isEmpty(xmlNode.getCDATA())) {
            this.writeCData(xmlNode.getCData(this.encoding));
        }
        if (!this.isEmpty(xmlNode.getValue())) {
            this.writeCharacters(xmlNode.getValue(this.encoding));
        }
        Object obj = null;
        List tempList = null;
        boolean haveChildren = false;
        for (String key : xmlNode.getChildren().keySet()) {
            haveChildren = true;
            obj = xmlNode.getChildren().get(key);
            if (obj instanceof SuperXMLNode) {
                this.writeXMLNode((SuperXMLNode)obj);
                continue;
            }
            if (!(obj instanceof List)) continue;
            tempList = (List)obj;
            if (key.startsWith("element")) {
                SuperXMLNode node = (SuperXMLNode)tempList.get(0);
                node.addAttrs("minOccurs", "0");
                node.addAttrs("maxOccurs", "unbounded");
                this.writeXMLNode(node);
                continue;
            }
            for (SuperXMLNode node : tempList) {
                this.writeXMLNode(node);
            }
        }
        this.writeEndElement(xmlNode.getPrefix(), xmlNode.getName(), haveChildren);
    }

    public SuperXMLNode readerSMXmlByStreamReader(byte[] data) throws Exception {
        LinkedList<String> nodeList = new LinkedList<String>();
        SuperXMLNode xml = null;
        SuperXMLNode node = null;
        try (XMLStreamReader reader = null;){
            reader = inputFactory.createXMLStreamReader(new ByteArrayInputStream(data), this.encoding);
            block11: while (reader.hasNext()) {
                int type = reader.next();
                if (reader.isWhiteSpace()) continue;
                switch (type) {
                    case 1: {
                        int i;
                        int attributeCount;
                        String nodeName = reader.getName().getLocalPart();
                        if (BT_SERVICE.equals(nodeName)) {
                            xml = new SuperXMLNode(nodeName);
                            nodeList.add(nodeName);
                            break;
                        }
                        if (BT_DATA.equals(nodeName)) {
                            attributeCount = reader.getAttributeCount();
                            i = 0;
                            while (i < attributeCount) {
                                if (ATTRI_NAME.equals(reader.getAttributeLocalName(i))) {
                                    node = new SuperXMLNode(reader.getAttributeValue(i));
                                }
                                ++i;
                            }
                            if (node == null) break;
                            this.getCurrentNode(xml, nodeList).addChild(node);
                            nodeList.add(node.getName());
                            break;
                        }
                        if (!BT_FIELD.equals(nodeName) || xml == null || node == null) continue block11;
                        attributeCount = reader.getAttributeCount();
                        i = 0;
                        while (i < attributeCount) {
                            if (!ATTRI_NAME.equals(reader.getAttributeLocalName(i))) {
                                node.addAttrs(reader.getAttributePrefix(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                            }
                            ++i;
                        }
                        int namespaceCount = reader.getNamespaceCount();
                        int i2 = 0;
                        while (i2 < namespaceCount) {
                            node.addNamespace(reader.getNamespacePrefix(i2), reader.getNamespaceURI(i2));
                            ++i2;
                        }
                        continue block11;
                    }
                    case 2: {
                        if (!BT_DATA.equals(reader.getName().getLocalPart())) break;
                        nodeList.removeLast();
                        break;
                    }
                    case 4: {
                        node.setValue(reader.getText());
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 12: {
                        node.setCDATA(reader.getText());
                        break;
                    }
                }
            }
        }
        return xml;
    }

    public SuperXMLNode readerXMLByXMLStreamReader(byte[] data) throws Exception {
        LinkedList<String> nodeList = new LinkedList<String>();
        SuperXMLNode xml = null;
        SuperXMLNode node = null;
        try (XMLStreamReader reader = null;){
            reader = inputFactory.createXMLStreamReader(new ByteArrayInputStream(data), this.encoding);
            while (reader.hasNext()) {
                int type = reader.next();
                if (reader.isWhiteSpace()) continue;
                switch (type) {
                    case 1: {
                        String nodeName = reader.getName().getLocalPart();
                        node = new SuperXMLNode(nodeName);
                        String nodePrefix = reader.getName().getPrefix();
                        node.setPrefix(nodePrefix);
                        int namespaceCount = reader.getNamespaceCount();
                        int i = 0;
                        while (i < namespaceCount) {
                            node.addNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                            ++i;
                        }
                        int attributeCount = reader.getAttributeCount();
                        int i2 = 0;
                        while (i2 < attributeCount) {
                            node.addAttrs(reader.getAttributePrefix(i2), reader.getAttributeLocalName(i2), reader.getAttributeValue(i2));
                            ++i2;
                        }
                        if (xml == null) {
                            xml = node;
                            nodeList.add(nodeName);
                            break;
                        }
                        this.getCurrentNode(xml, nodeList).addChild(node);
                        nodeList.add(nodeName);
                        break;
                    }
                    case 2: {
                        nodeList.removeLast();
                        break;
                    }
                    case 4: {
                        node.setValue(reader.getText());
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 12: {
                        node.setCDATA(reader.getText());
                        break;
                    }
                }
            }
        }
        return xml;
    }

    public SuperXMLNode readerXML(byte[] data) throws Exception {
        LinkedList<String> nodeList = new LinkedList<String>();
        String str = null;
        XMLEvent event = null;
        SuperXMLNode xml = null;
        SuperXMLNode node = null;
        try (XMLEventReader reader = null;){
            reader = inputFactory.createXMLEventReader(new ByteArrayInputStream(data), this.encoding);
            while (reader.hasNext()) {
                event = reader.nextEvent();
                if (event.isStartDocument()) continue;
                if (event.isStartElement()) {
                    StartElement startElement = event.asStartElement();
                    String nodeName = startElement.getName().getLocalPart();
                    node = new SuperXMLNode(nodeName);
                    String nodePrefix = startElement.getName().getPrefix();
                    node.setPrefix(nodePrefix);
                    Iterator<Namespace> nameSpaces = startElement.getNamespaces();
                    Namespace nameSpace = null;
                    while (nameSpaces.hasNext()) {
                        nameSpace = nameSpaces.next();
                        node.addNamespace(nameSpace.getPrefix(), nameSpace.getNamespaceURI());
                    }
                    Iterator<Attribute> attrs = startElement.getAttributes();
                    Attribute attr = null;
                    while (attrs.hasNext()) {
                        attr = attrs.next();
                        node.addAttrs(attr.getName().getPrefix(), attr.getName().getLocalPart(), attr.getValue());
                    }
                    if (xml == null) {
                        xml = node;
                        nodeList.add(nodeName);
                        continue;
                    }
                    this.getCurrentNode(xml, nodeList).addChild(node);
                    nodeList.add(nodeName);
                    continue;
                }
                if (event.isCharacters()) {
                    Characters character = event.asCharacters();
                    if (character.isWhiteSpace()) continue;
                    if (character.isCData()) {
                        str = event.asCharacters().getData();
                        node.setCDATA(str);
                        continue;
                    }
                    str = event.asCharacters().getData();
                    node.setValue(str);
                    continue;
                }
                if (event.isEndElement()) {
                    nodeList.removeLast();
                    continue;
                }
                if (!event.isEndDocument()) continue;
                break;
            }
        }
        return xml;
    }

    private SuperXMLNode getCurrentNode(SuperXMLNode xml, List<String> nodeList) {
        SuperXMLNode root = xml;
        Object obj = null;
        String nodeName = null;
        if (nodeList == null) {
            return root;
        }
        int i = 1;
        while (i < nodeList.size()) {
            nodeName = nodeList.get(i);
            obj = root.getChildren().get(nodeName);
            if (obj instanceof SuperXMLNode) {
                root = (SuperXMLNode)obj;
            } else if (obj instanceof List) {
                root = (SuperXMLNode)((LinkedList)obj).getLast();
            }
            ++i;
        }
        return root;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public SuperXmlTools(String encoding) {
        this.encoding = encoding;
    }

    public boolean isPackSimple() {
        return this.packSimple;
    }

    public void setPackSimple(boolean packSimple) {
        this.packSimple = packSimple;
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

