/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class SocketTools {
    private static int DEFAULT_CONNECTIONTIMEOUT = 10000;
    private static final String OS_NAME = "os.name";
    private static final String AIX = "aix";
    private static final String LINUX = "linux";
    private static final String WINDOWS = "windows";
    public static final long DEFAULT_MAX_BUFFER_SIZE = 0xA00000L;

    public static Socket connectToDest(String host, int port, int readTimeout, int connectionTimeout) throws IOException {
        Socket socket = new Socket();
        InetAddress addr = InetAddress.getByName(host);
        InetSocketAddress inetAddr = new InetSocketAddress(addr, port);
        try {
            socket.connect(inetAddr, connectionTimeout);
        }
        catch (Exception e) {
            throw new IOException("[" + host + ":" + port + "] Connection exception ", e);
        }
        if (readTimeout > 0) {
            socket.setSoTimeout(readTimeout);
        }
        return socket;
    }

    public static byte[] readInputStream(InputStream inputStream, int len) throws IOException {
        byte[] tmpArray = new byte[len];
        InputStream in = null;
        in = inputStream instanceof BufferedInputStream ? inputStream : new BufferedInputStream(inputStream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int readCount = 0;
        int size = 0;
        while ((readCount = in.read(tmpArray)) != -1) {
            int surplus = len - size;
            if (readCount >= surplus) {
                baos.write(tmpArray, 0, surplus);
                size += surplus;
                break;
            }
            baos.write(tmpArray, 0, readCount);
            tmpArray = new byte[len - (size += readCount)];
        }
        return baos.toByteArray();
    }

    public static byte[] readInputStream(InputStream inputStream, byte[] endFlags, boolean hasEndFlag) throws Exception {
        if (endFlags == null || endFlags.length == 0) {
            return SocketTools.readInputStreamInBuffer(inputStream);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream resultBaos = new ByteArrayOutputStream();
        int flagLength = endFlags.length;
        boolean isEnd = false;
        while (!isEnd) {
            byte[] tmpArray = SocketTools.readInputStreamInBuffer(inputStream);
            baos.write(tmpArray);
            byte[] receiveData = baos.toByteArray();
            int receiveLength = receiveData.length;
            if (receiveLength < flagLength) continue;
            int i = 0;
            while (i < flagLength) {
                byte tmpByte = receiveData[receiveLength - i - 1];
                byte flagByte = endFlags[flagLength - i - 1];
                if (tmpByte != flagByte) {
                    isEnd = false;
                    break;
                }
                isEnd = true;
                ++i;
            }
            if (!isEnd) continue;
            if (hasEndFlag) {
                resultBaos.write(receiveData);
                continue;
            }
            resultBaos.write(receiveData, 0, receiveLength - flagLength);
        }
        return resultBaos.toByteArray();
    }

    public static byte[] readInputStream(InputStream inputStream, byte[] endFlags) throws Exception {
        return SocketTools.readInputStream(inputStream, endFlags, true);
    }

    public static byte[] exchangeFixData(String ip, int port, byte[] srcData, int readTimeOut) throws IOException {
        Socket sock = new Socket();
        InetSocketAddress InetAddr = new InetSocketAddress(ip, port);
        sock.connect(InetAddr, DEFAULT_CONNECTIONTIMEOUT);
        if (readTimeOut > 0) {
            sock.setSoTimeout(readTimeOut);
        }
        return SocketTools.exchangeFixData(sock, srcData, readTimeOut);
    }

    public static byte[] exchangeData(String ip, int port, byte[] srcData, int readTimeOut) throws Exception {
        Socket sock = new Socket();
        InetSocketAddress InetAddr = new InetSocketAddress(ip, port);
        sock.connect(InetAddr, DEFAULT_CONNECTIONTIMEOUT);
        return SocketTools.exchangeData(sock, srcData, readTimeOut);
    }

    public static byte[] exchangeFixData(Socket sock, byte[] srcData, int readTimeOut) throws IOException {
        DataInputStream in = null;
        DataOutputStream out = null;
        byte[] byRet = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(sock.getOutputStream()));
            out.writeInt(srcData.length);
            out.write(srcData, 0, srcData.length);
            out.flush();
            in = new DataInputStream(new BufferedInputStream(sock.getInputStream()));
            int readCount = in.readInt();
            byRet = new byte[readCount];
            if ((long)byRet.length > 0xA00000L) {
                throw new IOException("Request too large buffer: " + byRet.length + " recv failed");
            }
            in.readFully(byRet, 0, readCount);
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return byRet;
    }

    public static byte[] exchangeData(Socket sock, byte[] srcData, int readTimeOut) throws Exception {
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        byte[] byRet = null;
        try {
            in = new BufferedInputStream(sock.getInputStream());
            out = new BufferedOutputStream(sock.getOutputStream());
            ((BufferedOutputStream)out).write(srcData, 0, srcData.length);
            ((BufferedOutputStream)out).flush();
            byRet = SocketTools.readInputStreamInBuffer(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return byRet;
    }

    public static byte[] readInputStreamInBuffer(InputStream inputStream) throws Exception {
        InputStream in = null;
        in = inputStream instanceof BufferedInputStream ? inputStream : new BufferedInputStream(inputStream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] tmpArray = new byte[8192];
        int readerCount = 0;
        while ((readerCount = in.read(tmpArray)) > 0) {
            baos.write(tmpArray, 0, readerCount);
            if (in.available() == 0) break;
        }
        byte[] retArray = baos.toByteArray();
        if (readerCount < 0 && retArray.length == 0) {
            throw new IOException("Socket tool class @ connection closed");
        }
        return retArray;
    }

    public static ServerSocket createServerSocket(boolean reuseAddress) throws IOException {
        ServerSocket server = new ServerSocket();
        String osname = System.getProperty(OS_NAME);
        if (osname != null) {
            String lowerOsname = osname.toLowerCase();
            if (lowerOsname.startsWith(WINDOWS)) {
                server.setReuseAddress(false);
            } else if (lowerOsname.startsWith(LINUX) || lowerOsname.startsWith(AIX)) {
                server.setReuseAddress(true);
            } else {
                server.setReuseAddress(reuseAddress);
            }
        } else {
            server.setReuseAddress(reuseAddress);
        }
        return server;
    }
}

