/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class IpFilter {
    public static Pattern pattern = Pattern.compile("(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})");

    /*
     * Could not resolve type clashes
     */
    public static Set<String> init(String allowIp) {
        HashSet<String> ipList = new HashSet<String>();
        String[] stringArray = allowIp.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String allow = stringArray[n2];
            if (allow.indexOf("*") > -1) {
                String[] ips = allow.split("\\.");
                String[] from = new String[]{"0", "0", "0", "0"};
                String[] end = new String[]{"255", "255", "255", "255"};
                List<Object> tem = new ArrayList();
                int i = 0;
                while (i < ips.length) {
                    if (ips[i].indexOf("*") > -1) {
                        tem = IpFilter.complete(ips[i]);
                        from[i] = null;
                        end[i] = null;
                    } else {
                        from[i] = ips[i];
                        end[i] = ips[i];
                    }
                    ++i;
                }
                StringBuffer fromIP = new StringBuffer();
                StringBuffer endIP = new StringBuffer();
                int i2 = 0;
                while (i2 < 4) {
                    if (from[i2] != null) {
                        fromIP.append(from[i2]).append(".");
                        endIP.append(end[i2]).append(".");
                    } else {
                        fromIP.append("[*].");
                        endIP.append("[*].");
                    }
                    ++i2;
                }
                fromIP.deleteCharAt(fromIP.length() - 1);
                endIP.deleteCharAt(endIP.length() - 1);
                for (String s : tem) {
                    String ip = String.valueOf(fromIP.toString().replace("[*]", s.split(";")[0])) + "-" + endIP.toString().replace("[*]", s.split(";")[1]);
                    if (!IpFilter.validate(ip)) continue;
                    ipList.add(ip);
                }
            } else if (IpFilter.validate(allow)) {
                ipList.add(allow);
            }
            ++n2;
        }
        return ipList;
    }

    public static List<String> complete(String arg) {
        ArrayList<String> com = new ArrayList<String>();
        if (arg.length() == 1) {
            com.add("0;255");
        } else if (arg.length() == 2) {
            String s2;
            String s1 = IpFilter.complete(arg, 1);
            if (s1 != null) {
                com.add(s1);
            }
            if ((s2 = IpFilter.complete(arg, 2)) != null) {
                com.add(s2);
            }
        } else {
            String s1 = IpFilter.complete(arg, 1);
            if (s1 != null) {
                com.add(s1);
            }
        }
        return com;
    }

    public static String complete(String arg, int length) {
        String from = "";
        String end = "";
        if (length == 1) {
            from = arg.replace("*", "0");
            end = arg.replace("*", "9");
        } else {
            from = arg.replace("*", "00");
            end = arg.replace("*", "99");
        }
        if (Integer.valueOf(from) > 255) {
            return null;
        }
        if (Integer.valueOf(end) > 255) {
            end = "255";
        }
        return String.valueOf(from) + ";" + end;
    }

    public static boolean validate(String ip) {
        String[] stringArray = ip.split("-");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!pattern.matcher(s).matches()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean checkIP(String ip, Set<String> ipList) {
        if (ipList.isEmpty() || ipList.contains(ip)) {
            return true;
        }
        for (String allow : ipList) {
            if (allow.indexOf("-") <= -1) continue;
            String[] from = allow.split("-")[0].split("\\.");
            String[] end = allow.split("-")[1].split("\\.");
            String[] tag = ip.split("\\.");
            boolean check = true;
            int i = 0;
            while (i < 4) {
                int s = Integer.valueOf(from[i]);
                int t = Integer.valueOf(tag[i]);
                int e = Integer.valueOf(end[i]);
                if (s > t || t > e) {
                    check = false;
                    break;
                }
                ++i;
            }
            if (!check) continue;
            return true;
        }
        return false;
    }
}

