/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import cn.com.yusys.yusp.bsp.resources.core.VarDef;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class FileTools {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static Logger logger = LoggerFactory.getLogger(FileTools.class);
    public static Map<String, Boolean> fileCache = new ConcurrentHashMap<String, Boolean>();

    public static List<String> recursiveListFileBySuffix(File rootFile, final String suffix) {
        final ArrayList<String> fileList = new ArrayList<String>();
        rootFile.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String filePath = String.valueOf(dir.getPath()) + "/" + name;
                File subfile = new File(filePath);
                if (subfile.isDirectory()) {
                    fileList.addAll(FileTools.recursiveListFileBySuffix(subfile, suffix));
                    return false;
                }
                if (name.endsWith(suffix)) {
                    fileList.add(filePath.replaceAll("\\\\", "/"));
                }
                return false;
            }
        });
        return fileList;
    }

    public static void appendContentToFile(String fileName, byte[] content) throws Exception {
        try (OutputStream fos = null;){
            fos = FileTools.openOutputStream(new File(fileName), true);
            fos.write(content, 0, content.length);
            fos.flush();
        }
    }

    public static void copyFile(String srcFile, String destFile) throws Exception {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = FileTools.openInputStream(srcFile);
            out = FileTools.openOutputStream(new File(destFile));
            FileTools.copyStream(in, out);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static long copyStream(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static boolean fetchFileExists(String relativePath) {
        ClassPathResource resource;
        File file = new File(VarDef.BSP_WORKSPACE, relativePath);
        return file.exists() || (resource = new ClassPathResource(relativePath)).exists();
    }

    public static File fetchFile(String relativePath) throws Exception {
        File file = new File(VarDef.BSP_WORKSPACE, relativePath);
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    public static InputStream fetchFileStreatm(String relativePath) throws Exception {
        File file = new File(VarDef.BSP_WORKSPACE, relativePath);
        if (!file.isFile()) {
            ClassPathResource resource = new ClassPathResource(relativePath);
            return resource.getInputStream();
        }
        return new FileInputStream(file);
    }

    public static long fetchFileLength(String fileName) throws Exception {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new Exception("File does not exist:" + fileName);
        }
        return file.length();
    }

    public static byte[] fetchFileMd5(String fileName) throws Exception {
        byte[] bTemp = FileTools.readFileContent(fileName);
        MessageDigest mdTemp = MessageDigest.getInstance("MD5");
        mdTemp.update(bTemp);
        byte[] md = mdTemp.digest();
        return md;
    }

    public static byte[] fetchFileMd5(File file) throws Exception {
        byte[] bTemp = FileTools.readFileContent(file);
        MessageDigest mdTemp = MessageDigest.getInstance("MD5");
        mdTemp.update(bTemp);
        byte[] md = mdTemp.digest();
        return md;
    }

    public static byte[] fetchMd5(byte[] data) throws Exception {
        MessageDigest mdTemp = MessageDigest.getInstance("MD5");
        mdTemp.update(data);
        byte[] md = mdTemp.digest();
        return md;
    }

    private static void findDir(File file, String rootdir, List<String> list, String[] prefix, String[] postfix, boolean containfix) {
        String[] dirList = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String dn) {
                File file = new File(dir + "/" + dn);
                return file.isDirectory();
            }
        });
        if (dirList != null) {
            String[] stringArray = dirList;
            int n = dirList.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                String fn = null;
                fn = rootdir.endsWith("/") ? String.valueOf(rootdir) + name : String.valueOf(rootdir) + "/" + name;
                FileTools.findFileByNamefix(fn, prefix, postfix, containfix, list);
                ++n2;
            }
        }
    }

    private static void findFile(File file, String rootdir, List<String> list, final String[] prefix, final String[] postfix, final boolean containfix) {
        if (!file.exists()) {
            return;
        }
        String[] fileList = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fn) {
                String pf;
                int n;
                int n2;
                String[] stringArray;
                File file = new File(dir + "/" + fn);
                if (file.isDirectory()) {
                    return false;
                }
                if (containfix) {
                    String pf2;
                    int n3;
                    int n4;
                    String[] stringArray2;
                    boolean postfixFlag = false;
                    boolean prefixFlag = false;
                    if (postfix != null && postfix.length > 0) {
                        stringArray2 = postfix;
                        n4 = postfix.length;
                        n3 = 0;
                        while (n3 < n4) {
                            pf2 = stringArray2[n3];
                            if (fn.endsWith(pf2)) {
                                postfixFlag = true;
                            }
                            ++n3;
                        }
                    } else {
                        postfixFlag = true;
                    }
                    if (prefix != null && prefix.length > 0) {
                        stringArray2 = prefix;
                        n4 = prefix.length;
                        n3 = 0;
                        while (n3 < n4) {
                            pf2 = stringArray2[n3];
                            if (fn.startsWith(pf2)) {
                                prefixFlag = true;
                            }
                            ++n3;
                        }
                    } else {
                        prefixFlag = true;
                    }
                    return postfixFlag && prefixFlag;
                }
                boolean postfixFlag = true;
                boolean prefixFlag = true;
                if (postfix != null && postfix.length > 0) {
                    stringArray = postfix;
                    n2 = postfix.length;
                    n = 0;
                    while (n < n2) {
                        pf = stringArray[n];
                        if (fn.endsWith(pf)) {
                            postfixFlag = false;
                        }
                        ++n;
                    }
                } else {
                    postfixFlag = true;
                }
                if (prefix != null && prefix.length > 0) {
                    stringArray = prefix;
                    n2 = prefix.length;
                    n = 0;
                    while (n < n2) {
                        pf = stringArray[n];
                        if (fn.startsWith(pf)) {
                            prefixFlag = false;
                        }
                        ++n;
                    }
                } else {
                    prefixFlag = true;
                }
                return postfixFlag || prefixFlag;
            }
        });
        if (fileList != null) {
            String[] stringArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                String fName = null;
                fName = rootdir.endsWith("/") ? String.valueOf(rootdir) + name : String.valueOf(rootdir) + "/" + name;
                list.add(fName);
                ++n2;
            }
        } else {
            logger.warn("Exception getting file, path:{}", (Object)rootdir);
        }
    }

    public static String[] findFileByNamefix(String rootdir, String[] prefix, String[] postfix, boolean containfix) {
        ArrayList<String> list = new ArrayList<String>();
        FileTools.findFileByNamefix(rootdir, prefix, postfix, containfix, list);
        return list.toArray(new String[0]);
    }

    private static void findFileByNamefix(String rootdir, String[] prefix, String[] postfix, boolean containfix, List<String> list) {
        File file = new File(rootdir);
        FileTools.findFile(file, rootdir, list, prefix, postfix, containfix);
        FileTools.findDir(file, rootdir, list, prefix, postfix, containfix);
    }

    private static void getDirList(File file, List<String> list) {
        list.add(file.getPath());
        if (file.isDirectory()) {
            File[] subFile = file.listFiles();
            int i = 0;
            while (i < subFile.length) {
                FileTools.getDirList(subFile[i], list);
                ++i;
            }
        }
    }

    public static List<String> getAllDirList(String dir) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(dir);
        if (file.exists()) {
            FileTools.getDirList(file, list);
        }
        return list;
    }

    public static int getHexValue(byte byte1, byte byte2) {
        int num = 0;
        if (byte2 == 32 || byte2 == 9 || byte2 == 10 || byte2 == 13 || byte2 == 12 || byte2 == -1) {
            String tmpStr = String.valueOf((char)byte1);
            num = Integer.parseInt(tmpStr, 16);
        } else {
            String tmpStr = String.valueOf(String.valueOf((char)byte1)) + String.valueOf((char)byte2);
            num = Integer.parseInt(tmpStr, 16);
        }
        return num;
    }

    public static InputStream openInputStream(String fileName) throws IOException {
        File file = new File(VarDef.BSP_WORKSPACE, fileName);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
            return new FileInputStream(file);
        }
        ClassPathResource resource = new ClassPathResource(fileName);
        if (!resource.exists()) {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return resource.getInputStream();
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileTools.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    public static File openFileDir(String dirPath) throws IOException {
        File dirFile = new File(dirPath);
        if (!dirFile.exists()) {
            if (!dirFile.mkdirs() && !dirFile.isDirectory()) {
                throw new IOException("Directory '" + dirFile + "' could not be created");
            }
        } else if (!dirFile.isDirectory()) {
            throw new IOException("File '" + dirFile + "' exists but is not a directory");
        }
        return dirFile;
    }

    public static byte[] readFileContent(String fileName) throws IOException {
        byte[] fileContent = null;
        InputStream fis = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            fis = FileTools.openInputStream(fileName);
            FileTools.copyStream(fis, baos);
            fileContent = baos.toByteArray();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return fileContent;
    }

    public static byte[] readFileContent(File file) throws IOException {
        byte[] fileContent = null;
        FileInputStream fis = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            fis = FileTools.openInputStream(file);
            FileTools.copyStream(fis, baos);
            fileContent = baos.toByteArray();
        }
        finally {
            if (fis != null) {
                ((InputStream)fis).close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return fileContent;
    }

    public static byte[] readHexFile(String fileName) throws NumberFormatException, IOException {
        byte[] result = null;
        try (ByteArrayOutputStream out = null;){
            out = new ByteArrayOutputStream();
            byte[] hexData = FileTools.readFileContent(fileName);
            int length = hexData.length;
            int i = 0;
            while (i < length) {
                int frist = hexData[i] & 0xFF;
                if (frist >= 97 && frist <= 102 || frist >= 46 && frist <= 57 || frist >= 65 && frist <= 70) {
                    int second = -1;
                    if (length > i + 1) {
                        second = hexData[i + 1];
                    }
                    if (second == 9 || second == 10 || second == 13 || second == 12 || second == 32 || second == -1) {
                        out.write(Integer.parseInt(String.valueOf((char)frist), 16));
                    } else {
                        out.write(Integer.parseInt(String.valueOf(String.valueOf((char)frist)) + String.valueOf((char)second), 16));
                    }
                    ++i;
                }
                ++i;
            }
            result = out.toByteArray();
            out.reset();
        }
        return result;
    }

    public static Properties readPropFile(String fileName) throws Exception {
        Properties config = new Properties();
        try (InputStream in = null;){
            in = FileTools.openInputStream(fileName);
            config.load(in);
            Properties properties = config;
            return properties;
        }
    }

    public static void recursiveCopy(String srcFileName, String destFileName) throws Exception {
        FileTools.recursiveCopy(srcFileName, destFileName, false);
    }

    public static void recursiveCopy(String srcFileName, String destFileName, boolean filtrateSvn) throws Exception {
        File srcDir = new File(srcFileName);
        File destDir = new File(destFileName);
        if (!srcDir.isDirectory() || !srcDir.canRead()) {
            throw new Exception("Source directory must be a readable directory " + srcDir);
        }
        if (srcDir.equals(destDir)) {
            throw new Exception("Source and destination directory are the same " + srcDir);
        }
        destDir.mkdirs();
        if (!destDir.exists()) {
            throw new Exception("Could not create destination directory " + destDir);
        }
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles != null) {
            int i = 0;
            while (i < srcFiles.length) {
                File srcFile = srcFiles[i];
                File destFile = new File(destDir, srcFile.getName());
                if (srcFile.isDirectory()) {
                    if (!filtrateSvn || !srcFile.getName().equals(".svn")) {
                        FileTools.recursiveCopy(srcFile.getPath(), destFile.getPath(), filtrateSvn);
                    }
                } else if (srcFile.isFile()) {
                    FileTools.copyFile(srcFile.getPath(), destFile.getPath());
                }
                ++i;
            }
        }
    }

    public static boolean recursiveRmFile(String fileName) throws Exception {
        File[] files;
        File root = new File(fileName);
        if (!root.exists()) {
            throw new Exception("Directory or file does not exist:" + fileName);
        }
        if (root.isDirectory() && (files = root.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory()) {
                    FileTools.recursiveRmFile(file.getPath());
                } else {
                    FileTools.rmFile(file.getPath());
                }
                ++i;
            }
        }
        return root.delete();
    }

    public static boolean renameFile(String srcFile, String destFile) throws Exception {
        File sFile = new File(srcFile);
        if (!sFile.exists()) {
            throw new Exception("file does not exist:" + srcFile);
        }
        return sFile.renameTo(new File(destFile));
    }

    public static boolean rmFile(String fileName) throws Exception {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new Exception("file does not exist:" + fileName);
        }
        return file.delete();
    }

    public static void writeContentToFile(String fileName, byte[] content) throws Exception {
        try (FileOutputStream fos = null;){
            fos = FileTools.openOutputStream(new File(fileName));
            ((OutputStream)fos).write(content, 0, content.length);
            fos.flush();
        }
    }

    public static boolean isExist(String relativePath) {
        Boolean ret = fileCache.get(relativePath);
        if (ret == null) {
            if (new File(String.valueOf(VarDef.BSP_WORKSPACE) + relativePath).exists()) {
                fileCache.put(relativePath, new Boolean(true));
                return true;
            }
            ClassPathResource resource = new ClassPathResource(relativePath);
            boolean exist = resource.exists();
            fileCache.put(relativePath, new Boolean(exist));
            return exist;
        }
        return ret;
    }
}

