/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import cn.com.yusys.yusp.bsp.resources.core.VarDef;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class FileChecker {
    private Logger logger = LoggerFactory.getLogger(FileChecker.class);
    public static String ENV_CHECKE_INTERNAL = "bsp.checkeInternal";
    private long jarFileModifiedTime = 0L;
    public static long DEFAULT_CHECK_INTERNAL = 10000L;
    public static Map<String, FileChecker> app2Object;
    private Map<String, Boolean> checkChangedMap = new ConcurrentHashMap<String, Boolean>();
    private Map<String, Boolean> existFileMap = new ConcurrentHashMap<String, Boolean>();
    private Map<String, String> absDirMap = new ConcurrentHashMap<String, String>();
    private Map<String, String> vDirMap = new ConcurrentHashMap<String, String>();
    public static final Set<String> V_FILE_TYPE_SET;
    private FileCheckThread fileCheckThread = null;
    private Thread thread;
    private boolean running = true;
    private String appName;
    private static final char DOT = '.';
    private static final char SLASH = '/';

    static {
        String internal = System.getProperty(ENV_CHECKE_INTERNAL, "10000");
        try {
            DEFAULT_CHECK_INTERNAL = Integer.parseInt(internal);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        app2Object = new HashMap<String, FileChecker>();
        V_FILE_TYPE_SET = new HashSet<String>();
        V_FILE_TYPE_SET.add("mfd");
        V_FILE_TYPE_SET.add("dsf");
    }

    private FileChecker(String appName) {
        this.appName = appName;
        this.fileCheckThread = new FileCheckThread();
        this.thread = new Thread((Runnable)this.fileCheckThread, "FILE-CHECK-THREAD:" + appName);
        this.thread.setDaemon(true);
        this.thread.setPriority(1);
        this.thread.start();
    }

    public static FileChecker getDefaultInstance() {
        String defaultApp = "DefaultChecker";
        return FileChecker.getInstance(defaultApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileChecker getInstance(String appName) {
        FileChecker fileChecker = app2Object.get(appName);
        if (fileChecker == null) {
            Map<String, FileChecker> map = app2Object;
            synchronized (map) {
                fileChecker = app2Object.get(appName);
                if (fileChecker == null) {
                    fileChecker = new FileChecker(appName);
                    app2Object.put(appName, fileChecker);
                }
            }
        }
        return fileChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChanged(String filename) {
        Boolean changedFlag = this.checkChangedMap.get(filename);
        if (changedFlag == null || changedFlag.booleanValue()) {
            String string = filename.intern();
            synchronized (string) {
                block7: {
                    changedFlag = this.checkChangedMap.get(filename);
                    if (changedFlag != null) break block7;
                    if (this.fileCheckThread.registryChangedFile(filename)) {
                        this.checkChangedMap.put(filename, false);
                    }
                    return true;
                }
                if (changedFlag.booleanValue()) {
                    this.checkChangedMap.put(filename, false);
                }
            }
        }
        return changedFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExisted(String reletivFilename) {
        Boolean flag = this.existFileMap.get(reletivFilename);
        if (flag == null) {
            String string = reletivFilename.intern();
            synchronized (string) {
                flag = this.existFileMap.get(reletivFilename);
                if (flag == null) {
                    this.fileCheckThread.registryExistFile(reletivFilename);
                    flag = this.existFileMap.get(reletivFilename);
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPathInVDir(String folderPath, String fileName) {
        String vPathKey = String.valueOf(folderPath) + '/' + fileName;
        String path = this.vDirMap.get(vPathKey);
        if (path != null) {
            return path;
        }
        String string = fileName.intern();
        synchronized (string) {
            path = this.vDirMap.get(vPathKey);
            if (path == null) {
                path = this.nestFindFile(new File(folderPath), fileName);
                if (path != null && this.isExisted(path)) {
                    this.absDirMap.put(path, vPathKey);
                    this.vDirMap.put(vPathKey, path);
                }
                return path;
            }
            return path;
        }
    }

    private void updateVDir(String fileName) {
        int index = fileName.lastIndexOf(46);
        String type = fileName.substring(index + 1);
        if (V_FILE_TYPE_SET.contains(type)) {
            String vPath = this.absDirMap.get(fileName);
            if (vPath != null) {
                this.vDirMap.remove(vPath);
            }
            this.absDirMap.remove(fileName);
        }
    }

    private String nestFindFile(File dir, String fileName) {
        String realPath = dir.getAbsolutePath();
        String path = String.valueOf(realPath) + '/' + fileName;
        File r = new File(path);
        if (r.isFile()) {
            return path;
        }
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathName) {
                return pathName.isDirectory();
            }
        });
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String subPath = this.nestFindFile(file.getAbsoluteFile(), fileName);
                if (subPath != null) {
                    return subPath;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void exit() {
        this.setRunning(false);
        this.thread.interrupt();
        app2Object.remove(this.appName);
    }

    public class FileCheckThread
    implements Runnable {
        Set<String> checkFileSet = new CopyOnWriteArraySet<String>();
        Set<String> existFileSet = new CopyOnWriteArraySet<String>();
        Map<String, Long> lastModifiedMap = new ConcurrentHashMap<String, Long>();

        @Override
        public void run() {
            LogbackUtil.removeSingleInfo("serialno");
            while (FileChecker.this.isRunning()) {
                try {
                    Thread.sleep(DEFAULT_CHECK_INTERNAL);
                    ArrayList<String> deletedFileList = new ArrayList<String>();
                    if (this.checkFileSet.size() > 0) {
                        for (String fileName : this.checkFileSet) {
                            if (FileTools.fetchFileExists(fileName)) {
                                Long lastModifiedTime;
                                long currentModifiedTime = FileChecker.this.jarFileModifiedTime;
                                File checkFile = FileTools.fetchFile(fileName);
                                if (checkFile != null) {
                                    currentModifiedTime = checkFile.lastModified();
                                }
                                if ((lastModifiedTime = this.lastModifiedMap.get(fileName)) != null && currentModifiedTime == lastModifiedTime) continue;
                                this.lastModifiedMap.put(fileName, currentModifiedTime);
                                FileChecker.this.checkChangedMap.put(fileName, true);
                                if (!FileChecker.this.logger.isInfoEnabled()) continue;
                                FileChecker.this.logger.info("Resource file modified:" + fileName);
                                continue;
                            }
                            if (FileChecker.this.logger.isInfoEnabled()) {
                                FileChecker.this.logger.info("Resource file deleted:" + fileName);
                            }
                            this.removeFromCheckMap(fileName);
                            deletedFileList.add(fileName);
                        }
                    }
                    if (this.existFileSet.size() <= 0) continue;
                    for (String fileName : this.existFileSet) {
                        boolean logFlag;
                        Boolean flag = (Boolean)FileChecker.this.existFileMap.get(fileName);
                        Boolean existFlag = FileTools.fetchFileExists(fileName);
                        if (existFlag.equals(flag)) continue;
                        boolean bl = logFlag = !deletedFileList.contains(fileName);
                        if (existFlag.booleanValue()) {
                            FileChecker.this.existFileMap.put(fileName, true);
                            if (!FileChecker.this.logger.isInfoEnabled() || !logFlag) continue;
                            FileChecker.this.logger.info("File added:" + fileName);
                            continue;
                        }
                        FileChecker.this.existFileMap.put(fileName, false);
                        FileChecker.this.updateVDir(fileName);
                        if (!FileChecker.this.logger.isInfoEnabled() || !logFlag) continue;
                        FileChecker.this.logger.info("File deleted:" + fileName);
                    }
                }
                catch (InterruptedException deletedFileList) {
                }
                catch (Throwable e) {
                    FileChecker.this.logger.error("File change check tool class @ FileCheckThread run error", e);
                }
            }
        }

        public boolean registryChangedFile(String filename) {
            File file = new File(VarDef.BSP_WORKSPACE, filename);
            if (!file.exists()) {
                ClassPathResource resource = new ClassPathResource(filename);
                if (!resource.exists()) {
                    return false;
                }
                this.checkFileSet.add(filename);
                this.lastModifiedMap.put(filename, FileChecker.this.jarFileModifiedTime);
                return true;
            }
            long last = file.lastModified();
            this.checkFileSet.add(filename);
            this.lastModifiedMap.put(filename, last);
            return true;
        }

        public boolean registryExistFile(String reletivFilename) {
            if (!FileTools.fetchFileExists(reletivFilename)) {
                FileChecker.this.existFileMap.put(reletivFilename, false);
            } else {
                FileChecker.this.existFileMap.put(reletivFilename, true);
            }
            this.existFileSet.add(reletivFilename);
            return true;
        }

        private void removeFromCheckMap(String filename) {
            this.lastModifiedMap.remove(filename);
            this.checkFileSet.remove(filename);
            FileChecker.this.checkChangedMap.remove(filename);
        }
    }
}

