/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources.sn;

import cn.com.yusys.yusp.bsp.resources.ResourceException;
import cn.com.yusys.yusp.bsp.resources.core.VarDef;
import cn.com.yusys.yusp.bsp.resources.sn.AbstractSnGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSnGenerator
extends AbstractSnGenerator {
    private static final long serialVersionUID = 410808082875719635L;
    private static final Logger logger = LoggerFactory.getLogger(FileSnGenerator.class);
    protected File snFile;
    protected String fileName = "key.ser";

    @Override
    public void saveSn() throws ResourceException {
        OutputStream fos = null;
        try {
            try {
                fos = new BufferedOutputStream(new FileOutputStream(this.snFile));
                fos.write(String.valueOf(this.nextSaveSn).getBytes());
                fos.flush();
            }
            catch (FileNotFoundException e) {
                throw new ResourceException("Serial number file does not exist", e);
            }
            catch (IOException e) {
                throw new ResourceException("Failed to save serial number to file", e);
            }
            catch (Throwable e) {
                throw new ResourceException("Exception in saving serial number to file", e);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.init(Thread.currentThread().getName());
    }

    @Override
    public void doStop() throws Exception {
        this.nextSaveSn = this.currentSn;
        this.saveSn();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void init(String bundlerId) throws Exception {
        block15: {
            String rootPath = String.valueOf(VarDef.BSP_WORKSPACE_COMMONCONFIG) + "/sn/";
            String snPath = String.valueOf(rootPath) + this.getBundlerId().replaceAll("[.]", "/");
            File snDir = new File(snPath);
            if (!snDir.isDirectory()) {
                snDir.mkdirs();
            }
            this.snFile = new File(String.valueOf(snPath) + "/" + this.fileName);
            if (this.formatStr == null || this.formatStr.length() == 0) {
                this.formatStr = "00000000";
            }
            this.format = new DecimalFormat(this.formatStr);
            if (this.snFile.exists()) {
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(this.snFile);
                        byte[] bsn = new byte[fis.available()];
                        fis.read(bsn);
                        this.currentSn = Long.parseLong(new String(bsn).trim());
                    }
                    catch (FileNotFoundException e) {
                        throw new ResourceException("Serial number file does not exist:" + this.fileName, e);
                    }
                    catch (Throwable e) {
                        logger.error("Failed to parse the serial number file, the serial number is reinitialized", e);
                        this.currentSn = this.minValue;
                        if (fis != null) {
                            fis.close();
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        fis.close();
                    }
                    throw throwable;
                }
                if (fis != null) {
                    fis.close();
                }
            } else {
                this.currentSn = this.minValue;
            }
        }
        if (this.currentSn >= this.maxValue) {
            this.currentSn = this.minValue;
        }
        this.nextSaveSn = this.currentSn + (long)this.interval;
        if (this.nextSaveSn > this.maxValue) {
            this.nextSaveSn = this.maxValue;
        }
        this.saveSn();
    }
}

