/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources.pool.thread;

import cn.com.yusys.yusp.bsp.resources.core.AbstractBean;
import cn.com.yusys.yusp.bsp.resources.pool.thread.RejectedExecutionHandler;
import cn.com.yusys.yusp.bsp.resources.pool.thread.ThreadAbortedException;
import cn.com.yusys.yusp.bsp.resources.pool.thread.ThreadPoolExecutor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorWrapper
extends AbstractBean {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorWrapper.class);
    private ThreadFactory threadFactory = null;
    public static final String POLICY_WAIT = "wait";
    public static final String POLICY_ABORT = "abort";
    private ThreadPoolExecutor executor;
    private int maximumPoolSize;
    private int corePoolSize;
    private long keepAliveTime = 600000L;
    private String policy = "wait";
    @Deprecated
    private int queueSize = 500;
    private long queueTimeout = 60000L;
    private static final String abortInfo = "The maximum number of tasks has been exceeded";

    @Override
    public void doStart() throws Exception {
        final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(this.maximumPoolSize);
        this.executor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, queue);
        if (this.threadFactory == null) {
            final String serviceId = this.getSid();
            this.threadFactory = new ThreadFactory(){
                int count = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setName(String.valueOf(serviceId) + "-" + this.count++);
                    thread.setDaemon(false);
                    return thread;
                }
            };
            this.executor.setThreadFactory(this.threadFactory);
        }
        this.executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                boolean ret = false;
                try {
                    if (!executor.isShutdown()) {
                        ret = ExecutorWrapper.POLICY_ABORT.equals(ExecutorWrapper.this.getPolicy()) ? queue.offer(r) : queue.offer(r, ExecutorWrapper.this.queueTimeout, TimeUnit.MILLISECONDS);
                    }
                    if (ret) {
                        logger.warn("put into executor after some timewait.");
                        return;
                    }
                }
                catch (InterruptedException e) {
                    logger.error("rejectedExecution Exception", (Throwable)e);
                }
                if (logger.isWarnEnabled()) {
                    logger.warn("AbortPolicy was called. {} was aborted. Current queue size:{}", (Object)r, (Object)queue.size());
                }
                throw new RejectedExecutionException();
            }
        });
    }

    @Override
    public void doStop() throws Exception {
        this.executor.shutdownNow();
        this.executor = null;
    }

    public void execute(Runnable task) throws ThreadAbortedException {
        try {
            this.executor.execute(task);
        }
        catch (RejectedExecutionException e) {
            throw new ThreadAbortedException(abortInfo);
        }
    }

    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setQueueTimeout(long queueTimeout) {
        this.queueTimeout = queueTimeout;
    }
}

