/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources.log;

import cn.com.yusys.yusp.bsp.resources.log.BspSpan;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.MDC;

public class Slf4jSpanLogger {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    public void logStartedSpan(BspSpan parent, BspSpan span) {
        MDC.put((String)"X-B3-SpanId", (String)span.getStringSpanId());
        MDC.put((String)"X-B3-TraceId", (String)span.getStringTraceId());
        if (parent != null) {
            MDC.put((String)"X-B3-ParentSpanId", (String)parent.getStringSpanId());
        }
        MDC.put((String)"G_SN", (String)(String.valueOf(this.sdf.format(new Date())) + Slf4jSpanLogger.randomNum6()));
    }

    public void logStoppedSpan() {
        MDC.remove((String)"X-B3-SpanId");
        MDC.remove((String)"X-Span-Export");
        MDC.remove((String)"X-B3-TraceId");
        MDC.remove((String)"X-B3-ParentSpanId");
        MDC.remove((String)"G_SN");
    }

    public static String randomNum6() {
        return String.valueOf((int)((Math.random() * 9.0 + 1.0) * 100000.0));
    }
}

