/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources;

import cn.com.yusys.yusp.bsp.resources.ClassLoaderRegistry;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class BspAppContext
extends FileSystemXmlApplicationContext {
    private Resource[] configResources;

    protected Resource[] getConfigResources() {
        return this.configResources;
    }

    public BspAppContext(String absolutePath) {
        super(absolutePath);
    }

    public BspAppContext(String[] configLocations, Boolean refresh) {
        super(configLocations, refresh.booleanValue());
    }

    public BspAppContext(String[] configLocations, Boolean refresh, ApplicationContext parent) {
        super(configLocations, refresh.booleanValue(), parent);
    }

    public BspAppContext(String xml, ApplicationContext parent) {
        super(parent);
        String[] xmls = new String[]{xml};
        this.configResources = new Resource[xmls.length];
        int i = 0;
        while (i < xmls.length) {
            this.configResources[i] = new ByteArrayResource(xmls[i].getBytes());
            ++i;
        }
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        return new DefaultListableBeanFactory(this.getInternalParentBeanFactory()){

            protected Class<?> resolveBeanClass(RootBeanDefinition mbd, String beanName, Class[] typesToMatch) throws CannotLoadBeanClassException {
                try {
                    return super.resolveBeanClass(mbd, beanName, typesToMatch);
                }
                catch (CannotLoadBeanClassException e) {
                    Class<?> clazz = this.loadBundlerClass(mbd);
                    if (clazz == null) {
                        throw e;
                    }
                    return clazz;
                }
            }

            private Class<?> loadBundlerClass(RootBeanDefinition mbd) throws CannotLoadBeanClassException {
                Class clazz = null;
                ClassLoader clazzLoader = ClassLoaderRegistry.getClassLoader(mbd.getBeanClassName());
                if (clazzLoader == null) {
                    return clazz;
                }
                try {
                    clazz = mbd.resolveBeanClass(clazzLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return clazz;
            }
        };
    }
}

