/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method.util;

import java.math.BigInteger;
import java.text.DecimalFormat;

public class CurrencuUtil {
    public static String[] rmbNumbers = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u4e24", "\u5eff", "\u5345", "\u25cb"};
    public static String[] bigNumbers = new String[]{"\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396", "\u4fe9", "\u5eff", "\u5345", "\u96f6"};
    public static Long[] tonumbers = new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 2L, 2L, 3L, 0L};
    public static String[] rmbMult = new String[]{"\u4ebf", "\u4e07", "\u5343", "\u767e", "\u5341"};
    public static String[] bigRmbMult = new String[]{"\u5104", "\u842c", "\u4edf", "\u4f70", "\u62fe"};
    public static Long[] toMult = new Long[]{100000000L, 10000L, 1000L, 100L, 10L};
    public static final String[] RMBDW = new String[]{"\u5143", "\u5706"};
    public static final String[] DECIMALDW = new String[]{"\u89d2", "\u5206"};
    private static char[] chineseAmt = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
    private static char[] units = new char[]{'\u62fe', '\u4f70', '\u4edf'};
    private static char[] chineseUnits = new char[]{'\u5143', '\u4e07', '\u4ebf', '\u5146'};
    private static char[] smallUnits = new char[]{'\u5206', '\u89d2'};
    private static final BigInteger radix = new BigInteger("10");
    private static final char ZEROCHAR = '\u96f6';

    public static String rmbBig2Small(String money) {
        int index = money.indexOf(RMBDW[0]) > 0 ? money.indexOf(RMBDW[0]) : money.indexOf(RMBDW[1]);
        boolean isDecim = false;
        if (index == -1) {
            int n = index = money.indexOf(DECIMALDW[0]) > 0 ? money.indexOf(DECIMALDW[0]) : money.indexOf(DECIMALDW[1]);
            if (index == -1) {
                index = money.length();
            } else {
                --index;
                isDecim = true;
            }
        }
        String intPart = money.substring(0, index);
        String decimalPart = "";
        if (index + 1 < money.length()) {
            if (isDecim) {
                --index;
            }
            decimalPart = money.substring(index + 1);
        }
        String dp = CurrencuUtil.decimalBigToSmall(decimalPart);
        String ret = CurrencuUtil.intBigToSmall(intPart);
        ret = String.valueOf(ret) + "." + dp;
        return ret;
    }

    private static String decimalBigToSmall(String money) {
        if (money.length() == 0) {
            return "00";
        }
        StringBuilder sb = new StringBuilder();
        int index = money.indexOf(DECIMALDW[0]);
        String tmp = null;
        if (index > 0) {
            tmp = money.substring(0, index);
            sb.append(CurrencuUtil.getNumByBig(tmp));
        } else {
            sb.append(0);
        }
        index = money.indexOf(DECIMALDW[1]);
        if (index > 0) {
            tmp = money.substring(index - 1, index);
            sb.append(CurrencuUtil.getNumByBig(tmp));
        } else {
            sb.append(0);
        }
        return sb.toString();
    }

    private static String intBigToSmall(String money) {
        Long number = 0L;
        int i = 0;
        while (i < rmbMult.length) {
            int index;
            int n = index = money.lastIndexOf(rmbMult[i]) == -1 ? money.lastIndexOf(bigRmbMult[i]) : money.lastIndexOf(rmbMult[i]);
            if (index >= 0) {
                String storeMult = money.substring(0, index);
                money = money.substring(index + 1);
                number = (storeMult == null || storeMult.length() <= 0) && toMult[i].intValue() == 10 ? Long.valueOf(number + toMult[i]) : Long.valueOf(number + toMult[i] * CurrencuUtil.getPrexNum(storeMult));
            }
            ++i;
        }
        number = number + CurrencuUtil.getNumByBig(money);
        return number.toString();
    }

    private static Long getPrexNum(String storeMult) {
        Long result = 0L;
        int i = 0;
        while (i < rmbMult.length) {
            int index;
            int n = index = storeMult.lastIndexOf(rmbMult[i]) == -1 ? storeMult.lastIndexOf(bigRmbMult[i]) : storeMult.lastIndexOf(rmbMult[i]);
            if (index >= 0) {
                String storeMult2 = storeMult.substring(0, index);
                storeMult = storeMult.substring(index + 1);
                result = (storeMult2 == null || storeMult2.length() <= 0) && toMult[i].intValue() == 10 ? Long.valueOf(result + toMult[i]) : Long.valueOf(result + CurrencuUtil.getNumByBig(storeMult2) * toMult[i]);
            }
            ++i;
        }
        if (storeMult != null && storeMult.length() > 0) {
            result = result + CurrencuUtil.getNumByBig(storeMult);
        }
        return result;
    }

    private static Long getNumByBig(String big) {
        Long result = 0L;
        int j = 0;
        while (j < rmbNumbers.length) {
            big = big.replaceAll(rmbNumbers[j], tonumbers[j].toString());
            big = big.replaceAll(bigNumbers[j], tonumbers[j].toString());
            ++j;
        }
        try {
            result = Long.valueOf(big);
        }
        catch (Exception e) {
            result = 0L;
        }
        return result;
    }

    public static void main(String[] args) {
        String strValue = "\u58f9\u62fe\u4e07\u58f9\u89d2\u8d30\u5206";
        System.out.println(strValue);
        String s = CurrencuUtil.rmbBig2Small(strValue);
        System.out.println(s);
        System.out.println(CurrencuUtil.rmbSmall2Big(Double.parseDouble(s)));
        double d = 30000.12;
        System.out.println(d);
        String v = CurrencuUtil.rmbSmall2Big(d);
        System.out.println(v);
        System.out.println(CurrencuUtil.rmbBig2Small(v));
    }

    private static String formatInt(BigInteger num) {
        if (num.equals(BigInteger.ZERO)) {
            return "\u96f6\u5143";
        }
        if (num.toString().length() > 16) {
            throw new RuntimeException("too max num:" + num);
        }
        StringBuffer result = new StringBuffer("");
        int i = 0;
        char preChar = '\u0000';
        while (num.compareTo(BigInteger.ZERO) == 1) {
            StringBuffer tmp = new StringBuffer();
            BigInteger rest = num.mod(radix);
            num = num.divide(radix);
            if (rest.equals(BigInteger.ZERO) && i % 4 != 0 && preChar != '\u96f6' && CurrencuUtil.inArray(chineseAmt, preChar)) {
                tmp.append('\u96f6');
            } else if (!rest.equals(BigInteger.ZERO)) {
                tmp.append(chineseAmt[rest.intValue()]);
                if (i % 4 != 0) {
                    tmp.append(units[i % 4 - 1]);
                }
            }
            if (i % 4 == 0) {
                if (i / 4 > 0 && CurrencuUtil.inArray(chineseUnits, result.charAt(0))) {
                    result.delete(0, 1);
                }
                tmp.append(chineseUnits[i / 4]);
            }
            preChar = tmp.length() > 0 ? tmp.charAt(0) : (char)'\u0000';
            ++i;
            result.insert(0, tmp);
        }
        return result.toString();
    }

    private static String formatSmall(int small) {
        if (small > 100) {
            throw new RuntimeException("too small");
        }
        StringBuffer result = new StringBuffer("");
        char preChar = '\u0000';
        int i = 0;
        while (small > 0) {
            StringBuffer tmp = new StringBuffer();
            int rest = small % 10;
            small /= 10;
            if (rest == 0 && preChar != '\u96f6' && CurrencuUtil.inArray(chineseAmt, preChar)) {
                tmp.append('\u96f6');
            } else if (rest != 0) {
                tmp.append(chineseAmt[rest]);
                tmp.append(smallUnits[i]);
            }
            preChar = tmp.length() > 0 ? tmp.charAt(0) : (char)'\u0000';
            ++i;
            result.insert(0, tmp);
        }
        return result.toString();
    }

    private static boolean inArray(char[] array, char c) {
        char[] cArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (ch == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String rmbSmall2Big(double num) {
        DecimalFormat df = new DecimalFormat("#.00");
        String input = df.format(num);
        StringBuffer sb = new StringBuffer();
        int index = input.indexOf(46);
        if (index != -1) {
            if (index != 0) {
                sb.append(CurrencuUtil.formatInt(new BigInteger(input.substring(0, index))));
                if (sb.indexOf(RMBDW[0]) == -1) {
                    sb.append(RMBDW[0]);
                }
            }
            sb.append(CurrencuUtil.formatSmall(Integer.parseInt(input.substring(index + 1))));
        }
        return sb.toString();
    }
}

