/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method.impl;

import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateMethodTool {
    private static final Logger logger = LoggerFactory.getLogger(DateMethodTool.class);
    private static final char CHAR_BLANK = ' ';
    private static final String CHAR_D = "d";
    private static final String CHAR_H = "H";
    private static final String CHAR_h = "h";
    private static final String CHAR_LOW_M = "m";
    private static final String CHAR_M = "M";
    private static final String CHAR_S = "s";
    private static final char CHAR_TWO = '2';
    private static final String CHAR_Y = "y";
    private static final String CHAR_YY = "yy";
    private static final char CHAR_ZERO = '0';
    private static final String D_T_F = "DateTimeFormat";
    private static final String R_D_F = "RDateFormat";
    private static final String R_D_T_F = "RDateTimeFormat";
    private static final String R_T_F = "RTimeFormat";
    private static final String S_D_F = "SDateFormat";
    private static final String S_D_T_F = "SDateTimeFormat";
    private static final String S_T_F = "STimeFormat";

    public static String formatDate(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        String RDF = StringTools.getString(paras.get(R_D_F));
        if (StringTools.isEmpty(RDF) || srcData.length != ByteTools.getBytes(RDF).length) {
            logger.warn("Format date function @ incorrect date parameter, original value returned");
            return new String(srcData);
        }
        int bsy = RDF.indexOf(CHAR_Y);
        int bey = RDF.lastIndexOf(CHAR_Y);
        int bsm = RDF.indexOf(CHAR_M);
        int bem = RDF.lastIndexOf(CHAR_M);
        int bsd = RDF.indexOf(CHAR_D);
        int bed = RDF.lastIndexOf(CHAR_D);
        int bynum = bey - bsy + 1;
        int bmnum = bem - bsm + 1;
        int bdnum = bed - bsd + 1;
        String SDF = StringTools.getString(paras.get(S_D_F));
        if (StringTools.isEmpty(SDF)) {
            logger.warn("Format date function @ incorrect date parameter, original value returned");
            return new String(srcData);
        }
        byte[] bt = SDF.getBytes();
        int sy = SDF.indexOf(CHAR_Y);
        int ey = SDF.lastIndexOf(CHAR_Y);
        int sm = SDF.indexOf(CHAR_M);
        int em = SDF.lastIndexOf(CHAR_M);
        int sd = SDF.indexOf(CHAR_D);
        int ed = SDF.lastIndexOf(CHAR_D);
        int ynum = ey - sy + 1;
        int mnum = em - sm + 1;
        int dnum = ed - sd + 1;
        if (sy != -1 && bsy != -1) {
            if (ynum == bynum) {
                int i = sy;
                int j = bsy;
                while (i <= ey && j <= bey) {
                    bt[i] = srcData[j];
                    ++i;
                    ++j;
                }
            } else if (ynum == bynum + 2) {
                bt[sy] = 50;
                bt[sy + 1] = 48;
                int i = sy + 2;
                int j = bsy;
                while (i <= ey && j <= bey) {
                    bt[i] = srcData[j];
                    ++i;
                    ++j;
                }
            } else if (ynum == bynum - 2) {
                int i = sy;
                int j = bsy + 2;
                while (i <= ey && j <= bey) {
                    bt[i] = srcData[j];
                    ++i;
                    ++j;
                }
            } else {
                System.err.println("incorrect date parameter!");
            }
        } else if (sy != -1 && bsy == -1) {
            byte[] ybt = new byte[2];
            SimpleDateFormat date = new SimpleDateFormat(CHAR_YY);
            ybt = date.format(new Date()).getBytes();
            if (ynum == 2) {
                bt[sy] = ybt[0];
                bt[sy + 1] = ybt[1];
            } else if (ynum == 4) {
                bt[sy] = 50;
                bt[sy + 1] = 48;
                bt[sy + 2] = ybt[0];
                bt[sy + 3] = ybt[1];
            } else {
                System.err.println("incorrect date parameter");
            }
        }
        if (sm != -1) {
            if (mnum == bmnum) {
                int i = sm;
                int j = bsm;
                while (i <= em && j <= bem) {
                    bt[i] = srcData[j];
                    ++i;
                    ++j;
                }
            } else if (mnum == bmnum + 1) {
                bt[sm] = 48;
                bt[sm + 1] = srcData[bem];
            } else if (mnum == bmnum - 1) {
                bt[sm] = srcData[bem];
            } else {
                System.err.println("incorrect date parameter");
            }
        }
        if (sd != -1) {
            if (dnum == bdnum) {
                int i = sd;
                int j = bsd;
                while (i <= ed && j <= bed) {
                    bt[i] = srcData[j];
                    ++i;
                    ++j;
                }
            } else if (dnum == bdnum + 1) {
                bt[sd] = 48;
                bt[sd + 1] = srcData[bed];
            } else if (dnum == bdnum - 1) {
                bt[sd] = srcData[bed];
            } else {
                System.err.println("incorrect date parameter");
            }
        }
        return new String(bt);
    }

    public static String formatDateTime(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        String RDTF = StringTools.getString(paras.get(R_D_T_F));
        String SDTF = StringTools.getString(paras.get(S_D_T_F));
        if (StringTools.isEmpty(RDTF) || StringTools.isEmpty(SDTF)) {
            logger.warn("Format date and time function @ format parameter is not configured, original value returned");
            return new String(srcData);
        }
        String RDF = RDTF.substring(0, RDTF.indexOf(32));
        String RTF = RDTF.substring(RDTF.indexOf(32)).trim();
        String SDF = SDTF.substring(0, SDTF.indexOf(32));
        String STF = SDTF.substring(SDTF.indexOf(32)).trim();
        paras.put(R_D_F, RDF);
        paras.put(S_D_F, SDF);
        paras.put(R_T_F, RTF);
        paras.put(S_T_F, STF);
        String srcDateTime = new String(srcData);
        String srcDate = srcDateTime.substring(0, srcDateTime.indexOf(32));
        String srcTime = srcDateTime.substring(srcDateTime.indexOf(32)).trim();
        return DateMethodTool.formatDate(srcDate.getBytes(), paras, context) + ' ' + DateMethodTool.formatTime(srcTime.getBytes(), paras, context);
    }

    public static String formatTime(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        int j;
        int i;
        byte[] srcData = ByteTools.getBytes(_srcData);
        String RTF = StringTools.getString(paras.get(R_T_F));
        if (StringTools.isEmpty(RTF) || srcData.length != StringTools.getString(paras.get(R_T_F)).getBytes().length) {
            logger.warn("Format time function @ incorrect time parameter, original value returned");
            return new String(srcData);
        }
        int bsh = RTF.indexOf(CHAR_H);
        int beh = RTF.lastIndexOf(CHAR_H);
        int bsm = RTF.indexOf(CHAR_LOW_M);
        int bem = RTF.lastIndexOf(CHAR_LOW_M);
        int bss = RTF.indexOf(CHAR_S);
        int bes = RTF.lastIndexOf(CHAR_S);
        String STF = StringTools.getString(paras.get(S_T_F));
        if (StringTools.isEmpty(STF)) {
            logger.warn("Format time function @ incorrect time parameter, original value returned");
            return new String(srcData);
        }
        byte[] bt = STF.getBytes();
        int ash = STF.indexOf(CHAR_H);
        int aeh = STF.lastIndexOf(CHAR_H);
        int asm = STF.indexOf(CHAR_LOW_M);
        int aem = STF.lastIndexOf(CHAR_LOW_M);
        int ass = STF.indexOf(CHAR_S);
        int aes = STF.lastIndexOf(CHAR_S);
        if (bsh == -1 || ash == -1) {
            bsh = RTF.indexOf(CHAR_h);
            beh = RTF.lastIndexOf(CHAR_h);
            ash = STF.indexOf(CHAR_h);
            aeh = STF.lastIndexOf(CHAR_h);
        }
        if (ash != -1) {
            i = ash;
            j = bsh;
            while (i <= aeh && j <= beh) {
                bt[i] = srcData[j];
                ++i;
                ++j;
            }
        }
        if (asm != -1) {
            i = asm;
            j = bsm;
            while (i <= aem && j <= bem) {
                bt[i] = srcData[j];
                ++i;
                ++j;
            }
        }
        if (ass != -1) {
            i = ass;
            j = bss;
            while (i <= aes && j <= bes) {
                bt[i] = srcData[j];
                ++i;
                ++j;
            }
        }
        return new String(bt);
    }

    public static String recSystemDate(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        String srcData = StringTools.getString(_srcData);
        String DTF = StringTools.getString(paras.get(D_T_F));
        if (StringTools.isEmpty(DTF)) {
            logger.warn("Get system date and time function @ format parameter is not configured, original value returned");
            return new String(srcData);
        }
        SimpleDateFormat date = new SimpleDateFormat(DTF);
        return date.format(new Date());
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        byte[] b = "20110413      205522".getBytes();
        paras.put(R_D_T_F, "yyyyMMdd    hhmmss");
        paras.put(S_D_T_F, "yyyy-MM-dd    hh:mm:ss");
        String s1 = DateMethodTool.formatDateTime(b, paras, null);
        System.out.println(new String(s1));
    }
}

