/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method.impl;

import cn.com.yusys.yusp.bsp.method.MethodException;
import cn.com.yusys.yusp.bsp.method.impl.IntMethodTool;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataValidationMethodTools {
    private static final String TARGET_LEN = "targetLength";
    public static final String PARA_REGEX = "paraRegex";
    private static final String R_D_F = "RDateFormat";
    public static final String PARA_ENUM = "paraEnum";
    public static final String ENUM_SEP = "[|]";
    public static final String LEN_OPERATION = "lenOperation";
    private static final String LEN_EQU = "lenEqu";
    private static final String LEN_GT = "lenGt";
    private static final String LEN_LT = "lenLt";
    private static final String LEN_RANGE = "lenRange";
    private static final String LEN_START = "lenStart";
    private static final Logger logger = LoggerFactory.getLogger(DataValidationMethodTools.class);
    private static final String CHAR_D = "d";
    private static final String CHAR_M = "M";
    private static final char CHAR_TWO = '2';
    private static final String CHAR_Y = "y";
    private static final String CHAR_YY = "yy";
    private static final char CHAR_ZERO = '0';

    public static Object checkLen(Object _srcData, Map<String, Object> paras, Map<String, Object> context) throws Exception {
        String itemName = StringTools.getString(paras.get("ItemName"));
        String itemDesc = StringTools.getString(paras.get("ItemDesc"));
        try {
            int targetLength = StringTools.isEmpty(StringTools.getString(paras.get(TARGET_LEN))) ? 0 : Integer.parseInt(StringTools.getString(paras.get(TARGET_LEN)));
            if (targetLength < 0) {
                targetLength = 0;
            }
            String option = StringTools.getString(paras.get(LEN_OPERATION));
            byte[] srcData = ByteTools.getBytes(_srcData);
            if (LEN_EQU.equals(option)) {
                if (srcData.length != targetLength) {
                    logger.warn("Validate data length @ illegal [] length, data length[], validated length is []", new Object[]{StringTools.getString(_srcData), srcData.length, targetLength});
                    String message = "The source data length [" + srcData.length + "] is inconsistent with the validated length [" + targetLength + "]";
                    throw new MethodException(message);
                }
                logger.debug("Validate data length @ legal data");
            } else if (LEN_GT.equals(option)) {
                if (srcData.length <= targetLength) {
                    logger.warn("Validate data length @ illegal [] length, data length[], validated length is []", new Object[]{StringTools.getString(_srcData), srcData.length, targetLength});
                    String message = "Source data length [" + srcData.length + "] is not greater than validated length [" + targetLength + "]";
                    throw new MethodException(message);
                }
                logger.debug("Validate data length @ legal data");
            } else if (LEN_LT.equals(option)) {
                if (srcData.length >= targetLength) {
                    logger.warn("Validate data length @ illegal [] length, data length[], validated length is []", new Object[]{StringTools.getString(_srcData), srcData.length, targetLength});
                    String message = "Source data length [" + srcData.length + "] is not less than validated length [" + targetLength + "]";
                    throw new MethodException(message);
                }
                logger.debug("Validate data length @ legal data");
            } else if (LEN_RANGE.equals(option)) {
                int start = Integer.parseInt(StringTools.getString(paras.get(LEN_START)));
                if (srcData.length > targetLength || srcData.length < start) {
                    logger.warn("Validate data length @ illegal [] length, data length[], validated length is []", new Object[]{StringTools.getString(_srcData), srcData.length, targetLength});
                    String message = "Source data length [" + srcData.length + "] is not between validated length [" + start + "," + targetLength + "]";
                    throw new MethodException(message);
                }
                logger.debug("Validate data length @ legal data");
            }
        }
        catch (Exception e) {
            throw new MethodException(e.getMessage(), "Validate data length", StringTools.getString(_srcData), itemName, itemDesc);
        }
        return _srcData;
    }

    public static Object checkMust(Object srcData, Map<String, Object> paras, Map<String, Object> context) throws MethodException {
        String itemName = StringTools.getString(paras.get("ItemName"));
        String itemDesc = StringTools.getString(paras.get("ItemDesc"));
        try {
            if (srcData == null) {
                throw new Exception("The validation failed");
            }
            String ret = StringTools.getString(srcData);
            if (StringTools.isEmpty(ret)) {
                throw new Exception("The validation failed");
            }
        }
        catch (Exception e) {
            throw new MethodException(e.getMessage(), "Validation required", StringTools.getString(srcData), itemName, itemDesc);
        }
        return srcData;
    }

    public static String checkID(String srcData, Map<String, Object> paras, Map<String, Object> context) {
        try {
            String regex = StringTools.getString(paras.get(PARA_REGEX));
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(srcData);
            matcher.matches();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return srcData;
    }

    public static Object checkDataByRegex(Object _srcData, Map<String, Object> paras, Map<String, Object> context) throws MethodException {
        String itemName = StringTools.getString(paras.get("ItemName"));
        String itemDesc = StringTools.getString(paras.get("ItemDesc"));
        try {
            String srcData = StringTools.getString(_srcData);
            String regex = StringTools.getString(paras.get(PARA_REGEX));
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(srcData);
            if (!matcher.matches()) {
                String message = "Regular expression mismatch";
                throw new MethodException(message);
            }
            logger.debug("Regular expression validation @ data legal");
        }
        catch (Exception e) {
            throw new MethodException(e.getMessage(), "Regular expression validation", StringTools.getString(_srcData), itemName, itemDesc);
        }
        return _srcData;
    }

    public static Object checkDateFormat(Object srcData, Map<String, Object> paras, Map<String, Object> context) throws MethodException {
        String itemName = StringTools.getString(paras.get("ItemName"));
        String itemDesc = StringTools.getString(paras.get("ItemDesc"));
        try {
            String _srcData = StringTools.getString(srcData);
            byte[] data = ByteTools.getBytes(srcData);
            String RDF = StringTools.getString(paras.get(R_D_F));
            if (data.length != ByteTools.getBytes(RDF).length) {
                String message = "Inconsistent with expected data format [" + RDF + "]";
                throw new MethodException(message);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(RDF);
            String ret = dateFormat.format(dateFormat.parse(_srcData));
            if (!ret.equals(_srcData)) {
                String message = "Inconsistent with expected data format [" + ret + "]";
                throw new MethodException(message);
            }
            logger.debug("Validate date format @ legal data");
        }
        catch (Exception e) {
            String message = e.getMessage();
            throw new MethodException(message, "Validate date format", StringTools.getString(srcData), itemName, itemDesc);
        }
        return srcData;
    }

    public static Object checkAMTFormat(Object _srcData, Map<String, Object> paras, Map<String, Object> context) throws MethodException {
        String itemName = StringTools.getString(paras.get("ItemName"));
        String itemDesc = StringTools.getString(paras.get("ItemDesc"));
        try {
            String ret = IntMethodTool.formatMoney(_srcData, paras, context);
            byte[] srcData = ByteTools.getBytes(_srcData);
            String str = new String(srcData);
            if (!str.equals(ret)) {
                String message = "Inconsistent with expected data format " + ret + "]";
                throw new MethodException(message);
            }
            logger.debug("Validate amount format @ legal data");
        }
        catch (Exception e) {
            throw new MethodException(e.getMessage(), "Validate amount format", StringTools.getString(_srcData), itemName, itemDesc);
        }
        return _srcData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String formatDate(Object _srcData, Map<String, Object> paras, Map<String, Object> context) throws MethodException {
        byte[] srcData = ByteTools.getBytes(_srcData);
        String RDF = StringTools.getString(paras.get(R_D_F));
        int bsy = RDF.indexOf(CHAR_Y);
        int bey = RDF.lastIndexOf(CHAR_Y);
        int bsm = RDF.indexOf(CHAR_M);
        int bem = RDF.lastIndexOf(CHAR_M);
        int bsd = RDF.indexOf(CHAR_D);
        int bed = RDF.lastIndexOf(CHAR_D);
        int bynum = bey - bsy + 1;
        int bmnum = bem - bsm + 1;
        int bdnum = bed - bsd + 1;
        String SDF = StringTools.getString(paras.get(R_D_F));
        if (StringTools.isEmpty(SDF)) {
            throw new MethodException("Illegal date");
        }
        byte[] bt = SDF.getBytes();
        int sy = SDF.indexOf(CHAR_Y);
        int ey = SDF.lastIndexOf(CHAR_Y);
        int sm = SDF.indexOf(CHAR_M);
        int em = SDF.lastIndexOf(CHAR_M);
        int sd = SDF.indexOf(CHAR_D);
        int ed = SDF.lastIndexOf(CHAR_D);
        int ynum = ey - sy + 1;
        int mnum = em - sm + 1;
        int dnum = ed - sd + 1;
        if (sy != -1 && bsy != -1) {
            if (ynum == bynum) {
                int i = sy;
                int j = bsy;
                while (i <= ey && j <= bey) {
                    bt[i] = srcData[j];
                    ++i;
                    ++j;
                }
            } else if (ynum == bynum + 2) {
                bt[sy] = 50;
                bt[sy + 1] = 48;
                int i = sy + 2;
                int j = bsy;
                while (i <= ey && j <= bey) {
                    bt[i] = srcData[j];
                    ++i;
                    ++j;
                }
            } else {
                if (ynum != bynum - 2) throw new MethodException("Illegal date");
                int i = sy;
                int j = bsy + 2;
                while (i <= ey && j <= bey) {
                    bt[i] = srcData[j];
                    ++i;
                    ++j;
                }
            }
        } else if (sy != -1 && bsy == -1) {
            byte[] ybt = new byte[2];
            SimpleDateFormat date = new SimpleDateFormat(CHAR_YY);
            ybt = date.format(new Date()).getBytes();
            if (ynum == 2) {
                bt[sy] = ybt[0];
                bt[sy + 1] = ybt[1];
            } else {
                if (ynum != 4) throw new MethodException("Illegal date");
                bt[sy] = 50;
                bt[sy + 1] = 48;
                bt[sy + 2] = ybt[0];
                bt[sy + 3] = ybt[1];
            }
        }
        if (sm != -1) {
            if (mnum == bmnum) {
                int i = sm;
                int j = bsm;
                while (i <= em && j <= bem) {
                    bt[i] = srcData[j];
                    ++i;
                    ++j;
                }
            } else if (mnum == bmnum + 1) {
                bt[sm] = 48;
                bt[sm + 1] = srcData[bem];
            } else {
                if (mnum != bmnum - 1) throw new MethodException("Illegal date");
                bt[sm] = srcData[bem];
            }
        }
        if (sd == -1) return new String(bt);
        if (dnum == bdnum) {
            int i = sd;
            int j = bsd;
            while (i <= ed && j <= bed) {
                bt[i] = srcData[j];
                ++i;
                ++j;
            }
            return new String(bt);
        } else if (dnum == bdnum + 1) {
            bt[sd] = 48;
            bt[sd + 1] = srcData[bed];
            return new String(bt);
        } else {
            if (dnum != bdnum - 1) throw new MethodException("Illegal date");
            bt[sd] = srcData[bed];
        }
        return new String(bt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object checkEnum(Object _srcData, Map<String, Object> paras, Map<String, Object> context) throws Exception {
        String itemName = StringTools.getString(paras.get("ItemName"));
        String itemDesc = StringTools.getString(paras.get("ItemDesc"));
        String enumStr = StringTools.getString(paras.get(PARA_ENUM));
        try {
            String srcStr = StringTools.getString(_srcData);
            if (StringTools.isEmpty(enumStr)) throw new MethodException("Source data is [" + enumStr + "]");
            String[] str = enumStr.split(ENUM_SEP);
            if (str == null || str.length <= 0) throw new MethodException("Enumeration value is [" + srcStr + "]");
            List<String> enumList = Arrays.asList(str);
            System.out.println("enumList=" + enumList + "|" + srcStr);
            if (!enumList.contains(srcStr)) {
                throw new MethodException("Enumeration value is " + enumList + " validation failed");
            }
            logger.debug("Enumeration validation @ legal data");
            return _srcData;
        }
        catch (Exception e) {
            throw new MethodException(e.getMessage(), "Enumeration validation", StringTools.getString(_srcData), itemName, itemDesc);
        }
    }
}

