/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.filter;

import cn.com.yusys.yusp.bsp.filter.BspFilterResult;
import cn.com.yusys.yusp.bsp.filter.ExecutionStatus;
import cn.com.yusys.yusp.bsp.filter.IBspFilter;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BspFilter
implements IBspFilter,
Comparable<BspFilter>,
Cloneable {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String shouldFilter = "true";
    public String filterType;

    public String filterType() {
        if (StringTools.isEmpty(this.filterType)) {
            return this.getFilterType();
        }
        return this.filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public abstract String getFilterType();

    public abstract int filterOrder();

    public BspFilter clone() throws CloneNotSupportedException {
        return (BspFilter)super.clone();
    }

    public BspFilterResult runFilter(Map<String, Object> context) throws Exception {
        BspFilterResult br;
        block5: {
            br = null;
            if (this.shouldFilter()) {
                try {
                    boolean result = this.run(context);
                    if (result) {
                        br = new BspFilterResult(result, ExecutionStatus.SUCCESS);
                        break block5;
                    }
                    br = new BspFilterResult(result, ExecutionStatus.FAILED);
                    br.setException(new Exception("Filter failed"));
                }
                catch (Exception e) {
                    br = new BspFilterResult(ExecutionStatus.FAILED);
                    br.setException(e);
                }
            } else {
                br = new BspFilterResult(true, ExecutionStatus.SKIPPED);
            }
        }
        return br;
    }

    @Override
    public int compareTo(BspFilter filter) {
        return Integer.compare(this.filterOrder(), filter.filterOrder());
    }

    @Override
    public boolean shouldFilter() {
        return !"false".equalsIgnoreCase(this.shouldFilter);
    }

    public String getShouldFilter() {
        return this.shouldFilter;
    }

    public void setShouldFilter(String shouldFilter) {
        this.shouldFilter = shouldFilter;
    }

    public void addAutoPackContext(Map<String, Object> context, String key, Object value) {
        context.put(key, value);
        HashMap<String, Object> autoMap = (HashMap<String, Object>)context.get("__T_AUTOPACK");
        if (autoMap == null) {
            autoMap = new HashMap<String, Object>();
            context.put("__T_AUTOPACK", autoMap);
        }
        autoMap.put(key, value);
    }

    public void removeAutoPackContext(Map<String, Object> context, String key) {
        context.remove(key);
        Map autoMap = (Map)context.get("__T_AUTOPACK");
        if (autoMap != null) {
            autoMap.remove(key);
        }
    }
}

