/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheHead;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Group;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Head;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.While;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import cn.com.yusys.yusp.bsp.toolkit.xml.Attribute;
import cn.com.yusys.yusp.bsp.toolkit.xml.Namespace;
import cn.com.yusys.yusp.bsp.toolkit.xml.SuperXMLNode;
import cn.com.yusys.yusp.bsp.toolkit.xml.SuperXmlTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SuperXmlExecutor
extends AbstractExecutor<byte[]> {
    protected static final String DATA_FORMAT_NAME = "XML";
    protected static final String DATA_FORMAT_PACK_XML = "packXml";
    protected static final String DATA_FORMAT_PACK_SIMPLE = "packSimple";
    protected static final String DATA_FORMAT_VALUEVARIABLE = "valueVariable";
    protected static final String DATA_FORMAT_CDATAVARIABLE = "cdataVariable";
    protected static final String DATA_FORMAT_LOOPNODES = "loopNodes";
    protected static final String DATA_FORMAT_SIGN = "sign";
    protected static final String DATA_FORMAT_USEVALUE = "useValue";
    protected static final String ITEM_ATRRIBUTE_TYPE = "type";
    protected static final String ITEM_ATRRIBUTE_PATH = "path";
    protected static final String ITEM_ATRRIBUTE_PREFIX = "prefix";
    protected static final String ITEM_ATRRIBUTE_VARNAME = "varName";
    protected static final String ITEM_ATRRIBUTE_EMPTYWHILE = "emptyWhile";
    protected static final String ITEM_TYPE_VALUE = "value";
    protected static final String ITEM_TYPE_NAMESPACES = "namespace";
    protected static final String ITEM_TYPE_DEFAULT_NAMESPACES = "defNamespace";
    protected static final String ITEM_TYPE_PROPERTY = "property";
    protected static final String ITEM_TYPE_CDATA = "cdata";
    protected static final String ITEM_TYPE_XML = "xml";
    protected static final String SOAP_DEFAULT_SIGN = "_";
    protected static final String defNamespace = "xmlns";
    protected String valueVariable = "value";
    protected String cdataVariable = "cdata";
    protected List<List<String>> loopNodes;
    protected List<String> signList;
    protected boolean useValue = false;
    protected SuperXmlTools xmlTools;
    protected int state = -2;
    protected SuperXMLNode xmlNode;
    protected boolean packNode;
    protected String nodePrefix;
    protected String nodeName;
    protected boolean packSimple;
    protected static final String V_SIZE = ".size()";
    protected LinkedList<String> nodeList = new LinkedList();

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    protected boolean supportItemMust() {
        return true;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        int n;
        int n2;
        char[] cArray;
        Object[] temp;
        String str = null;
        str = property.get(DATA_FORMAT_SIGN);
        if (StringTools.isEmpty(str)) {
            this.signList = null;
        } else {
            this.signList = new ArrayList<String>();
            cArray = temp = str.toCharArray();
            n2 = temp.length;
            n = 0;
            while (n < n2) {
                char c = cArray[n];
                this.signList.add(String.valueOf(c));
                ++n;
            }
        }
        this.xmlTools = new SuperXmlTools(this.getEncoding());
        if (this.getPackType() == DATAFORMAT_UNPACK) {
            str = property.get(DATA_FORMAT_VALUEVARIABLE);
            if (!StringTools.isEmpty(str)) {
                this.valueVariable = str;
            }
            if (!StringTools.isEmpty(str = property.get(DATA_FORMAT_CDATAVARIABLE))) {
                this.cdataVariable = str;
            }
            if (StringTools.isEmpty(str = property.get(DATA_FORMAT_LOOPNODES))) {
                this.loopNodes = null;
            } else {
                this.loopNodes = new ArrayList<List<String>>();
                cArray = temp = (Object[])str.split("[,]");
                n2 = temp.length;
                n = 0;
                while (n < n2) {
                    char string = cArray[n];
                    this.loopNodes.add(this.convertPathToList((String)string));
                    ++n;
                }
            }
            if ("true".equals(property.get(DATA_FORMAT_USEVALUE))) {
                this.useValue = true;
            }
        } else {
            str = property.get(DATA_FORMAT_PACK_XML);
            Boolean packXml = true;
            if ("false".equals(str)) {
                packXml = false;
            }
            if ("true".equals(str = property.get(DATA_FORMAT_PACK_SIMPLE))) {
                this.packSimple = true;
            }
            this.xmlTools.setPackSimple(this.packSimple);
            this.xmlTools.writeStartDocument(packXml);
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
        try {
            this.xmlNode = this.xmlTools.readerXML(inputData);
        }
        catch (Exception e) {
            throw new Exception("[" + this.getExecutorName() + "] Exception in unpacking", e);
        }
    }

    @Override
    public byte[] outputInner() throws Exception {
        byte[] data = null;
        try {
            data = this.xmlTools.writeEndDocument();
        }
        catch (Exception e) {
            throw new Exception("[" + this.getExecutorName() + "] Packaging exception", e);
        }
        return data;
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        if (this.state < 0) {
            throw new Exception("[" + this.getExecutorName() + "] field [" + item.getName() + "] must be in category or loop");
        }
        if (this.packNode) {
            this.xmlTools.writeStartElement(this.nodePrefix, this.nodeName);
            this.packNode = false;
            ++this.state;
        }
        String type = paras.get(ITEM_ATRRIBUTE_TYPE);
        String path = paras.get(ITEM_ATRRIBUTE_PATH);
        if (StringTools.isEmpty(path)) {
            path = item.getName();
        }
        if (ITEM_TYPE_VALUE.equals(type)) {
            if (this.packSimple && data.length == 0) {
                return;
            }
            this.xmlTools.writeCharacters(data);
        } else if (ITEM_TYPE_PROPERTY.equals(type)) {
            String prefix = paras.get(ITEM_ATRRIBUTE_PREFIX);
            this.xmlTools.writeAttribute(prefix, path, data);
        } else if (ITEM_TYPE_NAMESPACES.equals(type)) {
            this.xmlTools.writeNamespace(path, data);
        } else if (ITEM_TYPE_DEFAULT_NAMESPACES.equals(type)) {
            this.xmlTools.writeDefaultNamespace(data);
        } else if (ITEM_TYPE_CDATA.equals(type)) {
            this.xmlTools.writeCData(data);
        } else if (ITEM_TYPE_XML.equals(type)) {
            this.xmlTools.writeXML(data);
        } else {
            throw new Exception("The type [" + type + "] of [" + this.getExecutorName() + "] field [" + item.getName() + "] cannot be parsed.");
        }
    }

    @Override
    public void packGroup(Group group) throws Exception {
        if (this.state == -1) {
            throw new Exception("[" + this.getExecutorName() + "]classify[" + group.getName() + "] must be in category or loop");
        }
        if (this.packNode) {
            this.xmlTools.writeStartElement(this.nodePrefix, this.nodeName);
            this.packNode = false;
            ++this.state;
        }
        String prefix = null;
        String name = null;
        Head head = group.getHead();
        if (!(head instanceof CacheHead)) {
            throw new Exception("Illegal group header");
        }
        CacheHead cacheHead = (CacheHead)head;
        prefix = cacheHead.getParas().get(ITEM_ATRRIBUTE_PREFIX);
        name = cacheHead.getParas().get(ITEM_ATRRIBUTE_VARNAME);
        if (StringTools.isEmpty(name)) {
            name = group.getName();
        }
        int oldState = this.state;
        if (this.state == -2) {
            this.xmlTools.writeStartElement(prefix, name);
            this.packNode = false;
            this.state = 1;
            oldState = 0;
        } else {
            this.packNode = true;
            this.nodePrefix = prefix;
            this.nodeName = name;
        }
        this.packBody(group.getBody());
        if (this.packNode) {
            this.packNode = false;
        } else {
            this.xmlTools.writeEndElement(prefix, name, ++oldState < this.state);
        }
        if (this.state > oldState) {
            this.state = oldState == 1 ? -1 : oldState;
        }
    }

    @Override
    public void packWhile(While _while) throws Exception {
        if (this.state < 0) {
            throw new Exception("[" + this.getExecutorName() + "]loop[" + _while.getName() + "] must be in category or loop");
        }
        Head head = _while.getHead();
        String name = null;
        String prefix = null;
        boolean emptyWhile = false;
        if (head instanceof CacheHead) {
            CacheHead cacheHead = (CacheHead)head;
            prefix = cacheHead.getParas().get(ITEM_ATRRIBUTE_PREFIX);
            name = cacheHead.getParas().get(ITEM_ATRRIBUTE_VARNAME);
            String empty = cacheHead.getParas().get(ITEM_ATRRIBUTE_EMPTYWHILE);
            if (empty != null) {
                emptyWhile = new Boolean(empty);
            }
        } else {
            throw new Exception("Illegal loop header");
        }
        boolean nodeExpr = false;
        if (StringTools.isEmpty(name)) {
            name = _while.getName();
        } else if (name.indexOf(34) != -1) {
            nodeExpr = true;
        }
        String tmpNodeName = this.nodeName;
        if (this.packNode) {
            this.xmlTools.writeStartElement(this.nodePrefix, this.nodeName);
            this.packNode = false;
            ++this.state;
        }
        String varname = _while.getVar();
        int nCount = this.parseLoopCount(_while);
        int oldState = this.state;
        int i = 0;
        while (i < nCount) {
            if (!emptyWhile) {
                this.packNode = true;
            }
            this.nodePrefix = prefix;
            this.rootContext.put(varname, new Integer(i));
            this.nodeName = nodeExpr ? StringTools.getString(OgnlTools.getValue(name, this.getRootContext())) : name;
            tmpNodeName = this.nodeName;
            this.packBody(_while.getBody());
            if (this.packNode) {
                this.packNode = false;
            } else if (!emptyWhile) {
                this.xmlTools.writeEndElement(prefix, tmpNodeName, ++oldState < this.state);
            }
            if (this.state > oldState) {
                this.state = oldState == 1 ? -1 : oldState;
            }
            ++i;
        }
        this.rootContext.remove(varname);
    }

    @Override
    public Map<String, Object> autoUnpack() throws Exception {
        HashMap<String, Object> soapMap = new HashMap<String, Object>();
        this.xmlNode2Map(this.xmlNode, soapMap, this.useValue);
        return soapMap;
    }

    @Override
    public byte[] unPackItem(Item item, Map<String, String> paras) throws Exception {
        List<String> list;
        String path = paras.get(ITEM_ATRRIBUTE_PATH);
        boolean isPath = false;
        if (StringTools.isEmpty(path)) {
            path = this.getRealItemPath(item);
            isPath = true;
        }
        if (!(list = this.convertPathToList(path)).get(0).equals(this.xmlNode.getName())) {
            return null;
        }
        String type = paras.get(ITEM_ATRRIBUTE_TYPE);
        if (ITEM_TYPE_VALUE.equals(type)) {
            SuperXMLNode node;
            if (isPath) {
                list.remove(list.size() - 1);
            }
            if ((node = this.getXmlNode(list)) == null) {
                return null;
            }
            String value = node.getValue();
            return value.getBytes(this.getEncoding());
        }
        if (ITEM_TYPE_PROPERTY.equals(type)) {
            String proName = list.remove(list.size() - 1);
            SuperXMLNode node = this.getXmlNode(list);
            if (node == null) {
                return null;
            }
            return node.getAttributeValue(proName, this.getEncoding());
        }
        if (ITEM_TYPE_NAMESPACES.equals(type)) {
            String name = list.remove(list.size() - 1);
            SuperXMLNode node = this.getXmlNode(list);
            if (node == null) {
                return null;
            }
            return node.getNamespaceValue(name, this.getEncoding());
        }
        if (ITEM_TYPE_DEFAULT_NAMESPACES.equals(type)) {
            SuperXMLNode node;
            if (isPath) {
                list.remove(list.size() - 1);
            }
            if ((node = this.getXmlNode(list)) == null) {
                return null;
            }
            return node.getNamespaceValue("", this.getEncoding());
        }
        if (ITEM_TYPE_CDATA.equals(type)) {
            SuperXMLNode node;
            if (isPath) {
                list.remove(list.size() - 1);
            }
            if ((node = this.getXmlNode(list)) == null) {
                return null;
            }
            return node.getCData(this.getEncoding());
        }
        if (ITEM_TYPE_XML.equals(type)) {
            SuperXMLNode node;
            if (isPath) {
                list.remove(list.size() - 1);
            }
            if ((node = this.getXmlNode(list)) == null) {
                return null;
            }
            byte[] data = this.xmlTools.getXMLNodeByte(node);
            return data;
        }
        throw new Exception("The type [" + type + "] of [" + this.getExecutorName() + "] field [" + item.getName() + "] cannot be parsed.");
    }

    @Override
    protected void unPackWhile(While _while) throws Exception {
        String count = _while.getMaxNum();
        String name = _while.getName();
        String varname = _while.getVar();
        String sCount = null;
        int nCount = -1;
        if (StringTools.isEmpty(count)) {
            count = this.getRealWhilePath(_while);
            List<String> list = this.convertLoopCountExprToList(count);
            nCount = this.getLoopSize(list);
            if (nCount == -1) {
                this.logger.warn("{} @ Structure corresponding to loop [{}] does not exist, loop ignored", new Object[]{this.getExecutorName(), count});
                return;
            }
        } else {
            try {
                sCount = StringTools.getString(OgnlTools.getValue(count, this.rootContext));
            }
            catch (Exception e1) {
                if (count.endsWith(V_SIZE)) {
                    List<String> list = this.convertLoopCountExprToList(count);
                    list.remove(list.size() - 1);
                    nCount = this.getLoopSize(list);
                    if (nCount == -1) {
                        throw new Exception(String.valueOf(this.getExecutorName()) + " @ The value corresponding to the number of loop times [" + count + "] of loop [" + this.getRealWhilePath(_while) + "] does not exist");
                    }
                }
                throw new Exception(String.valueOf(this.getExecutorName()) + " @ The value corresponding to the number of loop times [" + count + "] of loop [" + this.getRealWhilePath(_while) + "] does not exist");
            }
            if (nCount == -1) {
                if (StringTools.isEmpty(sCount)) {
                    throw new Exception(String.valueOf(this.getExecutorName()) + " @ The variable value corresponding to the number of loop times [" + count + "] of loop [" + this.getRealWhilePath(_while) + "] does not exist");
                }
                try {
                    nCount = Integer.parseInt(sCount);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.valueOf(this.getExecutorName()) + " @ The loop times in loop [" + this.getRealWhilePath(_while) + "] must be number, the current value=" + sCount, e);
                }
            }
        }
        super.unPackWhile(nCount, name, varname, _while);
    }

    protected SuperXMLNode getXmlNode(List<String> list) throws Exception {
        Object obj = null;
        String tempName = null;
        int start = -1;
        int index = -1;
        int end = -1;
        SuperXMLNode tempNode = this.xmlNode;
        List tempList = null;
        int i = 1;
        while (i < list.size()) {
            index = -1;
            tempName = list.get(i);
            start = tempName.indexOf("[");
            end = tempName.indexOf("]");
            if (start != -1 && end != -1) {
                obj = OgnlTools.getValue(tempName.substring(start + 1, end), this.getRootContext());
                index = Integer.valueOf(obj.toString());
                tempName = tempName.substring(0, start);
            }
            if ((obj = tempNode.getChildren().get(tempName)) == null) {
                return null;
            }
            if (obj instanceof SuperXMLNode) {
                if (index > 0) {
                    return null;
                }
                tempNode = (SuperXMLNode)obj;
            } else if (obj instanceof List) {
                tempList = (List)obj;
                if (index == -1 || index >= tempList.size()) {
                    return null;
                }
                tempNode = (SuperXMLNode)tempList.get(index);
            }
            ++i;
        }
        return tempNode;
    }

    protected int getLoopSize(List<String> list) throws Exception {
        Object obj = null;
        String tempName = null;
        int start = -1;
        int index = -1;
        int end = -1;
        SuperXMLNode tempNode = this.xmlNode;
        int size = list.size() - 1;
        if (!list.get(0).equals(this.xmlNode.getName())) {
            return -1;
        }
        List tempList = null;
        int i = 1;
        while (i <= size) {
            index = -1;
            tempName = list.get(i);
            start = tempName.indexOf("[");
            end = tempName.indexOf("]");
            if (start != -1 && end != -1) {
                obj = OgnlTools.getValue(tempName.substring(start + 1, end), this.getRootContext());
                index = Integer.valueOf(obj.toString());
                tempName = tempName.substring(0, start);
            }
            if ((obj = tempNode.getChildren().get(tempName)) instanceof SuperXMLNode) {
                if (index > 0) {
                    return -1;
                }
                tempNode = (SuperXMLNode)obj;
            } else if (obj instanceof List) {
                tempList = (List)obj;
                if (i == size) {
                    return tempList.size();
                }
                if (index == -1 || index >= tempList.size()) {
                    return -1;
                }
                tempNode = (SuperXMLNode)tempList.get(index);
            } else {
                return -1;
            }
            ++i;
        }
        return 1;
    }

    protected String convertSign(String str) {
        if (this.signList == null || StringTools.isEmpty(str)) {
            return str;
        }
        for (String temp : this.signList) {
            if (str.indexOf(temp) == -1) continue;
            str = str.replace(temp, SOAP_DEFAULT_SIGN);
        }
        return str;
    }

    protected List<String> convertPathToList(String path) {
        String[] loopNode;
        ArrayList<String> loop = new ArrayList<String>();
        path = StringUtils.replace((String)path, (String)"/", (String)".");
        String[] stringArray = loopNode = StringUtils.split((String)path, (String)".");
        int n = loopNode.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!StringTools.isEmpty(s)) {
                loop.add(s);
            }
            ++n2;
        }
        return loop;
    }

    protected List<String> convertLoopCountExprToList(String path) {
        ArrayList<String> loop = new ArrayList<String>();
        path = StringUtils.replace((String)path, (String)"/", (String)".");
        String[] loopNode = StringUtils.split((String)path, (String)".");
        int i = 0;
        while (i < loopNode.length) {
            if (!StringTools.isEmpty(loopNode[i])) {
                loop.add(loopNode[i]);
            }
            ++i;
        }
        return loop;
    }

    protected void xmlNode2Map(SuperXMLNode xml, Object root, boolean _useValue) throws Exception {
        String tempName;
        String name = xml.getName();
        this.nodeList.add(name);
        String value = xml.getValue().trim();
        Map<String, Object> children = xml.getChildren();
        Map<String, Namespace> namespaces = xml.getNamespaces();
        Map<String, Attribute> attributes = xml.getAttrs();
        String cdata = xml.getCDATA();
        int childSize = children.size();
        int attributeSize = attributes.size();
        int namespaceSize = namespaces.size();
        if (!_useValue) {
            if (childSize == 0 && (namespaceSize > 0 || attributeSize > 0)) {
                throw new Exception("Value variable must be true when leaf node [" + name + "] includes attribute or namespace");
            }
            if (!StringTools.isEmpty(cdata) && !StringTools.isEmpty(value)) {
                throw new Exception("Value variable must be true when leaf node [" + name + "] value and CDATA exist at the same time");
            }
            if (childSize == 0) {
                String text = "";
                if (StringTools.isEmpty(value)) {
                    if (!StringTools.isEmpty(cdata)) {
                        text = cdata;
                    }
                } else {
                    text = StringTools.getString(this.invokeMethods(this.getGlobalParseMethod(), value, 1));
                }
                if (root instanceof List) {
                    ((List)root).add(text);
                } else if (root instanceof Map) {
                    String tempName2 = this.convertSign(name);
                    ((Map)root).put(tempName2, text);
                }
                this.nodeList.removeLast();
                return;
            }
        }
        HashMap<String, Object> nodeMap = new HashMap<String, Object>();
        if (!StringTools.isEmpty(cdata)) {
            nodeMap.put(this.cdataVariable, cdata);
        }
        if (value != null && (value.length() > 0 || childSize == 0)) {
            value = StringTools.getString(this.invokeMethods(this.getGlobalParseMethod(), value, 1));
            nodeMap.put(this.valueVariable, value);
        }
        if (namespaceSize != 0) {
            String prefix = null;
            for (Namespace namespace : namespaces.values()) {
                prefix = StringTools.isEmpty(namespace.getPrefix()) ? defNamespace : namespace.getPrefix();
                prefix = this.convertSign(prefix);
                nodeMap.put(prefix, namespace.getUri());
            }
        }
        if (attributeSize != 0) {
            tempName = null;
            for (Attribute attr : attributes.values()) {
                tempName = this.convertSign(attr.getName());
                value = StringTools.getString(this.invokeMethods(this.getGlobalParseMethod(), attr.getValue(), 1));
                nodeMap.put(tempName, value);
            }
        }
        tempName = this.convertSign(name);
        if (root instanceof List) {
            ((List)root).add(nodeMap);
        } else if (root instanceof Map) {
            ((Map)root).put(tempName, nodeMap);
        }
        Object obj = null;
        for (String key : children.keySet()) {
            LinkedList childrenList;
            obj = children.get(key);
            if (obj instanceof SuperXMLNode) {
                if (this.validateLoop(this.nodeList, key)) {
                    childrenList = new LinkedList();
                    nodeMap.put(key, childrenList);
                    this.xmlNode2Map((SuperXMLNode)obj, childrenList, _useValue);
                    continue;
                }
                this.xmlNode2Map((SuperXMLNode)obj, nodeMap, _useValue);
                continue;
            }
            if (obj instanceof List) {
                childrenList = new LinkedList();
                nodeMap.put(key, childrenList);
                for (SuperXMLNode tempNode : (List)obj) {
                    this.xmlNode2Map(tempNode, childrenList, _useValue);
                }
                continue;
            }
            throw new Exception("Type not supported:" + obj);
        }
        this.nodeList.removeLast();
    }

    protected boolean validateLoop(LinkedList<String> nodeList, String key) {
        if (this.loopNodes == null) {
            return false;
        }
        boolean res = false;
        nodeList.add(key);
        for (List<String> list : this.loopNodes) {
            if (list.size() != nodeList.size() || !list.equals(nodeList)) continue;
            res = true;
            break;
        }
        nodeList.removeLast();
        return res;
    }

    @Override
    public int getSearchIndex() {
        return -1;
    }
}

