/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.DataFormatException;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.util.Map;

public class ExecutorHelper {
    public static final String FILL_STYLE_LEFT = "left";
    public static final String FILL_STYLE_RIGHT = "right";
    public static final String REGEX_HEX_CHAR = "[0-9]|[A-F]|[a-f]";

    public static boolean isHexChar(String str) {
        return str.matches(REGEX_HEX_CHAR);
    }

    public static byte[] defFillData(String executorName, Item item, byte[] data, String fLen, String fillStyle, byte[] filler, Map<String, Object> rootContext, boolean exprEnabled) throws Exception {
        if (StringTools.isEmpty(fLen)) {
            throw new Exception("The data length of" + item.getName() + " field in " + executorName + " cannot be empty");
        }
        int len = 0;
        try {
            if (exprEnabled) {
                Object obj = OgnlTools.getValue(fLen, rootContext);
                len = StringTools.getInt(obj);
            } else {
                len = Integer.parseInt(fLen);
            }
        }
        catch (Exception e) {
            throw new Exception("The data length type of [" + item.getName() + "] field in [" + executorName + "] is incorrect!" + fLen, e);
        }
        int dataLen = data.length;
        if (len > dataLen) {
            if (filler.length == 0) {
                throw new Exception("The length of [" + item.getName() + "] filed value in [" + executorName + "] is not enough!");
            }
            data = ExecutorHelper.isLeftFill(fillStyle) ? ByteTools.leftPad(data, len, filler) : ByteTools.rightPad(data, len, filler);
        } else if (len != -1 && len < dataLen) {
            throw new Exception("The length [" + dataLen + "] of  [" + item.getName() + "] field value [" + new String(data) + "] in [" + executorName + "] exceeds the defined length [" + len + "]");
        }
        return data;
    }

    public static void validataMaxLen(String executorName, Item item, int dataLen) throws Exception {
        if ((long)dataLen > 0xA00000L) {
            throw new Exception("The configured data length [" + dataLen + "] of [" + item.getName() + "] in field [" + executorName + "] is too large, exceeding the maximum buffer value [" + 0xA00000L + "]");
        }
    }

    public static boolean isLeftFill(String fillStyle) {
        if (StringTools.isEmpty(fillStyle)) {
            return true;
        }
        return FILL_STYLE_LEFT.equals(fillStyle);
    }

    public static int searchSeparatorPosition(int index, byte[] data, byte[] sep, String encoding) {
        boolean isChar = false;
        if ("UTF-8".equalsIgnoreCase(encoding) || "GB18030".equalsIgnoreCase(encoding)) {
            int i = index;
            int n = data.length;
            while (i < n) {
                if (ExecutorHelper.contrastBytes(data, i, sep)) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = index;
            int n = data.length;
            while (i < n) {
                if (!isChar && data[i] < -1) {
                    isChar = true;
                } else if (isChar || data[i] < -1) {
                    isChar = false;
                } else if (ExecutorHelper.contrastBytes(data, i, sep)) {
                    return i;
                }
                ++i;
            }
        }
        return data.length;
    }

    public static boolean contrastBytes(byte[] source, int index, byte[] target) {
        int len = target.length;
        if (source.length - index < len || len == 0) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (source[index + i] != target[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int parseItemLen(String executorName, Item item, String lenExpr, Map<String, Object> rootContext, int msgLen, int position) throws Exception {
        if (StringTools.isEmpty(lenExpr)) {
            throw new DataFormatException("Configuration item missing for " + executorName + "]filed '" + item.getName() + "' :field length");
        }
        int nLength = Integer.MIN_VALUE;
        try {
            nLength = Integer.parseInt(lenExpr);
        }
        catch (NumberFormatException nfe) {
            nLength = Integer.MIN_VALUE;
        }
        if (nLength == Integer.MIN_VALUE) {
            Object obj = null;
            try {
                obj = OgnlTools.getValue(lenExpr, rootContext);
                nLength = StringTools.getInt(obj);
            }
            catch (Exception e) {
                throw new DataFormatException("[" + executorName + "] parsing field [" + item.getName() + "] length expression exception, expression: " + lenExpr + ", parsed value: " + obj, e);
            }
        }
        if (nLength < -1) {
            throw new DataFormatException("The length value of [" + executorName + "] field [" + item.getName() + "] is negative");
        }
        if (nLength == -1) {
            nLength = msgLen - position;
        }
        return nLength;
    }

    public static byte[] parserFiller(String filler) {
        byte[] defDataFiller = null;
        defDataFiller = StringTools.isEmpty(filler) ? new byte[]{} : StringTools.escString2Byte(filler);
        return defDataFiller;
    }
}

