/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.config.service;

import cn.com.yusys.yusp.bsp.config.service.ConfigHandler;
import cn.com.yusys.yusp.bsp.resources.core.AbstractBean;
import cn.com.yusys.yusp.bsp.resources.pool.thread.ExecutorWrapper;
import cn.com.yusys.yusp.bsp.toolkit.common.Assert;
import cn.com.yusys.yusp.bsp.toolkit.common.SocketTools;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.http.params.BasicHttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ConfigService
extends AbstractBean
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ConfigService.class);
    @Value(value="${command.host:0.0.0.0}")
    private String host;
    @Value(value="${command.port:7380}")
    private int port;
    @Value(value="${command.timeout:60000}")
    private int timeout;
    @Value(value="${command.corePoolSize:5}")
    private int corePoolSize;
    @Value(value="${command.maximumPoolSize:5}")
    private int maximumPoolSize;
    @Value(value="${command.reuseAddress:false}")
    private boolean reuseAddress;
    private ServerSocket server;
    private ExecutorWrapper executorWrapper;
    private BasicHttpParams params;

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    public ConfigService() {
    }

    public ConfigService(ExecutorWrapper executorWrapper) {
        this.setExecutorWrapper(executorWrapper);
    }

    @Override
    public void doStart() throws Exception {
        Assert.notNull(this.getHost(), "config service @ service ip is not config!");
        Assert.notNull(this.getPort(), "config service @ listen is not config");
        this.executorWrapper = new ExecutorWrapper();
        this.executorWrapper.setAlive(true);
        this.executorWrapper.setCorePoolSize(this.corePoolSize);
        this.executorWrapper.setMaximumPoolSize(this.maximumPoolSize);
        this.executorWrapper.doStart();
        InetAddress addr = InetAddress.getByName(this.getHost());
        this.server = SocketTools.createServerSocket(this.reuseAddress);
        this.server.bind(new InetSocketAddress(addr, this.getPort()), 4096);
        this.params = new BasicHttpParams();
        this.params.setIntParameter("http.socket.buffer-size", 8192);
        this.params.setBooleanParameter("http.connection.stalecheck", false);
        this.params.setBooleanParameter("http.tcp.nodelay", true);
        this.params.setParameter("http.origin-server", (Object)"HttpComponents/1.1");
        new Thread((Runnable)this, String.valueOf(ConfigService.class.getSimpleName()) + ":" + this.getPort()).start();
        logger.info("config service start:{}", (Object)this.getPort());
    }

    @Override
    public void doStop() throws Exception {
        if (this.server != null) {
            this.server.close();
        }
        logger.info("config service stop");
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public ExecutorWrapper getExecutorWrapper() {
        return this.executorWrapper;
    }

    public void setExecutorWrapper(ExecutorWrapper executorWrapper) {
        this.executorWrapper = executorWrapper;
    }

    @Override
    public void run() {
        while (this.isAlive()) {
            try {
                Socket socket = this.server.accept();
                if (this.getTimeout() > 0) {
                    socket.setSoTimeout(this.timeout);
                } else {
                    socket.setSoTimeout(60000);
                }
                ConfigHandler handler = new ConfigHandler();
                handler.setConfigService(this);
                handler.setSocket(socket);
                handler.setParams(this.params);
                this.getExecutorWrapper().execute(handler);
            }
            catch (Throwable e) {
                if (!this.isAlive()) continue;
                logger.error("config service:listen exception", e);
            }
        }
    }

    public void close(Socket socket) throws IOException {
        if (socket != null) {
            socket.close();
        }
    }
}

