/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.config.service;

import cn.com.yusys.yusp.bsp.app.config.BspAutoConfiguration;
import cn.com.yusys.yusp.bsp.config.command.CommandInfo;
import cn.com.yusys.yusp.bsp.config.command.ICommand;
import cn.com.yusys.yusp.bsp.config.service.ConfigService;
import cn.com.yusys.yusp.bsp.toolkit.common.SocketTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHandler
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ConfigHandler.class);
    private Socket socket;
    private ConfigService configService;
    private BasicHttpParams params;
    private BasicHttpProcessor httpproc;
    private DefaultHttpServerConnection conn;
    private DefaultHttpResponseFactory responseFactory;
    private BasicHttpContext httpContext;
    private HttpResponse response;

    @Override
    public void run() {
        block19: {
            HashMap<String, String> context = new HashMap<String, String>();
            try {
                this.init();
                byte[] data = this.read(context);
                String commandName = (String)context.get("command");
                if (StringTools.isEmpty(commandName)) {
                    logger.error("no command to execute was specified!");
                    this.write(context, "no command to execute was specified!".getBytes("UTF-8"));
                    return;
                }
                try {
                    ICommand command = (ICommand)BspAutoConfiguration.applicationContext.getBean(commandName);
                    if (commandName.equals("batchRequest") || commandName.equals("pressureRequest")) {
                        HashMap<String, Object> configContext = new HashMap<String, Object>();
                        configContext.put("response", this.response);
                        configContext.put("httpproc", this.httpproc);
                        configContext.put("conn", this.conn);
                        configContext.put("httpContext", this.httpContext);
                        command.execute(new CommandInfo(context, configContext, data));
                        break block19;
                    }
                    CommandInfo info = command.execute(new CommandInfo(context, data));
                    info.getContext().remove("_hostname");
                    this.write(info.getContext(), info.getBody());
                }
                catch (Exception e) {
                    logger.error("HTTP request exception", (Throwable)e);
                    context.put("success", "false");
                    context.put("message", e.getMessage());
                    if (this.response == null) break block19;
                    try {
                        this.write(context, e.getMessage().getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            finally {
                try {
                    this.configService.close(this.socket);
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void init() throws Exception {
        this.httpproc = new BasicHttpProcessor();
        this.httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        this.httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        this.httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        this.httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        this.responseFactory = new DefaultHttpResponseFactory();
        this.httpContext = new BasicHttpContext(null);
        this.conn = new DefaultHttpServerConnection();
        this.conn.bind(this.socket, (HttpParams)this.params);
    }

    public byte[] read(Map<String, String> context) throws IOException {
        HttpRequest request = null;
        RequestLine requestLine = null;
        try {
            request = this.conn.receiveRequestHeader();
            request.setParams((HttpParams)new DefaultedHttpParams(request.getParams(), (HttpParams)this.params));
            requestLine = request.getRequestLine();
            String method = requestLine.getMethod();
            this.response = this.createResponse(request);
            this.httpContext.setAttribute("http.request", (Object)request);
            this.httpContext.setAttribute("http.response", (Object)this.response);
            this.httpproc.process(request, (HttpContext)this.httpContext);
            String host = this.conn.getRemoteAddress().getHostAddress();
            context.put("_hostname", host);
            this.readHeader(context, request);
            if (method.equals("POST")) {
                return this.handlePost(context, request);
            }
            logger.error("request method is not supported:" + method);
            throw new IOException("request method is not supported:" + method);
        }
        catch (Exception e) {
            throw new IOException("HTTP request exception:", e);
        }
    }

    public void write(Map<String, String> context, byte[] data) throws IOException {
        context.remove("Content-Length");
        context.remove("Transfer-Encoding");
        for (Map.Entry<String, String> element : context.entrySet()) {
            String key = element.getKey();
            String value = element.getValue();
            if (key == null || value == null) {
                throw new IOException("HTTP setting is incorrect,key=[" + key + "],value=[" + value + "]");
            }
            this.response.setHeader(key, URLEncoder.encode(value, "UTF-8"));
        }
        InputStreamEntity entity = new InputStreamEntity((InputStream)new ByteArrayInputStream(data), (long)data.length);
        this.response.setStatusCode(200);
        this.response.removeHeaders("Content-Length");
        try {
            this.response.setEntity((HttpEntity)entity);
            this.httpproc.process(this.response, (HttpContext)this.httpContext);
            this.conn.sendResponseHeader(this.response);
            this.conn.sendResponseEntity(this.response);
            this.conn.flush();
        }
        catch (HttpException e) {
            logger.error("send exception", (Throwable)e);
            throw new IOException("send exception:" + e.getMessage());
        }
    }

    private byte[] handlePost(Map<String, String> context, HttpRequest request) throws IOException {
        if (request instanceof BasicHttpEntityEnclosingRequest) {
            try {
                this.conn.receiveRequestEntity((HttpEntityEnclosingRequest)request);
            }
            catch (HttpException e) {
                logger.error("recevie body exception", (Throwable)e);
                throw new IOException("recevie body exception:" + e.getMessage());
            }
            HttpEntity entity = ((BasicHttpEntityEnclosingRequest)request).getEntity();
            byte[] bt = SocketTools.readInputStream(entity.getContent(), (int)entity.getContentLength());
            EntityUtils.consume((HttpEntity)entity);
            return bt;
        }
        logger.error("request type is not supported:" + request.getClass());
        throw new IOException("request type is not supported:" + request.getClass());
    }

    private void readHeader(Map<String, String> context, HttpRequest request) {
        Header[] header = request.getAllHeaders();
        String value = null;
        int i = 0;
        while (i < header.length) {
            value = header[i].getValue();
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            context.put(header[i].getName(), value);
            logger.trace("HTTP header:{} = {}", (Object)header[i].getName(), (Object)value);
            ++i;
        }
        this.parseUrl(context, request.getRequestLine().getUri());
    }

    private void parseUrl(Map<String, String> context, String uri) {
        int p = uri.indexOf("?");
        if (p == -1) {
            String requestUrl = uri;
            return;
        }
        String requestUrl = uri.substring(0, p);
        String sub = uri.substring(p + 1);
        String[] subs = sub.split("&");
        int i = 0;
        while (i < subs.length) {
            String[] s = subs[i].split("=");
            if (s.length != 0) {
                if (s.length == 1) {
                    context.put(s[0], "");
                    logger.trace("URL params:{} = ", (Object)s[0]);
                } else {
                    context.put(s[0], s[1]);
                    logger.trace("URL params:{} = {}", (Object)s[0], (Object)s[1]);
                }
            }
            ++i;
        }
        logger.info("request url:" + requestUrl);
    }

    private HttpResponse createResponse(HttpRequest request) {
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        if (!ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
            ver = HttpVersion.HTTP_1_1;
        }
        HttpResponse response = this.responseFactory.newHttpResponse(ver, 200, (HttpContext)this.httpContext);
        response.setParams((HttpParams)new DefaultedHttpParams(response.getParams(), (HttpParams)this.params));
        return response;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public BasicHttpParams getParams() {
        return this.params;
    }

    public void setParams(BasicHttpParams params) {
        this.params = params;
    }
}

