/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.config.command.impl;

import cn.com.yusys.yusp.bsp.app.config.AppStartAssist;
import cn.com.yusys.yusp.bsp.config.command.CommandInfo;
import cn.com.yusys.yusp.bsp.config.command.ICommand;
import cn.com.yusys.yusp.bsp.resources.BspAppContext;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.bean.SpringContextRegistry;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="module")
public class ModuleCommand
implements ICommand {
    private static final Logger logger = LoggerFactory.getLogger(ModuleCommand.class);
    private static SpringContextRegistry _contextRegistry = ResourcePortal.getInstance().getSpringContextRegistry();
    @Value(value="${spring.application.name}")
    private String msname;

    @Override
    public CommandInfo execute(CommandInfo commandInfo) throws Exception {
        CommandInfo ret = new CommandInfo(commandInfo.getContext());
        String requestId = ret.getContext().get("_hostname");
        requestId = "client[" + requestId + "] ";
        String name = ret.getContext().get("name");
        if (StringTools.isEmpty(name)) {
            logger.error(String.valueOf(requestId) + "module name is null");
            ret.getContext().put("success", "false");
            ret.getContext().put("message", "module name is null");
            return ret;
        }
        String action = ret.getContext().get("action");
        if (StringTools.isEmpty(action)) {
            logger.error(String.valueOf(requestId) + "module command is null");
            ret.getContext().put("success", "false");
            ret.getContext().put("message", "module command is null");
            return ret;
        }
        if (action.equals("list")) {
            String listRet = this.listModuleStatus(name);
            ret.getContext().put("success", listRet);
            ret.getContext().put("message", "query successfull");
        } else if (action.equals("listall")) {
            String listRet = this.listModuleStatus(AppStartAssist.getModules());
            ret.getContext().put("success", "true");
            ret.getContext().put("message", listRet);
        } else if (action.equals("start")) {
            this.startModule(name);
            ret.getContext().put("success", "true");
            ret.getContext().put("message", "start successfull");
        } else if (action.equals("restart")) {
            this.restartModule(name);
            ret.getContext().put("success", "true");
            ret.getContext().put("message", "restart successfull");
        } else if (action.equals("stop")) {
            this.stopModule(name);
            ret.getContext().put("success", "true");
            ret.getContext().put("message", "stop successfull");
        } else {
            logger.error(String.valueOf(requestId) + " module command is not right :" + action);
            ret.getContext().put("success", "false");
            ret.getContext().put("message", "module command is not right :" + action);
            return ret;
        }
        return ret;
    }

    public String listModuleStatus(String name) {
        BspAppContext context = _contextRegistry.getAppContext(name);
        return context == null ? "false" : "true";
    }

    public String listModuleStatus(List<String> list) {
        StringBuffer sb = new StringBuffer("{");
        int i = 0;
        while (i < list.size()) {
            BspAppContext context = _contextRegistry.getAppContext(list.get(i));
            if (i > 0) {
                sb.append(',');
            }
            sb.append("\"" + list.get(i) + "\":\"" + (context == null ? "false" : "true"));
            sb.append("\"");
            ++i;
        }
        return sb.append("}").toString();
    }

    public String startModule(String name) throws Exception {
        BspAppContext context = _contextRegistry.getAppContext(name);
        if (context != null) {
            throw new Exception("module [" + name + "] in microservice [" + this.msname + "] is started!");
        }
        String modulePath = this.getModulePath(name);
        if (StringTools.isEmpty(modulePath)) {
            throw new Exception("module [" + name + "] in microservice[" + this.msname + "] is not exsit!");
        }
        Map<String, IComm> outCommMap = ResourcePortal.getInstance().getOutCommMap();
        AppStartAssist.loadModule(modulePath, outCommMap);
        return "module [" + name + "] in microservice [" + this.msname + "] is started successfull!";
    }

    public String stopModule(String name) throws Exception {
        BspAppContext context = _contextRegistry.getContextMap().remove(name);
        if (context == null) {
            throw new Exception("module [" + name + "] in microservice [" + this.msname + "] is stopped!");
        }
        context.close();
        Map<String, IComm> outCommMap = ResourcePortal.getInstance().getOutCommMap();
        outCommMap.remove(name);
        return "module [" + name + "] in microservice [" + this.msname + "] is stopped successfull!";
    }

    public String restartModule(String name) throws Exception {
        BspAppContext context = _contextRegistry.getContextMap().remove(name);
        if (context == null) {
            throw new Exception("module [" + name + "] in microservice [" + this.msname + "] is stopped!");
        }
        context.close();
        Map<String, IComm> outCommMap = ResourcePortal.getInstance().getOutCommMap();
        outCommMap.remove(name);
        String modulePath = this.getModulePath(name);
        if (StringTools.isEmpty(modulePath)) {
            throw new Exception("module [" + name + "] in microservice [" + this.msname + "] is not exsit!");
        }
        AppStartAssist.loadModule(modulePath, outCommMap);
        return "module [" + name + "] in microservice [" + this.msname + "] is restarted successfull! ";
    }

    public String getModulePath(String name) {
        return "config/" + name.replaceAll("commIn.", "commIn/").replaceAll("commOut.", "commOut/") + "/module.mrd";
    }
}

