/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.config;

import cn.com.yusys.yusp.bsp.app.config.BspAutoConfiguration;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.communication.out.AbstractOutAdapter;
import cn.com.yusys.yusp.bsp.filter.BspFilter;
import cn.com.yusys.yusp.bsp.resources.BspAppContext;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.bean.SpringContextRegistry;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.comm.out.AbstractCommOut;
import cn.com.yusys.yusp.bsp.workflow.config.MsgConfig;
import cn.com.yusys.yusp.bsp.workflow.worker.AbstractDataProcess;
import cn.com.yusys.yusp.bsp.workflow.worker.IServiceUrl;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleHelper {
    private static Logger logger = LoggerFactory.getLogger(ModuleHelper.class);
    private static SpringContextRegistry _contextRegistry = ResourcePortal.getInstance().getSpringContextRegistry();

    public static void loadModule(String serviceName, String value) throws Exception {
        boolean ret;
        logger.info("msname=" + serviceName + " bean=\n" + value);
        BspAppContext xc = new BspAppContext(value, BspAutoConfiguration.applicationContext);
        _contextRegistry.addAppContext(serviceName, xc);
        xc.refresh();
        IComm comm = ModuleHelper.loadComm(xc, serviceName);
        if (comm == null) {
            return;
        }
        AbstractOutAdapter outAdapter = ModuleHelper.loadOutAdapter(xc, serviceName);
        if (outAdapter != null) {
            ((AbstractCommOut)comm).setOutAdapter(outAdapter);
            comm.setMsgConfig(outAdapter.getMsgConfig());
            Map<String, IComm> outCommMap = ResourcePortal.getInstance().getOutCommMap();
            outCommMap.put(serviceName, comm);
        }
        if (!(ret = ModuleHelper.loadCommInProcess(xc, serviceName))) {
            return;
        }
        ret = ModuleHelper.loadDataProcess(xc, serviceName);
        if (!ret) {
            return;
        }
        ModuleHelper.loadBspFilter(xc, serviceName);
    }

    public static IComm loadComm(BspAppContext xc, String serviceName) {
        String[] commName = xc.getBeanNamesForType(IComm.class);
        if (commName.length == 0) {
            logger.error("\u901a\u8baf\u7c7b\u578b\u672a\u914d\u7f6e");
            logger.warn("[{}]\u914d\u7f6e\u5ffd\u7565", (Object)serviceName);
            xc.close();
            return null;
        }
        if (commName.length > 1) {
            logger.error("\u901a\u8baf\u914d\u7f6e\u591a\u4e2a");
            logger.warn("[{}]\u914d\u7f6e\u5ffd\u7565", (Object)serviceName);
            xc.close();
            return null;
        }
        IComm comm = (IComm)xc.getBean(commName[0]);
        String[] inAdaptersName = xc.getBeanNamesForType(AbstractInAdapter.class);
        int i = 0;
        while (i < inAdaptersName.length) {
            AbstractInAdapter inAdapter = (AbstractInAdapter)xc.getBean(inAdaptersName[i]);
            inAdapter.setComm(comm);
            inAdapter.getMsgConfig().setServiceName(serviceName);
            ++i;
        }
        return comm;
    }

    public static AbstractOutAdapter loadOutAdapter(BspAppContext xc, String serviceName) {
        String[] outAdapterName = xc.getBeanNamesForType(AbstractOutAdapter.class);
        if (outAdapterName.length > 1) {
            logger.warn("{},\u4e0d\u652f\u6301\u914d\u7f6e\u591a\u4e2a\u63a5\u51fa\u9002\u914d\u5668,\u670d\u52a1\u4e0d\u542f\u52a8", (Object)serviceName);
            xc.close();
            return null;
        }
        if (outAdapterName.length == 1) {
            AbstractOutAdapter outAdapter = (AbstractOutAdapter)xc.getBean(outAdapterName[0]);
            outAdapter.getMsgConfig().setServiceName(serviceName);
            return outAdapter;
        }
        return null;
    }

    public static boolean loadCommInProcess(BspAppContext xc, String serviceName) throws Exception {
        String[] serviceUrls = xc.getBeanNamesForType(IServiceUrl.class);
        if (serviceUrls.length > 1) {
            logger.warn("{},\u91cd\u590d\u914d\u7f6e\u63a5\u5165\u6269\u5c55\u670d\u52a1\u5b9e\u73b0\u3010IServiceUrl\u3011,\u670d\u52a1\u4e0d\u542f\u52a8", (Object)serviceName);
            xc.close();
            return false;
        }
        if (serviceUrls.length == 1) {
            MsgConfig msgConfig = ModuleHelper.findServiceConfig(xc, serviceName);
            IServiceUrl serviceUrl = (IServiceUrl)xc.getBean(serviceUrls[0]);
            msgConfig.setServiceUrl(serviceUrl);
        }
        return true;
    }

    public static boolean loadDataProcess(BspAppContext xc, String serviceName) throws Exception {
        String[] dataProcess = xc.getBeanNamesForType(AbstractDataProcess.class);
        if (dataProcess.length > 1) {
            logger.warn("{},\u91cd\u590d\u914d\u7f6e\u63a5\u5165\u6269\u5c55\u670d\u52a1\u5b9e\u73b0\u3010IDataProcess\u3011,\u670d\u52a1\u4e0d\u542f\u52a8", (Object)serviceName);
            xc.close();
            return false;
        }
        if (dataProcess.length == 1) {
            MsgConfig msgConfig = ModuleHelper.findServiceConfig(xc, serviceName);
            AbstractDataProcess dataProcessIns = (AbstractDataProcess)xc.getBean(dataProcess[0]);
            msgConfig.setDataProcess(dataProcessIns);
            dataProcessIns.setMsgConfig(msgConfig);
        }
        return true;
    }

    public static boolean loadBspFilter(BspAppContext xc, String serviceName) throws Exception {
        String[] filters = xc.getBeanNamesForType(BspFilter.class);
        if (filters.length > 0) {
            MsgConfig msgConfig = ModuleHelper.findServiceConfig(xc, serviceName);
            int i = 0;
            while (i < filters.length) {
                BspFilter filter = (BspFilter)xc.getBean(filters[i]);
                if ("PRE".equals(filter.filterType())) {
                    msgConfig.getPreFilter().add(filter);
                } else if ("POST".equals(filter.filterType())) {
                    msgConfig.getPostFilter().add(filter);
                } else if ("BOTH".equals(filter.filterType())) {
                    filter.setFilterType("PRE");
                    msgConfig.getPreFilter().add(filter);
                    filter = filter.clone();
                    filter.setFilterType("POST");
                    msgConfig.getPostFilter().add(filter);
                } else {
                    logger.warn("\u8fc7\u6ee4\u5668\u7c7b\u578b[" + filter.filterType() + "]\u4e0d\u652f\u6301");
                }
                ++i;
            }
        }
        return true;
    }

    public static MsgConfig findServiceConfig(BspAppContext xc, String serviceName) throws Exception {
        String[] msgConfigs = xc.getBeanNamesForType(MsgConfig.class);
        if (msgConfigs.length != 1) {
            logger.warn("{},\u62a5\u6587\u914d\u7f6e\u3010MsgConfig\u3011\u4e0d\u6b63\u786e,\u670d\u52a1\u4e0d\u542f\u52a8", (Object)serviceName);
            throw new Exception(String.valueOf(serviceName) + "\u62a5\u6587\u914d\u7f6e\u3010MsgConfig\u3011\u4e0d\u6b63\u786e,\u670d\u52a1\u4e0d\u542f\u52a8");
        }
        return (MsgConfig)xc.getBean(msgConfigs[0]);
    }
}

