/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.ssl;

import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class NewSslFactory {
    private String sslContextAlgorithm;
    private String keyStoreAlgorithm;
    private String trustManagerAlgorithm;

    public void iniAlgorithm(String sslContextAlgorithm, String keyStoreAlgorithm, String trustManagerAlgorithm) {
        this.sslContextAlgorithm = sslContextAlgorithm;
        this.trustManagerAlgorithm = trustManagerAlgorithm;
        this.keyStoreAlgorithm = keyStoreAlgorithm;
    }

    public SSLServerSocketFactory buildServerFactory(String keyStoreFile, String keyStorePwd, String keyPwd) throws Exception {
        KeyStore serverKeyStore = KeyStore.getInstance(this.keyStoreAlgorithm);
        try (FileInputStream ksInputStream = new FileInputStream(keyStoreFile);){
            serverKeyStore.load(ksInputStream, keyStorePwd.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.trustManagerAlgorithm);
        kmf.init(serverKeyStore, keyPwd.toCharArray());
        SSLContext sslContext = SSLContext.getInstance(this.sslContextAlgorithm);
        sslContext.init(kmf.getKeyManagers(), null, null);
        return sslContext.getServerSocketFactory();
    }

    public synchronized SSLServerSocketFactory buildServerFactory(String keyStoreFile, String keyStorePwd, String keyPwd, String trustKeyStoreFile, String trustKeyStorePwd) throws Exception {
        FileInputStream tsInputStream;
        KeyStore serverKeyStore = KeyStore.getInstance(this.keyStoreAlgorithm);
        try (FileInputStream ksInputStream = new FileInputStream(keyStoreFile);){
            serverKeyStore.load(ksInputStream, keyStorePwd.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.trustManagerAlgorithm);
        kmf.init(serverKeyStore, keyPwd.toCharArray());
        SSLContext sslContext = SSLContext.getInstance(this.sslContextAlgorithm);
        KeyStore serverTrustKeyStore = KeyStore.getInstance(this.keyStoreAlgorithm);
        if (!StringTools.isEmpty(trustKeyStoreFile) && !StringTools.isEmpty(trustKeyStorePwd)) {
            tsInputStream = new FileInputStream(trustKeyStoreFile);
            try {
                serverTrustKeyStore.load(tsInputStream, trustKeyStorePwd.toCharArray());
            }
            finally {
                ((InputStream)tsInputStream).close();
            }
        }
        tsInputStream = new FileInputStream(keyStoreFile);
        try {
            serverTrustKeyStore.load(tsInputStream, keyStorePwd.toCharArray());
        }
        finally {
            ((InputStream)tsInputStream).close();
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
        tmf.init(serverTrustKeyStore);
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext.getServerSocketFactory();
    }

    public SSLSocketFactory buildClientFactory(String keyStoreFile, String keyStorePwd, String keyPwd, String trustKeyStoreFile, String trustKeyStorePwd) throws Exception {
        KeyStore clientKeyStore = KeyStore.getInstance(this.keyStoreAlgorithm);
        try (FileInputStream ksInputStream = new FileInputStream(keyStoreFile);){
            clientKeyStore.load(ksInputStream, keyStorePwd.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.trustManagerAlgorithm);
        kmf.init(clientKeyStore, keyPwd.toCharArray());
        KeyStore clientTrustKeyStore = KeyStore.getInstance(this.keyStoreAlgorithm);
        try (FileInputStream tsInputStream = new FileInputStream(trustKeyStoreFile);){
            clientTrustKeyStore.load(tsInputStream, trustKeyStorePwd.toCharArray());
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
        tmf.init(clientTrustKeyStore);
        SSLContext ctx = SSLContext.getInstance(this.sslContextAlgorithm);
        ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return ctx.getSocketFactory();
    }

    public synchronized SSLSocketFactory buildClientFactory(String trustKeyStoreFile, String trustKeyStorePwd) throws Exception {
        KeyStore clientTrustKeyStore = KeyStore.getInstance(this.keyStoreAlgorithm);
        clientTrustKeyStore.load(new FileInputStream(trustKeyStoreFile), trustKeyStorePwd.toCharArray());
        SSLContext sc = SSLContext.getInstance(this.sslContextAlgorithm);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
        tmf.init(clientTrustKeyStore);
        sc.init(null, tmf.getTrustManagers(), null);
        return sc.getSocketFactory();
    }

    public synchronized SSLSocketFactory buildClientFactory() throws Exception {
        SSLContext sc = SSLContext.getInstance(this.sslContextAlgorithm);
        SSLHandler simpleVerifier = new SSLHandler();
        sc.init(null, new TrustManager[]{simpleVerifier}, null);
        return sc.getSocketFactory();
    }

    private static class SSLHandler
    implements X509TrustManager,
    HostnameVerifier {
        private SSLHandler() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }
}

