/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.out.mq;

import cn.com.yusys.yusp.bsp.communication.DataRequest;
import cn.com.yusys.yusp.bsp.communication.IDataAdapter;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.out.AbstractOutAdapter;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;

public class RabbitMQOutAdapter
extends AbstractOutAdapter
implements IDataAdapter {
    private static final String RabbitOUT_ADAPTER_NAME = "RabbitMQ\u63a5\u51fa\u9002\u914d\u5668";
    private String host;
    private int port;
    private String userId;
    private String password;
    private String recQName;
    private String sendQName;
    private String correlationQId;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Channel channel;
    private QueueingConsumer queueingConsumer;

    @Override
    public String getAdapterTypeName() {
        return RabbitOUT_ADAPTER_NAME;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.validateParams();
        this.rabbitfactoryInit();
    }

    @Override
    public IRequest makeRequest(Session session) throws Exception {
        try {
            if (this.connection == null) {
                this.connection = this.connectionFactory.newConnection();
                this.channel = this.connection.createChannel();
                this.queueingConsumer = new QueueingConsumer(this.channel);
                this.channel.basicConsume(this.recQName, true, (Consumer)this.queueingConsumer);
            }
        }
        catch (Exception e) {
            this.logger.error("{} @ \u53d1\u9001\u6d88\u606f\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
            throw new Exception(String.valueOf(this.getAdapterName()) + " @ \u53d1\u9001\u6d88\u606f\u5f02\u5e38", e);
        }
        DataRequest request = new DataRequest();
        request.setOutAdapter(this);
        request.setDatasourceWrapper(this.channel);
        return request;
    }

    @Override
    public void send(IRequest request) throws Exception {
        DataRequest req = (DataRequest)request;
        String sendQName = this.getSendQName();
        try {
            String correlationQId = StringTools.getString(OgnlTools.getValue(this.getCorrelationQId(), req.getContext()));
            if (StringTools.isEmpty(correlationQId)) {
                throw new Exception("\u5173\u8054\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            AMQP.BasicProperties props = new AMQP.BasicProperties.Builder().correlationId(correlationQId).replyTo(this.recQName).build();
            ((Channel)request.getDatasourceWrapper()).basicPublish("", sendQName, props, req.getData());
        }
        catch (Exception e) {
            this.logger.error("{} @ \u53d1\u9001\u6d88\u606f\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
            try {
                try {
                    this.channel.close();
                    this.connection.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                this.queueingConsumer = null;
                this.channel = null;
                this.connection = null;
            }
            catch (Exception e1) {
                this.logger.error(String.valueOf(this.getAdapterName()) + " @ \u5173\u95ed\u961f\u5217\u5f02\u5e38:", (Throwable)e1);
            }
            throw new Exception(String.valueOf(this.getAdapterName()) + " @ \u53d1\u9001\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    @Override
    public byte[] receive(IRequest request) throws Exception {
        DataRequest req = (DataRequest)request;
        byte[] msg = null;
        try {
            QueueingConsumer.Delivery delivery = this.queueingConsumer.nextDelivery(10000L);
            if (delivery == null) {
                throw new Exception("\u63a5\u6536\u6d88\u606f\u8d85\u65f6");
            }
            msg = delivery.getBody();
        }
        catch (Exception e) {
            this.logger.error("{} @ {}", new Object[]{this.getAdapterName(), e.getMessage()});
            try {
                this.channel.close();
                this.connection.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            this.queueingConsumer = null;
            this.channel = null;
            this.connection = null;
            throw new Exception(String.valueOf(this.getAdapterName()) + " @ \u63a5\u6536\u6d88\u606f\u5f02\u5e38", e);
        }
        return msg;
    }

    @Override
    public void unmakeRequest(IRequest request) throws Exception {
    }

    @Override
    public void doStop() throws Exception {
        try {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
            if (this.connection != null && this.connection.isOpen()) {
                this.connection.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.queueingConsumer = null;
        this.channel = null;
        this.connection = null;
        super.doStop();
    }

    private void validateParams() throws Exception {
        if (StringTools.isEmpty(this.getHost())) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u76d1\u542c\u5730\u5740\u672a\u914d\u7f6e!");
        }
        if (this.getPort() == 0) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u76d1\u542c\u7aef\u53e3\u672a\u914d\u7f6e!");
        }
        if (StringTools.isEmpty(this.getRecQName())) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u63a5\u6536\u961f\u5217\u540d\u79f0\u672a\u914d\u7f6e!");
        }
        if (StringTools.isEmpty(this.getSendQName())) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u53d1\u9001\u961f\u5217\u540d\u79f0\u672a\u914d\u7f6e!");
        }
    }

    private void rabbitfactoryInit() throws Exception {
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setHost(this.getHost());
        this.connectionFactory.setPort(this.getPort());
        this.connectionFactory.setUsername(this.getUserId());
        this.connectionFactory.setPassword(this.getPassword());
        this.connectionFactory.setVirtualHost("/");
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRecQName() {
        return this.recQName;
    }

    public void setRecQName(String recQName) {
        this.recQName = recQName;
    }

    public String getSendQName() {
        return this.sendQName;
    }

    public void setSendQName(String sendQName) {
        this.sendQName = sendQName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCorrelationQId() {
        return this.correlationQId;
    }

    public void setCorrelationQId(String correlationQId) {
        this.correlationQId = correlationQId;
    }
}

