/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.out.mq;

import cn.com.yusys.yusp.bsp.communication.DataRequest;
import cn.com.yusys.yusp.bsp.communication.IDataAdapter;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.impl.mq.MQTools;
import cn.com.yusys.yusp.bsp.communication.impl.pool.factory.MQToolsFactory;
import cn.com.yusys.yusp.bsp.communication.out.AbstractOutAdapter;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.core.VarDef;
import cn.com.yusys.yusp.bsp.toolkit.common.PwdTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class MQOutAdapter
extends AbstractOutAdapter
implements IDataAdapter {
    private static final String OUT_ADAPTER_NAME = "MQ\u63a5\u51fa\u9002\u914d\u5668";
    private static final int DEFAULT_RECEIVE_TIME_OUT = 60000;
    private boolean doBound;
    private String host;
    private int port;
    private String queueManager;
    private String channel;
    private String userId;
    private String password;
    private String recQName;
    private String sendQName;
    private int maxConnection;
    private int ccsid;
    private int charset;
    private int expiry;
    private int recTimeout;
    private String messageId;
    private String correlationId;
    private String applicationIdData;
    private boolean doReceive;
    private String matchFlag;
    protected GenericObjectPool<MQTools> _pool;
    protected MQToolsFactory factory;

    @Override
    public String getAdapterTypeName() {
        return OUT_ADAPTER_NAME;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.validateParams();
        long sessionTime = 10000L;
        this.factory = this.isDoBound() ? new MQToolsFactory(this.getCcsid(), this.getUserId(), PwdTools.decryptStr(this.getUserId(), this.getPassword()), this.getCharset(), this.getExpiry(), this.isDoBound()) : new MQToolsFactory(this.getHost(), this.getPort(), this.getChannel(), this.getCcsid(), this.getUserId(), PwdTools.decryptStr(this.getUserId(), this.getPassword()), this.getCharset(), this.getExpiry(), this.isDoBound());
        this._pool = new GenericObjectPool((PoolableObjectFactory)this.factory, this.maxConnection, 1, sessionTime);
        this._pool.setTestOnReturn(true);
        this._pool.setTestOnBorrow(true);
    }

    @Override
    public IRequest makeRequest(Session session) throws Exception {
        if (!this.isAlive()) {
            throw new Exception(String.valueOf(this.getAdapterName()) + " @ \u670d\u52a1\u5173\u95ed");
        }
        MQTools mqTool = (MQTools)this._pool.borrowObject();
        DataRequest request = new DataRequest();
        request.setOutAdapter(this);
        request.setDatasourceWrapper(mqTool);
        return request;
    }

    @Override
    public void send(IRequest request) throws Exception {
        DataRequest req = (DataRequest)request;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object objMessageId = null;
        Object objCorrelationId = null;
        Object objApplicationIdData = null;
        if (!StringTools.isEmpty(this.getMessageId()) && (objMessageId = OgnlTools.getValue(this.getMessageId(), req.getContext())) == null) {
            objMessageId = this.getDefaultMessageId(req.getContext());
        }
        if (!StringTools.isEmpty(this.getCorrelationId())) {
            objCorrelationId = OgnlTools.getValue(this.getCorrelationId(), req.getContext());
        }
        if (objCorrelationId == null) {
            objCorrelationId = objMessageId;
        }
        if (!StringTools.isEmpty(this.getApplicationIdData())) {
            objApplicationIdData = OgnlTools.getValue(this.getApplicationIdData(), req.getContext());
        }
        if ("messageId".equals(this.getMatchFlag())) {
            req.setMatchValue(objMessageId);
        } else {
            req.setMatchValue(objCorrelationId);
        }
        map.put("messageId", objMessageId);
        map.put("correlationId", objCorrelationId);
        map.put("applicationIdData", objApplicationIdData);
        MQTools mqTool = (MQTools)req.getDatasourceWrapper();
        try {
            mqTool.initSendQueue(this.getQueueManager(), this.getSendQName());
            mqTool.send(map, req.getData(), true);
        }
        catch (Exception e) {
            this.logger.error("{} @ {}", new Object[]{this.getAdapterName(), e.getMessage()});
            try {
                mqTool.close();
            }
            catch (Exception e1) {
                this.logger.error(String.valueOf(this.getAdapterName()) + " @ \u5173\u95ed\u961f\u5217\u5f02\u5e38:", (Throwable)e1);
            }
            throw new Exception(String.valueOf(this.getAdapterName()) + " @ \u53d1\u9001\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    @Override
    public byte[] receive(IRequest request) throws Exception {
        if (!this.isDoReceive()) {
            throw new Exception(String.valueOf(this.getAdapterName()) + "\u914d\u7f6e\u4e2d\u4e3a\u4e0d\u5efa\u7acb\u53d1\u9001\u901a\u9053\uff0c\u4e0d\u80fd\u505a\u4fe1\u606f\u53d1\u9001\uff01");
        }
        DataRequest req = (DataRequest)request;
        MQTools mqTool = (MQTools)req.getDatasourceWrapper();
        Map<String, Object> map = null;
        try {
            mqTool.initRecQueue(this.getQueueManager(), this.getRecQName());
            map = mqTool.receive(1, this.getRecTimeout(), this.getMatchFlag(), req.getMatchValue());
        }
        catch (Exception e) {
            this.logger.error("{} @ {}", new Object[]{this.getAdapterName(), e.getMessage()});
            try {
                mqTool.close();
            }
            catch (Exception e1) {
                this.logger.error(String.valueOf(this.getAdapterName()) + " @ \u5173\u95ed\u961f\u5217\u5f02\u5e38:", (Throwable)e1);
            }
            throw new Exception(String.valueOf(this.getAdapterName()) + " @ \u63a5\u6536\u6d88\u606f\u5f02\u5e38", e);
        }
        if (!StringTools.isEmpty(this.getMessageId())) {
            OgnlTools.setValue(this.getMessageId(), map.remove("messageId"), req.getContext());
        }
        if (!StringTools.isEmpty(this.getCorrelationId())) {
            OgnlTools.setValue(this.getCorrelationId(), map.remove("correlationId"), req.getContext());
        }
        if (!StringTools.isEmpty(this.getApplicationIdData())) {
            OgnlTools.setValue(this.getApplicationIdData(), map.remove("applicationIdData"), req.getContext());
        }
        return (byte[])map.remove("message");
    }

    @Override
    public void unmakeRequest(IRequest request) throws Exception {
        MQTools mqTools = (MQTools)request.getDatasourceWrapper();
        mqTools.setCloseFlag(request.needToClose());
        this._pool.returnObject((Object)mqTools);
    }

    @Override
    public void doStop() throws Exception {
        this._pool.close();
        this.factory = null;
    }

    private void validateParams() throws Exception {
        if (!this.isDoBound()) {
            if (StringTools.isEmpty(this.getHost())) {
                throw new Exception(String.valueOf(this.getAdapterName()) + " @ \u670d\u52a1\u5730\u5740\u672a\u914d\u7f6e!");
            }
            if (StringTools.isEmpty(this.getChannel())) {
                throw new Exception(String.valueOf(this.getAdapterName()) + " @ \u8fde\u63a5\u901a\u9053\u672a\u914d\u7f6e!");
            }
        }
        if (this.getPort() == 0) {
            throw new Exception(String.valueOf(this.getAdapterName()) + " @ \u76d1\u542c\u7aef\u53e3\u672a\u914d\u7f6e!");
        }
        if (StringTools.isEmpty(this.getQueueManager())) {
            throw new Exception(String.valueOf(this.getAdapterName()) + " @ \u961f\u5217\u7ba1\u7406\u5668\u672a\u914d\u7f6e!");
        }
        if (StringTools.isEmpty(this.getSendQName())) {
            throw new Exception(String.valueOf(this.getAdapterName()) + " @ \u53d1\u9001\u961f\u5217\u540d\u79f0\u672a\u914d\u7f6e!");
        }
        if (this.isDoReceive() && StringTools.isEmpty(this.getRecQName())) {
            throw new Exception(String.valueOf(this.getAdapterName()) + " @ \u5efa\u7acb\u63a5\u6536\u901a\u9053\u65f6\uff0c\u9700\u8981\u914d\u7f6e\u63a5\u6536\u961f\u5217\u540d\u79f0!");
        }
        if (this.getCcsid() == 0) {
            this.setCcsid(1381);
        }
        if (this.getRecTimeout() <= 0) {
            this.setRecTimeout(60000);
        }
        if (this.getMaxConnection() <= 0) {
            this.setMaxConnection(1);
        }
    }

    private byte[] getDefaultMessageId(Map<String, Object> context) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer(24);
        sb.append(StringTools.getString(context.get("G_SN")));
        sb.append("_");
        sb.append(VarDef.G_LOCALHOST);
        return sb.toString().getBytes();
    }

    public boolean isDoBound() {
        return this.doBound;
    }

    public void setDoBound(boolean doBound) {
        this.doBound = doBound;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getRecQName() {
        return this.recQName;
    }

    public void setRecQName(String recQName) {
        this.recQName = recQName;
    }

    public String getSendQName() {
        return this.sendQName;
    }

    public void setSendQName(String sendQName) {
        this.sendQName = sendQName;
    }

    public int getRecTimeout() {
        return this.recTimeout;
    }

    public void setRecTimeout(int recTimeout) {
        this.recTimeout = recTimeout;
    }

    public int getCcsid() {
        return this.ccsid;
    }

    public void setCcsid(int ccsid) {
        this.ccsid = ccsid;
    }

    public int getCharset() {
        return this.charset;
    }

    public void setCharset(int charset) {
        this.charset = charset;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public void setExpiry(int expiry) {
        this.expiry = expiry;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getMatchFlag() {
        return this.matchFlag;
    }

    public void setMatchFlag(String matchFlag) {
        this.matchFlag = matchFlag;
    }

    public boolean isDoReceive() {
        return this.doReceive;
    }

    public void setDoReceive(boolean doReceive) {
        this.doReceive = doReceive;
    }

    public String getApplicationIdData() {
        return this.applicationIdData;
    }

    public void setApplicationIdData(String applicationIdData) {
        this.applicationIdData = applicationIdData;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

