/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.tcp;

import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.toolkit.common.SocketTools;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;

public abstract class TCPInAdapter
extends AbstractInAdapter {
    protected int backlog = 4096;
    protected String host;
    protected int port;
    protected int timeout = 60000;
    protected boolean reuseAddress = false;
    protected ServerSocket server;

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (this.getHost() == null || this.getHost().length() == 0) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ Service address is not configured!");
        }
        if (this.getPort() == 0) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ Listen port is not configured!");
        }
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    protected void createServerSocket() throws Exception {
        InetAddress addr = InetAddress.getByName(this.getHost());
        this.server = SocketTools.createServerSocket(this.reuseAddress);
        try {
            this.server.bind(new InetSocketAddress(addr, this.getPort()), this.backlog);
            this.logger.info("Start port listening: {}", (Object)this.getPort());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.getSid()) + " @ Binding port error:" + new InetSocketAddress(addr, this.getPort()), e);
        }
    }

    protected boolean checkSocketWrapper(SocketWrapper wrapper) throws Exception {
        return true;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }
}

