/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.ssl;

import cn.com.yusys.yusp.bsp.communication.impl.in.tcp.ShortServerInAdapter;
import cn.com.yusys.yusp.bsp.communication.impl.ssl.NewSslFactory;
import cn.com.yusys.yusp.bsp.toolkit.common.PwdTools;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class NewSslShortServerInAdapter
extends ShortServerInAdapter {
    private String keyStoreFile;
    private String keyStorePwd;
    private String keyPwd;
    private String trustKeyStoreFile;
    private String trustKeyStorePwd;
    private boolean duplexAuth = false;
    private String sslContextAlgorithm;
    private String keyStoreAlgorithm;
    private String trustManagerAlgorithm;
    private String IN_ADAPTER_NAME = "SSL\u77ed\u8fde\u63a5\u670d\u52a1\u7aef\u63a5\u5165\u9002\u914d\u5668";

    @Override
    public void doStart() throws Exception {
        this.logger.debug("{} @ \u5bc6\u94a5\u5e93\u8def\u5f84\uff1a{}", (Object)this.getAdapterTypeName(), (Object)this.keyStoreFile);
        this.logger.debug("{} @ \u4fe1\u4efb\u5bc6\u94a5\u5e93\u8def\u5f84\uff1a{}", (Object)this.getAdapterTypeName(), (Object)this.trustKeyStoreFile);
        this.logger.debug("{} @ \u662f\u5426\u53cc\u5411\u6388\u6743\uff1a{}", (Object)this.getAdapterTypeName(), (Object)this.duplexAuth);
        this.keyStorePwd = PwdTools.decryptStr(this.keyStoreFile, this.keyStorePwd);
        this.keyPwd = PwdTools.decryptStr(this.keyStoreFile, this.keyPwd);
        this.trustKeyStorePwd = PwdTools.decryptStr(this.trustKeyStoreFile, this.trustKeyStorePwd);
        super.doStart();
    }

    @Override
    protected void createServerSocket() throws Exception {
        NewSslFactory sslFactory = new NewSslFactory();
        sslFactory.iniAlgorithm(this.sslContextAlgorithm, this.keyStoreAlgorithm, this.trustManagerAlgorithm);
        SSLServerSocketFactory serverSocketFactory = this.duplexAuth ? sslFactory.buildServerFactory(this.keyStoreFile, this.keyStorePwd, this.keyPwd, this.trustKeyStoreFile, this.trustKeyStorePwd) : sslFactory.buildServerFactory(this.keyStoreFile, this.keyStorePwd, this.keyPwd);
        SSLServerSocket ssLServerSocket = (SSLServerSocket)serverSocketFactory.createServerSocket();
        ssLServerSocket.setNeedClientAuth(this.duplexAuth);
        this.server = ssLServerSocket;
        InetAddress addr = InetAddress.getByName(this.host);
        try {
            this.server.bind(new InetSocketAddress(addr, this.port));
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.getSid()) + " @ \u7ed1\u5b9a\u7aef\u53e3\u9519\u8bef:" + new InetSocketAddress(addr, this.getPort()), e);
        }
    }

    @Override
    public String getAdapterTypeName() {
        return this.IN_ADAPTER_NAME;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePwd() {
        return this.keyStorePwd;
    }

    public void setKeyStorePwd(String keyStorePwd) {
        this.keyStorePwd = keyStorePwd;
    }

    public String getKeyPwd() {
        return this.keyPwd;
    }

    public void setKeyPwd(String keyPwd) {
        this.keyPwd = keyPwd;
    }

    public String getTrustKeyStoreFile() {
        return this.trustKeyStoreFile;
    }

    public void setTrustKeyStoreFile(String trustKeyStoreFile) {
        this.trustKeyStoreFile = trustKeyStoreFile;
    }

    public String getTrustKeyStorePwd() {
        return this.trustKeyStorePwd;
    }

    public void setTrustKeyStorePwd(String trustKeyStorePwd) {
        this.trustKeyStorePwd = trustKeyStorePwd;
    }

    public boolean isDuplexAuth() {
        return this.duplexAuth;
    }

    public void setDuplexAuth(boolean duplexAuth) {
        this.duplexAuth = duplexAuth;
    }

    public String getSslContextAlgorithm() {
        return this.sslContextAlgorithm;
    }

    public void setSslContextAlgorithm(String sslContextAlgorithm) {
        this.sslContextAlgorithm = sslContextAlgorithm;
    }

    public String getKeyStoreAlgorithm() {
        return this.keyStoreAlgorithm;
    }

    public void setKeyStoreAlgorithm(String keyStoreAlgorithm) {
        this.keyStoreAlgorithm = keyStoreAlgorithm;
    }

    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm;
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.trustManagerAlgorithm = trustManagerAlgorithm;
    }
}

