/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.schedule;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.MapRequest;
import cn.com.yusys.yusp.bsp.communication.impl.in.schedule.CronExpression;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.resources.creator.impl.JobCreator;
import cn.com.yusys.yusp.bsp.schema.mapping.Item;
import cn.com.yusys.yusp.bsp.schema.mapping.Mapping;
import cn.com.yusys.yusp.bsp.schema.mapping.Mappings;
import cn.com.yusys.yusp.bsp.schema.mapping.Property;
import cn.com.yusys.yusp.bsp.toolkit.common.FileChecker;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class ScheduleInAdapter
extends AbstractInAdapter
implements Runnable {
    private static final String IN_ADAPTER_NAME = "\u5b9a\u65f6\u8c03\u5ea6\u63a5\u5165\u9002\u914d\u5668";
    private TreeSet<JobDescriptor> jobSet;
    private static final String JOB_CONFIG_FILE = "schdl.mps";
    private long interval = 60000L;
    private Map<String, Mappings> resourceMap = new ConcurrentHashMap<String, Mappings>();
    private ReentrantLock reenLock = new ReentrantLock();
    private boolean open;
    private Thread scheduleThread;
    ReentrantLock lk = new ReentrantLock();

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public static String getInAdapterName() {
        return IN_ADAPTER_NAME;
    }

    @Override
    public String getAdapterTypeName() {
        return IN_ADAPTER_NAME;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (!this.isOpen()) {
            this.logger.debug("{} @ \u5b9a\u65f6\u5668\u5173\u95ed,\u672a\u542f\u52a8", (Object)this.getAdapterTypeName());
            this.setAlive(false);
            return;
        }
        this.jobSet = new TreeSet<JobDescriptor>(new Comparator<JobDescriptor>(){

            @Override
            public int compare(JobDescriptor job1, JobDescriptor job2) {
                int result = job1.getNextExTime().compareTo(job2.getNextExTime());
                if (result == 0) {
                    result = job1.getName().compareTo(job2.getName());
                }
                return result;
            }
        });
        try {
            this.getJobs();
        }
        catch (Exception e) {
            this.logger.error(String.valueOf(this.getAdapterTypeName()) + " @ \u52a0\u8f7d\u5b9a\u65f6\u8c03\u5ea6\u6587\u4ef6\u5f02\u5e38:", (Throwable)e);
        }
        this.scheduleThread = new Thread(this);
        this.scheduleThread.start();
    }

    public void getJobs() throws Exception {
        block16: {
            String jobFilePath = this.getJobFilePath();
            boolean change = FileChecker.getInstance(this.getBundlerId()).isChanged(this.getJobFilePath());
            Mappings mappings = this.resourceMap.get(jobFilePath);
            if (mappings == null || change) {
                this.reenLock.lock();
                try {
                    mappings = this.resourceMap.get(jobFilePath);
                    if (mappings != null && !change) break block16;
                    this.jobSet.clear();
                    this.logger.debug("{} @ \u52a0\u8f7d\u4efb\u52a1\u914d\u7f6e\u6587\u4ef6\uff1a{}", new Object[]{this.getAdapterTypeName(), jobFilePath});
                    JobCreator creator = new JobCreator();
                    mappings = (Mappings)creator.createResource(jobFilePath);
                    this.resourceMap.put(jobFilePath, mappings);
                    Mapping[] maps = mappings.getMapping();
                    Item[] items = maps[0].getItems().getItem();
                    int i = 0;
                    while (i < items.length) {
                        Property[] propertys = items[i].getProperty();
                        String isEffect = null;
                        String jobName = null;
                        String tranCode = null;
                        String cronExpression = null;
                        int j = 0;
                        while (j < propertys.length) {
                            if (propertys[j].getName().equals("jobName")) {
                                jobName = propertys[j].getValue();
                            } else if (propertys[j].getName().equals("tranCode")) {
                                tranCode = propertys[j].getValue();
                            } else if (propertys[j].getName().equals("cronExpression")) {
                                cronExpression = propertys[j].getValue();
                            } else if (propertys[j].getName().equals("isEffect")) {
                                isEffect = propertys[j].getValue();
                            }
                            ++j;
                        }
                        if ("true".equals(isEffect)) {
                            JobDescriptor jobDes = new JobDescriptor();
                            jobDes.setCronExpression(cronExpression);
                            jobDes.setName(jobName);
                            jobDes.setTransCode(tranCode);
                            try {
                                jobDes.setNextExTime(this.computeNextExecTime(jobDes, true));
                                this.logger.debug("{} @ \u52a0\u8f7d\u4efb\u52a1\uff1a{}", new Object[]{this.getAdapterTypeName(), jobName});
                                this.jobSet.add(jobDes);
                            }
                            catch (ParseException e) {
                                this.logger.error(String.valueOf(this.getAdapterTypeName()) + " @ job:[" + jobDes.getName() + "],\u65f6\u95f4\u8868\u8fbe\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e:[" + jobDes.getCronExpression() + "]", (Throwable)e);
                            }
                        }
                        ++i;
                    }
                }
                finally {
                    this.reenLock.unlock();
                }
            }
        }
    }

    public String getJobFilePath() {
        String BundlerPath = this.getBundlerId().replaceAll("[.]", "/");
        String jobFilePath = "config/" + BundlerPath + "/" + JOB_CONFIG_FILE;
        return jobFilePath;
    }

    public Date computeNextExecTime(JobDescriptor job, boolean isFirstTime) throws ParseException {
        Date thisTime = isFirstTime ? new Date() : job.getNextExTime();
        Date nexTime = new CronExpression(job.getCronExpression()).getNextValidTimeAfter(thisTime);
        return nexTime;
    }

    @Override
    public IRequest makeRequest() throws Exception {
        MapRequest req = new MapRequest(new HashMap<String, Object>());
        req.setInAdapter(this);
        this.reenLock.lock();
        try {
            if (this.jobSet.size() > 0) {
                this.lk.lock();
                JobDescriptor job = this.jobSet.pollFirst();
                this.lk.unlock();
                Date now = new Date();
                if (now.after(job.getNextExTime()) || now.equals(job.getNextExTime())) {
                    block16: {
                        req.getContext().put("G_TRANSCODE", job.getTransCode());
                        try {
                            job.setNextExTime(this.computeNextExecTime(job, false));
                            this.lk.lock();
                            this.jobSet.add(job);
                            this.lk.unlock();
                        }
                        catch (ParseException e) {
                            if (!this.logger.isDebugEnabled()) break block16;
                            this.logger.debug(String.valueOf(this.getAdapterTypeName()) + " @ job:" + job.getName() + ",\u65f6\u95f4\u8868\u8fbe\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e", (Throwable)e);
                        }
                    }
                    MapRequest mapRequest = req;
                    return mapRequest;
                }
                this.lk.lock();
                this.jobSet.add(job);
                this.lk.unlock();
                Date curr = new Date();
                long timeDiff = job.getNextExTime().getTime() - curr.getTime();
                long toSleep = timeDiff >= this.interval ? this.interval : (timeDiff >= 0L ? timeDiff : 0L);
                this.getJobs();
                try {
                    Thread.sleep(toSleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
            this.logger.debug("{} @ \u6ca1\u6709\u5b9a\u65f6\u4efb\u52a1\u52a0\u8f7d", (Object)this.getAdapterTypeName());
            try {
                try {
                    this.getJobs();
                }
                catch (Exception e) {
                    this.logger.error(String.valueOf(this.getAdapterTypeName()) + " @ \u52a0\u8f7d\u5b9a\u65f6\u8c03\u5ea6\u6587\u4ef6\u5f02\u5e38:", (Throwable)e);
                    Thread.sleep(this.interval);
                }
            }
            finally {
                Thread.sleep(this.interval);
            }
            return null;
        }
        finally {
            this.reenLock.unlock();
        }
    }

    @Override
    public void unmakeRequest(IRequest req) throws Exception {
        req.close();
    }

    public boolean resetJobNextTimeNow(String jobName) {
        boolean ret = false;
        Date date = new Date();
        this.lk.lock();
        try {
            for (JobDescriptor jd : this.jobSet) {
                if (!jd.getName().equals(jobName)) continue;
                if (date.before(jd.getNextExTime())) {
                    this.jobSet.remove(jd);
                    jd.setNextExTime(new Date());
                    this.jobSet.add(jd);
                    ret = true;
                } else {
                    this.logger.debug("\u5ffd\u7565\u672c\u6b21Timer\u8c03\u5ea6\uff1a" + jd);
                }
                break;
            }
        }
        finally {
            this.lk.unlock();
        }
        return ret;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public Thread getScheduleThread() {
        return this.scheduleThread;
    }

    public void setScheduleThread(Thread scheduleThread) {
        this.scheduleThread = scheduleThread;
    }

    static class JobDescriptor {
        private Date nextExTime;
        private String name;
        private String cronExpression;
        private String transCode;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JobDescriptor other = (JobDescriptor)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public JobDescriptor() {
        }

        public JobDescriptor(String name, String cronExpression, String transCode) {
            this.name = name;
            this.cronExpression = cronExpression;
            this.transCode = transCode;
            this.nextExTime = new Date();
        }

        public void setTransCode(String transCode) {
            this.transCode = transCode;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCronExpression() {
            return this.cronExpression;
        }

        public void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        public String getTransCode() {
            return this.transCode;
        }

        public Date getNextExTime() {
            return this.nextExTime;
        }

        public void setNextExTime(Date nextExTime) {
            this.nextExTime = nextExTime;
        }
    }
}

